/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class PolarizedArmor {
    public static float EFFECTIVE_ARMOR_BONUS = 50.0f;
    public static float EMP_BONUS_PERCENT = 50.0f;
    public static float VENT_RATE_BONUS = 25.0f;
    public static float NON_SHIELD_FLUX_LEVEL = 50.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            return "\n\n*Ships without a shield or a phase cloak are treated as always having " + (int)NON_SHIELD_FLUX_LEVEL + "% hard flux.";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        @Override
        public String[] getHighlights() {
            return new String[]{(int)NON_SHIELD_FLUX_LEVEL + "%"};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxArmorDamageReduction().modifyFlat(id, 0.05f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxArmorDamageReduction().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Maximum damage reduction by armor increased from 85% to 90%";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements AfterShipCreationSkillEffect {
        @Override
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new PolarizedArmorEffectMod(ship, id));
        }

        @Override
        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            MutableShipStatsAPI stats = ship.getMutableStats();
            ship.removeListenerOfClass(PolarizedArmorEffectMod.class);
            stats.getEffectiveArmorBonus().unmodify(id);
            stats.getEmpDamageTakenMult().unmodify(id);
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        @Override
        public String getEffectDescription(float level) {
            return "Up to +" + (int)EFFECTIVE_ARMOR_BONUS + "% armor for damage reduction calculation only, based on current hard flux level*";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        @Override
        public String getEffectDescription(float level) {
            return "EMP damage taken reduced by up to " + Math.round(EMP_BONUS_PERCENT) + "%, based on current hard flux level*";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getVentRateMult().modifyPercent(id, VENT_RATE_BONUS);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getVentRateMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)VENT_RATE_BONUS + "% flux dissipation rate while venting";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class PolarizedArmorEffectMod
    implements DamageTakenModifier,
    AdvanceableListener {
        protected ShipAPI ship;
        protected String id;

        public PolarizedArmorEffectMod(ShipAPI ship, String id) {
            this.ship = ship;
            this.id = id;
        }

        @Override
        public void advance(float amount) {
            MutableShipStatsAPI stats = this.ship.getMutableStats();
            float fluxLevel = this.ship.getHardFluxLevel();
            if (!(this.ship.getShield() != null || this.ship.getHullSpec().isPhase() || this.ship.getPhaseCloak() != null && this.ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.PHASE))) {
                fluxLevel = NON_SHIELD_FLUX_LEVEL * 0.01f;
            }
            float armorBonus = EFFECTIVE_ARMOR_BONUS * fluxLevel;
            float empBonus = EMP_BONUS_PERCENT * fluxLevel;
            stats.getEffectiveArmorBonus().modifyPercent(this.id, armorBonus);
            stats.getEmpDamageTakenMult().modifyMult(this.id, 1.0f - empBonus * 0.01f);
            Color c = this.ship.getSpriteAPI().getAverageColor();
            c = Misc.setAlpha(c, 127);
            float b = 0.0f;
            if (fluxLevel > 0.75f) {
                b = 1.0f * (fluxLevel - 0.75f) / 0.25f;
            }
            if (b > 0.0f) {
                this.ship.setJitter(this, c, 1.0f * fluxLevel * b, 1, 0.0f);
            }
        }

        @Override
        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            return null;
        }
    }
}

