/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.AuroraRenderer;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.RangeBlockerUtil;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.util.vector.Vector2f;

public class SpatialAnomalyTerrainPlugin
extends BaseRingTerrain
implements AuroraRenderer.AuroraRendererDelegate {
    protected transient SpriteAPI texture = null;
    protected SpatialAnomalyParams params;
    protected float elapsed;
    protected AuroraRenderer renderer;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.noneOf(CampaignEngineLayers.class);
    protected transient float phase = 0.0f;

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (SpatialAnomalyParams)param;
        this.name = "Spatial Anomaly";
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);
        this.texture = Global.getSettings().getSprite("terrain", "aurora");
        if (this.renderer == null) {
            this.renderer = new AuroraRenderer(this);
        }
        return this;
    }

    @Override
    Object writeReplace() {
        return this;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float period = (float)Math.PI * 2;
        this.phase += period / 10.0f * amount;
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsed += days;
        if (this.elapsed >= 0.3f) {
            this.params.source = null;
        }
        if (this.elapsed >= this.params.dur) {
            this.getEntity().setExpired(true);
        }
        this.renderer.advance(amount);
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        float left = this.params.dur - this.elapsed;
        if (left < 0.0f) {
            left = 0.0f;
        }
        if (left < 0.1f) {
            alphaMult *= left / 0.1f;
        }
        if (this.elapsed < 0.1f) {
            alphaMult *= this.elapsed / 0.1f;
        }
        this.renderer.render(alphaMult);
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity == this.params.source) {
            return;
        }
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            float penalty = 0.5f;
            fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_1", "Inside " + this.getTerrainName().toLowerCase(), 1.0f - penalty, fleet.getStats().getFleetwideMaxBurnMod());
        }
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        return super.containsPoint(point, radius);
    }

    @Override
    public boolean hasTooltip() {
        return false;
    }

    @Override
    public String getTerrainName() {
        return super.getTerrainName();
    }

    @Override
    public String getNameForTooltip() {
        return this.getTerrainName();
    }

    @Override
    public String getEffectCategory() {
        return "spatial_anomaly";
    }

    @Override
    public boolean canPlayerHoldStationIn() {
        return false;
    }

    @Override
    public float getAuroraAlphaMultForAngle(float angle) {
        return 1.0f;
    }

    @Override
    public float getAuroraBandWidthInTexture() {
        return 256.0f;
    }

    @Override
    public RangeBlockerUtil getAuroraBlocker() {
        return null;
    }

    @Override
    public Vector2f getAuroraCenterLoc() {
        return this.getEntity().getLocation();
    }

    @Override
    public Color getAuroraColorForAngle(float angle) {
        return new Color(255, 165, 100, 255);
    }

    @Override
    public float getAuroraInnerOffsetMult(float angle) {
        return 1.0f;
    }

    @Override
    public float getAuroraInnerRadius() {
        return 50.0f;
    }

    @Override
    public float getAuroraOuterRadius() {
        return this.params.bandWidthInEngine;
    }

    @Override
    public float getAuroraShortenMult(float angle) {
        return 0.5f;
    }

    @Override
    public float getAuroraTexPerSegmentMult() {
        return 1.0f;
    }

    @Override
    public SpriteAPI getAuroraTexture() {
        return this.texture;
    }

    @Override
    public float getAuroraThicknessFlat(float angle) {
        return 0.0f;
    }

    @Override
    public float getAuroraThicknessMult(float angle) {
        return 1.0f;
    }

    public static class SpatialAnomalyParams
    extends BaseRingTerrain.RingParams {
        public float dur;
        public CampaignFleetAPI source;

        public SpatialAnomalyParams(CampaignFleetAPI source, float dur, float bandWidthInEngine, SectorEntityToken relatedEntity) {
            super(bandWidthInEngine, bandWidthInEngine / 2.0f, relatedEntity);
            this.source = source;
            this.dur = dur;
        }
    }
}

