/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.MineStrikeStatsAIInfoProvider;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class MineStrikeStats
extends BaseShipSystemScript
implements MineStrikeStatsAIInfoProvider {
    protected static float MINE_RANGE = 1000.0f;
    public static final float MIN_SPAWN_DIST = 75.0f;
    public static final float MIN_SPAWN_DIST_FRIGATE = 110.0f;
    public static final float LIVE_TIME = 5.0f;
    public static final Color JITTER_COLOR = new Color(255, 155, 255, 75);
    public static final Color JITTER_UNDER_COLOR = new Color(255, 155, 255, 155);

    public static float getRange(ShipAPI ship) {
        if (ship == null) {
            return MINE_RANGE;
        }
        return ship.getMutableStats().getSystemRangeBonus().computeEffective(MINE_RANGE);
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        block7: {
            ShipAPI ship = null;
            if (!(stats.getEntity() instanceof ShipAPI)) {
                return;
            }
            ship = (ShipAPI)stats.getEntity();
            float jitterLevel = effectLevel;
            if (state == ShipSystemStatsScript.State.OUT) {
                jitterLevel *= jitterLevel;
            }
            float maxRangeBonus = 25.0f;
            float jitterRangeBonus = jitterLevel * maxRangeBonus;
            ship.setJitterUnder(this, JITTER_UNDER_COLOR, jitterLevel, 11, 0.0f, 3.0f + jitterRangeBonus);
            ship.setJitter(this, JITTER_COLOR, jitterLevel, 4, 0.0f, 0.0f + jitterRangeBonus);
            if (state == ShipSystemStatsScript.State.IN) break block7;
            if (effectLevel >= 1.0f) {
                Vector2f target = ship.getMouseTarget();
                if (ship.getShipAI() != null && ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS)) {
                    target = (Vector2f)ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS);
                }
                if (target != null) {
                    float max;
                    float dist = Misc.getDistance(ship.getLocation(), target);
                    if (dist > (max = this.getMaxRange(ship) + ship.getCollisionRadius())) {
                        float dir = Misc.getAngleInDegrees(ship.getLocation(), target);
                        target = Misc.getUnitVectorAtDegreeAngle(dir);
                        target.scale(max);
                        Vector2f.add((Vector2f)target, (Vector2f)ship.getLocation(), (Vector2f)target);
                    }
                    if ((target = this.findClearLocation(ship, target)) != null) {
                        this.spawnMine(ship, target);
                    }
                }
            }
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    public void spawnMine(ShipAPI source, Vector2f mineLoc) {
        float start;
        CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f currLoc = Misc.getPointAtRadius(mineLoc, 30.0f + (float)Math.random() * 30.0f);
        float angle = start = (float)Math.random() * 360.0f;
        while (angle < start + 390.0f) {
            if (angle != start) {
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
                loc.scale(50.0f + (float)Math.random() * 30.0f);
                currLoc = Vector2f.add((Vector2f)mineLoc, (Vector2f)loc, (Vector2f)new Vector2f());
            }
            for (MissileAPI other : Global.getCombatEngine().getMissiles()) {
                float dist;
                if (!other.isMine() || !((dist = Misc.getDistance(currLoc, other.getLocation())) < other.getCollisionRadius() + 40.0f)) continue;
                currLoc = null;
                break;
            }
            if (currLoc != null) break;
            angle += 30.0f;
        }
        if (currLoc == null) {
            currLoc = Misc.getPointAtRadius(mineLoc, 30.0f + (float)Math.random() * 30.0f);
        }
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, "minelayer2", currLoc, (float)Math.random() * 360.0f, null);
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.MISSILE, false, mine.getDamage());
        }
        float fadeInTime = 0.5f;
        mine.getVelocity().scale(0.0f);
        mine.fadeOutThenIn(fadeInTime);
        Global.getCombatEngine().addPlugin(this.createMissileJitterPlugin(mine, fadeInTime));
        float liveTime = 5.0f;
        mine.setFlightTime(mine.getMaxFlightTime() - liveTime);
        Global.getSoundPlayer().playSound("mine_teleport", 1.0f, 1.0f, mine.getLocation(), mine.getVelocity());
    }

    protected EveryFrameCombatPlugin createMissileJitterPlugin(final MissileAPI mine, final float fadeInTime) {
        return new BaseEveryFrameCombatPlugin(){
            float elapsed = 0.0f;

            @Override
            public void advance(float amount, List<InputEventAPI> events) {
                if (Global.getCombatEngine().isPaused()) {
                    return;
                }
                this.elapsed += amount;
                float jitterLevel = mine.getCurrentBaseAlpha();
                jitterLevel = jitterLevel < 0.5f ? (jitterLevel *= 2.0f) : (1.0f - jitterLevel) * 2.0f;
                float jitterRange = 1.0f - mine.getCurrentBaseAlpha();
                float maxRangeBonus = 50.0f;
                float jitterRangeBonus = jitterRange * maxRangeBonus;
                Color c = JITTER_UNDER_COLOR;
                c = Misc.setAlpha(c, 70);
                mine.setJitter(this, c, jitterLevel, 15, jitterRangeBonus * 0.0f, jitterRangeBonus);
                if (jitterLevel >= 1.0f || this.elapsed > fadeInTime) {
                    Global.getCombatEngine().removePlugin(this);
                }
            }
        };
    }

    protected float getMaxRange(ShipAPI ship) {
        return this.getMineRange(ship);
    }

    @Override
    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (system.isOutOfAmmo()) {
            return null;
        }
        if (system.getState() != ShipSystemAPI.SystemState.IDLE) {
            return null;
        }
        Vector2f target = ship.getMouseTarget();
        if (target != null) {
            float max;
            float dist = Misc.getDistance(ship.getLocation(), target);
            if (dist > (max = this.getMaxRange(ship) + ship.getCollisionRadius())) {
                return "OUT OF RANGE";
            }
            return "READY";
        }
        return null;
    }

    @Override
    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        return ship.getMouseTarget() != null;
    }

    private Vector2f findClearLocation(ShipAPI ship, Vector2f dest) {
        if (this.isLocationClear(dest)) {
            return dest;
        }
        float incr = 50.0f;
        WeightedRandomPicker<Vector2f> tested = new WeightedRandomPicker<Vector2f>();
        float distIndex = 1.0f;
        while (distIndex <= 32.0f) {
            float start;
            float angle = start = (float)Math.random() * 360.0f;
            while (angle < start + 360.0f) {
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
                loc.scale(incr * distIndex);
                Vector2f.add((Vector2f)dest, (Vector2f)loc, (Vector2f)loc);
                tested.add(loc);
                if (this.isLocationClear(loc)) {
                    return loc;
                }
                angle += 60.0f;
            }
            distIndex *= 2.0f;
        }
        if (tested.isEmpty()) {
            return dest;
        }
        return (Vector2f)tested.pick();
    }

    private boolean isLocationClear(Vector2f loc) {
        for (ShipAPI shipAPI : Global.getCombatEngine().getShips()) {
            if (shipAPI.isShuttlePod() || shipAPI.isFighter()) continue;
            Vector2f otherLoc = shipAPI.getShieldCenterEvenIfNoShield();
            float otherR = shipAPI.getShieldRadiusEvenIfNoShield();
            if (shipAPI.isPiece()) {
                otherLoc = shipAPI.getLocation();
                otherR = shipAPI.getCollisionRadius();
            }
            float dist = Misc.getDistance(loc, otherLoc);
            float r = otherR;
            float checkDist = 75.0f;
            if (shipAPI.isFrigate()) {
                checkDist = 110.0f;
            }
            if (!(dist < r + checkDist)) continue;
            return false;
        }
        for (CombatEntityAPI combatEntityAPI : Global.getCombatEngine().getAsteroids()) {
            float dist = Misc.getDistance(loc, combatEntityAPI.getLocation());
            if (!(dist < combatEntityAPI.getCollisionRadius() + 75.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getFuseTime() {
        return 3.0f;
    }

    @Override
    public float getMineRange(ShipAPI ship) {
        return MineStrikeStats.getRange(ship);
    }
}

