/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;

public class TemporalShellStats
extends BaseShipSystemScript {
    public static final float MAX_TIME_MULT = 3.0f;
    public static final float MIN_TIME_MULT = 0.1f;
    public static final float DAM_MULT = 0.1f;
    public static final Color JITTER_COLOR = new Color(90, 165, 255, 55);
    public static final Color JITTER_UNDER_COLOR = new Color(90, 165, 255, 155);

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        boolean player = false;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        player = ship == Global.getCombatEngine().getPlayerShip();
        id = String.valueOf(id) + "_" + ship.getId();
        float jitterLevel = effectLevel;
        float jitterRangeBonus = 0.0f;
        float maxRangeBonus = 10.0f;
        if (state == ShipSystemStatsScript.State.IN) {
            jitterLevel = effectLevel / (1.0f / ship.getSystem().getChargeUpDur());
            if (jitterLevel > 1.0f) {
                jitterLevel = 1.0f;
            }
            jitterRangeBonus = jitterLevel * maxRangeBonus;
        } else if (state == ShipSystemStatsScript.State.ACTIVE) {
            jitterLevel = 1.0f;
            jitterRangeBonus = maxRangeBonus;
        } else if (state == ShipSystemStatsScript.State.OUT) {
            jitterRangeBonus = jitterLevel * maxRangeBonus;
        }
        jitterLevel = (float)Math.sqrt(jitterLevel);
        effectLevel *= effectLevel;
        ship.setJitter(this, JITTER_COLOR, jitterLevel, 3, 0.0f, 0.0f + jitterRangeBonus);
        ship.setJitterUnder(this, JITTER_UNDER_COLOR, jitterLevel, 25, 0.0f, 7.0f + jitterRangeBonus);
        float shipTimeMult = 1.0f + 2.0f * effectLevel;
        stats.getTimeMult().modifyMult(id, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(id, 1.0f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(id);
        }
        ship.getEngineController().fadeToOtherColor(this, JITTER_COLOR, new Color(0, 0, 0, 0), effectLevel, 0.5f);
        ship.getEngineController().extendFlame(this, -0.25f, -0.25f, -0.25f);
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = null;
        boolean player = false;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        player = ship == Global.getCombatEngine().getPlayerShip();
        id = String.valueOf(id) + "_" + ship.getId();
        Global.getCombatEngine().getTimeMult().unmodify(id);
        stats.getTimeMult().unmodify(id);
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        float shipTimeMult = 1.0f + 2.0f * effectLevel;
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("time flow altered", false);
        }
        return null;
    }
}

