/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class RiftLightningEffect
implements OnHitEffectPlugin,
OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin {
    public static Color RIFT_LIGHTNING_COLOR = new Color(255, 50, 50, 255);
    public static float RIFT_LIGHTNING_SPEED = 10000.0f;
    public static String RIFT_LIGHTNING_DAMAGE_REMOVER = "rift_lightning_damage_remover";
    public static String RIFT_LIGHTNING_FIRED_TAG = "rift_lightning_fired_tag";
    public static String RIFT_LIGHTNING_SOURCE_WEAPON = "rift_lightning_source_weapon";
    protected List<FiredLightningProjectile> fired = new ArrayList<FiredLightningProjectile>();

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (engine != null && engine.isInFastTimeAdvance()) {
            return;
        }
        ArrayList<FiredLightningProjectile> remove = new ArrayList<FiredLightningProjectile>();
        float maxRange = weapon.getRange();
        for (FiredLightningProjectile data : this.fired) {
            float dist = Misc.getDistance(data.projectile.getSpawnLocation(), data.projectile.getLocation());
            boolean firedAlready = data.projectile.getCustomData().containsKey(RIFT_LIGHTNING_FIRED_TAG);
            if (!(dist > maxRange) && !firedAlready) continue;
            remove.add(data);
            if (firedAlready) continue;
            RiftLightningEffect.fireArc(data.projectile, weapon, null, null);
        }
        this.fired.removeAll(remove);
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        projectile.getDamage().getModifier().modifyMult(RIFT_LIGHTNING_DAMAGE_REMOVER, 0.0f);
        projectile.setCustomData(RIFT_LIGHTNING_SOURCE_WEAPON, weapon);
        FiredLightningProjectile data = new FiredLightningProjectile();
        data.projectile = projectile;
        this.fired.add(data);
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        WeaponAPI weapon = (WeaponAPI)projectile.getCustomData().get(RIFT_LIGHTNING_SOURCE_WEAPON);
        if (weapon == null) {
            return;
        }
        RiftLightningEffect.fireArc(projectile, weapon, point, target);
    }

    public static void fireArc(DamagingProjectileAPI projectile, WeaponAPI weapon, Vector2f point, CombatEntityAPI target) {
        float maxRange;
        boolean firedAlready = projectile.getCustomData().containsKey(RIFT_LIGHTNING_FIRED_TAG);
        if (firedAlready) {
            return;
        }
        projectile.setCustomData(RIFT_LIGHTNING_FIRED_TAG, true);
        CombatEngineAPI engine = Global.getCombatEngine();
        ShipAPI ship = weapon.getShip();
        if (ship == null) {
            return;
        }
        Vector2f from = projectile.getSpawnLocation();
        float dist = Float.MAX_VALUE;
        if (point != null) {
            dist = Misc.getDistance(from, point);
        }
        if (dist > (maxRange = weapon.getRange()) || point == null) {
            dist = maxRange * (0.5f + 0.5f * (float)Math.random());
            if (projectile.didDamage()) {
                dist = maxRange;
            }
            point = Misc.getUnitVectorAtDegreeAngle(projectile.getFacing());
            point.scale(dist);
            Vector2f.add((Vector2f)point, (Vector2f)from, (Vector2f)point);
        }
        float arcSpeed = RIFT_LIGHTNING_SPEED;
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (shroud != null) {
            float angle = Misc.getAngleInDegrees(ship.getLocation(), point);
            from = Misc.getUnitVectorAtDegreeAngle(angle + 90.0f - 180.0f * (float)Math.random());
            from.scale((0.5f + (float)Math.random() * 0.25f) * shroud.getShroudParams().maxOffset);
            Vector2f.add((Vector2f)ship.getLocation(), (Vector2f)from, (Vector2f)from);
        }
        EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
        params.segmentLengthMult = 8.0f;
        params.zigZagReductionFactor = 0.15f;
        params.fadeOutDist = 50.0f;
        params.minFadeOutMult = 10.0f;
        params.flickerRateMult = 0.3f;
        params.movementDurOverride = Math.max(0.05f, dist / arcSpeed);
        Color color = RIFT_LIGHTNING_COLOR;
        EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, ship, point, null, 80.0f, color, new Color(255, 255, 255, 255), params);
        arc.setCoreWidthOverride(40.0f);
        arc.setRenderGlowAtStart(false);
        arc.setFadedOutAtStart(true);
        arc.setSingleFlickerMode(true);
        RiftLightningEffect.spawnMine(ship, point, params.movementDurOverride * 0.8f);
        if (shroud != null) {
            DwellerShroud.DwellerShroudParams shroudParams = shroud.getShroudParams();
            params = new EmpArcEntityAPI.EmpArcParams();
            params.segmentLengthMult = 4.0f;
            params.glowSizeMult = 4.0f;
            params.flickerRateMult = 0.5f + (float)Math.random() * 0.5f;
            params.flickerRateMult *= 1.5f;
            Color fringe = color;
            Color core = Color.white;
            float thickness = shroudParams.overloadArcThickness;
            float angle = Misc.getAngleInDegrees(from, ship.getLocation());
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle += 90.0f * ((float)Math.random() - 0.5f));
            dist = shroudParams.maxOffset;
            dist = dist * 0.5f + dist * 0.5f * (float)Math.random();
            dir.scale(dist *= 0.5f);
            Vector2f to = Vector2f.add((Vector2f)from, (Vector2f)dir, (Vector2f)new Vector2f());
            arc = engine.spawnEmpArcVisual(from, ship, to, ship, thickness, fringe, core, params);
            arc.setCoreWidthOverride(shroudParams.overloadArcCoreThickness);
            arc.setSingleFlickerMode(false);
        }
    }

    public static void spawnMine(ShipAPI source, Vector2f mineLoc, float delay) {
        CombatEngineAPI engine = Global.getCombatEngine();
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, "rift_lightning_minelayer", mineLoc, (float)Math.random() * 360.0f, null);
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.ENERGY, false, mine.getDamage());
        }
        float fadeInTime = 0.05f;
        mine.getVelocity().scale(0.0f);
        mine.fadeOutThenIn(fadeInTime);
        float liveTime = Math.max(delay, 0.0f);
        mine.setFlightTime(mine.getMaxFlightTime() - liveTime);
        mine.addDamagedAlready(source);
        mine.setNoMineFFConcerns(true);
        if (liveTime <= 0.016f) {
            mine.explode();
        }
    }

    public static class FiredLightningProjectile {
        public DamagingProjectileAPI projectile;
    }
}

