/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.WarpingSpriteRendererUtil;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class WarpingSpriteRendererUtilV2 {
    protected int verticesWide;
    protected int verticesTall;
    protected WSVertex[][] vertices;
    protected SpriteAPI sprite;
    protected boolean mirror = false;

    public WarpingSpriteRendererUtilV2(SpriteAPI sprite, int verticesWide, int verticesTall, float minWarpRadius, float maxWarpRadius, float warpRateMult) {
        this.sprite = sprite;
        this.verticesWide = verticesWide;
        this.verticesTall = verticesTall;
        this.vertices = new WSVertex[verticesWide][verticesTall];
        int i = 0;
        while (i < verticesWide) {
            int j = 0;
            while (j < verticesTall) {
                this.vertices[i][j] = new WSVertex();
                this.vertices[i][j].radius.set(minWarpRadius, maxWarpRadius);
                this.vertices[i][j].radius.rate *= warpRateMult;
                this.vertices[i][j].theta.rate *= warpRateMult;
                ++j;
            }
            ++i;
        }
    }

    public void setWarpRateMult(float mult) {
        int i = 0;
        while (i < this.verticesWide) {
            int j = 0;
            while (j < this.verticesTall) {
                this.vertices[i][j].radius.rate *= mult;
                this.vertices[i][j].theta.rate *= mult;
                ++j;
            }
            ++i;
        }
    }

    public void advance(float amount) {
        int i = 0;
        while (i < this.verticesWide) {
            int j = 0;
            while (j < this.verticesTall) {
                this.vertices[i][j].advance(amount);
                ++j;
            }
            ++i;
        }
    }

    public void renderAtCenter(float x, float y) {
        float w = this.sprite.getWidth();
        float h = this.sprite.getHeight();
        this.sprite.bindTexture();
        GL11.glPushMatrix();
        Color color = this.sprite.getColor();
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * this.sprite.getAlphaMult())));
        GL11.glTranslatef((float)(x -= w / 2.0f), (float)(y -= h / 2.0f), (float)0.0f);
        float centerX = this.sprite.getCenterX();
        float centerY = this.sprite.getCenterY();
        float angle = this.sprite.getAngle();
        if (centerX != -1.0f && centerY != -1.0f) {
            GL11.glTranslatef((float)(w / 2.0f), (float)(h / 2.0f), (float)0.0f);
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-centerX), (float)(-centerY), (float)0.0f);
        } else {
            GL11.glTranslatef((float)(w / 2.0f), (float)(h / 2.0f), (float)0.0f);
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-w / 2.0f), (float)(-h / 2.0f), (float)0.0f);
        }
        int blendSrc = this.sprite.getBlendSrc();
        int blendDest = this.sprite.getBlendDest();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)blendSrc, (int)blendDest);
        float tw = this.sprite.getTextureWidth() - 0.001f;
        float th = this.sprite.getTextureHeight() - 0.001f;
        float cw = w / (float)(this.verticesWide - 1);
        float ch = h / (float)(this.verticesTall - 1);
        float ctw = tw / (float)(this.verticesWide - 1);
        float cth = th / (float)(this.verticesTall - 1);
        float i = 0.0f;
        while (i < (float)(this.verticesWide - 1)) {
            GL11.glBegin((int)8);
            float j = 0.0f;
            while (j < (float)this.verticesTall) {
                float cos;
                float sin;
                float radius;
                float theta;
                float x1 = cw * i;
                float y1 = ch * j;
                float x2 = cw * (i + 1.0f);
                float y2 = ch * j;
                float tx1 = ctw * i;
                float ty1 = cth * j;
                float tx2 = ctw * (i + 1.0f);
                float ty2 = cth * j;
                if (this.mirror) {
                    tx1 = tw - tx1;
                    tx2 = th - tx2;
                }
                if (i != 0.0f && i != (float)(this.verticesWide - 1) && j != 0.0f && j != (float)(this.verticesTall - 1)) {
                    theta = (float)Math.toRadians(this.vertices[(int)i][(int)j].theta.getValue());
                    radius = this.vertices[(int)i][(int)j].radius.getValue();
                    sin = (float)Math.sin(theta);
                    cos = (float)Math.cos(theta);
                    x1 += cos * radius;
                    y1 += sin * radius;
                }
                if (i + 1.0f != 0.0f && i + 1.0f != (float)(this.verticesWide - 1) && j != 0.0f && j != (float)(this.verticesTall - 1)) {
                    theta = (float)Math.toRadians(this.vertices[(int)i + 1][(int)j].theta.getValue());
                    radius = this.vertices[(int)i + 1][(int)j].radius.getValue();
                    sin = (float)Math.sin(theta);
                    cos = (float)Math.cos(theta);
                    x2 += cos * radius;
                    y2 += sin * radius;
                }
                GL11.glTexCoord2f((float)tx1, (float)ty1);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)tx2, (float)ty2);
                GL11.glVertex2f((float)x2, (float)y2);
                j += 1.0f;
            }
            GL11.glEnd();
            i += 1.0f;
        }
        GL11.glPopMatrix();
    }

    public int getVerticesWide() {
        return this.verticesWide;
    }

    public int getVerticesTall() {
        return this.verticesTall;
    }

    public SpriteAPI getSprite() {
        return this.sprite;
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public static class WSVertex {
        public WarpingSpriteRendererUtil.MutatingValue theta = new WarpingSpriteRendererUtil.MutatingValue(-360.0f * ((float)Math.random() * 30.0f + 1.0f), 360.0f * ((float)Math.random() * 30.0f + 1.0f), 30.0f + 70.0f * (float)Math.random());
        public WarpingSpriteRendererUtil.MutatingValue radius = new WarpingSpriteRendererUtil.MutatingValue(0.0f, 10.0f + 15.0f * (float)Math.random(), 3.0f + 7.0f * (float)Math.random());

        public void advance(float amount) {
            this.theta.advance(amount);
            this.radius.advance(amount);
        }

        Object writeReplace() {
            this.theta.setMax((int)this.theta.getMax());
            this.theta.setMin((int)this.theta.getMin());
            this.theta.setRate((int)this.theta.getRate());
            this.theta.setValue((int)this.theta.getValue());
            this.radius.setMax((int)this.radius.getMax());
            this.radius.setMin((int)this.radius.getMin());
            this.radius.setRate((int)this.radius.getRate());
            this.radius.setValue((int)this.radius.getValue());
            return this;
        }
    }
}

