/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.threat.EnergyLashActivatedSystem;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public abstract class BaseEnergyLashActivatedSystem
extends BaseShipSystemScript
implements EnergyLashActivatedSystem {
    protected boolean inited = false;

    protected void init(ShipAPI ship) {
        ship.getSystem().setAmmo(0);
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        if (ship.getSystem() == null) {
            return;
        }
        if (!this.inited) {
            this.init(ship);
            this.inited = true;
        }
        this.applyImpl(ship, stats, id, state, effectLevel);
    }

    protected abstract void applyImpl(ShipAPI var1, MutableShipStatsAPI var2, String var3, ShipSystemStatsScript.State var4, float var5);

    @Override
    public void hitWithEnergyLash(ShipAPI overseer, ShipAPI ship) {
        if (ship.getSystem() == null) {
            return;
        }
        ship.getSystem().setAmmo(1);
        ship.giveCommand(ShipCommand.USE_SYSTEM, null, 0);
    }

    protected void setStandardJitter(ShipAPI ship, ShipSystemStatsScript.State state, float effectLevel) {
        if (ship.isHulk()) {
            return;
        }
        float jitterLevel = effectLevel;
        jitterLevel = 0.5f + 0.5f * jitterLevel;
        if (state == ShipSystemStatsScript.State.OUT) {
            jitterLevel *= jitterLevel;
        }
        Color base = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
        Color overColor = Misc.setAlpha(base, 255);
        ship.setJitter(this, overColor, jitterLevel, 1, 0.0f, 4.0f);
        ship.setJitterShields(false);
        ship.setCircularJitter(true);
    }

    protected void makeAllGroupsAutofireOneFrame(ShipAPI ship) {
        for (WeaponGroupAPI g : ship.getWeaponGroupsCopy()) {
            if (g.isAutofiring()) continue;
            g.toggleOn();
        }
        ship.resetSelectedGroup();
        ship.blockCommandForOneFrame(ShipCommand.TOGGLE_AUTOFIRE);
        ship.blockCommandForOneFrame(ShipCommand.SELECT_GROUP);
        ship.blockCommandForOneFrame(ShipCommand.USE_SELECTED_GROUP);
        ship.blockCommandForOneFrame(ShipCommand.FIRE);
        Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
        if (test instanceof ShipAPI) {
            ShipAPI target = (ShipAPI)test;
            ship.setShipTarget(target);
        }
    }
}

