/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.threat.BaseEnergyLashActivatedSystem;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;

public class IncursionModeSystemScript
extends BaseEnergyLashActivatedSystem {
    public static float SPEED_BONUS = 100.0f;
    public static float FLUX_DISSIPATION_MULT = 3.0f;
    public static float AMMO_REGEN_MULT = 5.0f;
    protected ShipAIConfig origConfig;

    @Override
    protected void init(ShipAPI ship) {
        super.init(ship);
        if (ship.getShipAI() != null && ship.getShipAI().getConfig() != null) {
            ShipAIConfig config = ship.getShipAI().getConfig();
            this.origConfig = config.clone();
        }
    }

    @Override
    public void applyImpl(ShipAPI ship, MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        stats.getMaxSpeed().modifyFlat(id, SPEED_BONUS * effectLevel);
        stats.getAcceleration().modifyFlat(id, 2.0f * SPEED_BONUS * effectLevel);
        stats.getDeceleration().modifyFlat(id, 2.0f * SPEED_BONUS * effectLevel);
        stats.getEnergyAmmoRegenMult().modifyMult(id, 1.0f + (AMMO_REGEN_MULT - 1.0f) * effectLevel);
        stats.getBallisticAmmoRegenMult().modifyMult(id, 1.0f + (AMMO_REGEN_MULT - 1.0f) * effectLevel);
        stats.getFluxDissipation().modifyMult(id, 1.0f + (FLUX_DISSIPATION_MULT - 1.0f) * effectLevel);
        if (ship.getShipAI() != null && ship.getShipAI().getConfig() != null) {
            ShipAIConfig config = ship.getShipAI().getConfig();
            if (effectLevel > 0.0f) {
                config.personalityOverride = "reckless";
                config.alwaysStrafeOffensively = true;
                config.backingOffWhileNotVentingAllowed = false;
                config.turnToFaceWithUndamagedArmor = false;
                config.burnDriveIgnoreEnemies = true;
            } else {
                config.copyFrom(this.origConfig);
            }
        }
        if (effectLevel <= 0.0f) {
            return;
        }
        ship.getEngineController().extendFlame(ship.getSystem(), 1.0f * effectLevel, 0.0f * effectLevel, 0.5f * effectLevel);
        ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF, 1.0f);
        ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT, 1.0f);
        ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.IGNORES_ORDERS, 1.0f);
        this.makeAllGroupsAutofireOneFrame(ship);
        this.setStandardJitter(ship, state, effectLevel);
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (effectLevel <= 0.0f) {
            return null;
        }
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("improved maneuverability", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("+" + (int)SPEED_BONUS + " top speed", false);
        }
        if (index == 2) {
            return new ShipSystemStatsScript.StatusData("x" + (int)FLUX_DISSIPATION_MULT + " flux dissipation", false);
        }
        if (index == 3) {
            return new ShipSystemStatsScript.StatusData("rapid charge regen", false);
        }
        return null;
    }

    @Override
    public float getCurrentUsefulnessLevel(ShipAPI overseer, ShipAPI ship) {
        if (ship.getSystem().isActive() || ship.getSystem().isChargedown() || ship.getSystem().isChargeup() || ship.getSystem().isCoolingDown()) {
            return 0.0f;
        }
        Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
        if (test instanceof ShipAPI) {
            float extra;
            float range;
            ShipAPI target = (ShipAPI)test;
            float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
            if ((dist -= ship.getCollisionRadius() + target.getCollisionRadius()) < (range = IncursionModeSystemScript.getNonMissileWeaponRange(ship)) + (extra = 750.0f)) {
                float distToOverseer = Misc.getDistance(ship.getLocation(), overseer.getLocation());
                distToOverseer -= ship.getCollisionRadius() + overseer.getCollisionRadius();
                float overseerDistFactor = 0.0f;
                if (distToOverseer < 1000.0f) {
                    float min = 500.0f;
                    overseerDistFactor = (1.0f - Math.max(0.0f, distToOverseer - min) / (1000.0f - min)) * 0.25f;
                }
                return Math.min(1.0f, 0.5f + Math.min(0.5f, ship.getFluxLevel() * 1.0f) + overseerDistFactor);
            }
        }
        return 0.0f;
    }

    public static float getNonMissileWeaponRange(ShipAPI ship) {
        float max = 0.0f;
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (w.isDecorative() || w.getType() == WeaponAPI.WeaponType.MISSILE) continue;
            max = Math.max(max, w.getRange());
        }
        return max;
    }
}

