/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.impl.combat.threat.ConstructionSwarmSystemScript;
import com.fs.starfarer.api.impl.combat.threat.FragmentSwarmHullmod;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.SwarmLauncherEffect;
import com.fs.starfarer.api.impl.combat.threat.ThreatHullmod;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ThreatShipReclamationScript
extends BaseEveryFrameCombatPlugin {
    public static float CR_PER_RECLAMATION_SWARM = 0.02f;
    public static float RECLAMATION_SWARM_SPEED_MULT = 0.67f;
    public static float RECLAMATION_SWARM_COLLISION_MULT = 1.5f;
    public static float RECLAMATION_SWARM_RADIUS_MULT = 2.0f;
    public static float RECLAMATION_SWARM_HP_MULT = 2.0f;
    public static float RECLAMATION_SWARM_FRAGMENT_SIZE_MULT = 0.67f;
    protected float elapsed = 0.0f;
    protected ShipAPI primary = null;
    protected List<ShipAPI> pieces = new ArrayList<ShipAPI>();
    protected List<ShipAPI> swarms = new ArrayList<ShipAPI>();
    protected float delay;
    protected float fadeOutTime;
    protected float origMaxSpeed = 500.0f;
    protected IntervalUtil interval = new IntervalUtil(0.075f, 0.125f);
    protected IntervalUtil interval2 = new IntervalUtil(0.075f, 0.125f);
    protected boolean spawnedSwarms = false;

    public ThreatShipReclamationScript(ShipAPI ship, float delay) {
        this.delay = delay;
        this.primary = ship;
        for (ShipAPI curr : Global.getCombatEngine().getShips()) {
            if (curr.getFleetMember() != ship.getFleetMember()) continue;
            this.pieces.add(curr);
        }
        switch (ship.getHullSize()) {
            case CAPITAL_SHIP: {
                this.fadeOutTime = 15.0f;
                break;
            }
            case CRUISER: {
                this.fadeOutTime = 12.0f;
                break;
            }
            case DESTROYER: {
                this.fadeOutTime = 9.0f;
                break;
            }
            case FRIGATE: {
                this.fadeOutTime = 7.0f;
                break;
            }
            default: {
                this.fadeOutTime = 7.0f;
            }
        }
        this.fadeOutTime += 3.0f;
        this.interval.forceIntervalElapsed();
        for (ShipAPI curr : this.pieces) {
            curr.addTag(ThreatHullmod.SHIP_BEING_RECLAIMED);
        }
    }

    public List<ShipAPI> getPieces() {
        return this.pieces;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.elapsed += amount;
        if (this.elapsed < this.delay) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        float progress = (this.elapsed - this.delay) / this.fadeOutTime;
        if (progress < 0.0f) {
            progress = 0.0f;
        }
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        float remaining = this.fadeOutTime - (this.elapsed - this.delay);
        if (this.elapsed > this.delay + 2.0f && remaining > 4.0f) {
            this.spawnSwarms(amount);
        }
        boolean first = true;
        boolean anyInEngine = false;
        for (ShipAPI ship : this.pieces) {
            if (!engine.isInEngine(ship)) continue;
            anyInEngine = true;
            Vector2f vel = ship.getVelocity();
            Vector2f acc = new Vector2f((ReadableVector2f)vel);
            if (acc.length() != 0.0f) {
                acc.normalise();
                acc.scale(-1.0f);
                acc.scale(amount * ship.getDeceleration());
                Vector2f.add((Vector2f)vel, (Vector2f)acc, (Vector2f)vel);
                float speed = vel.length();
                if (speed <= 1.0f || speed < acc.length()) {
                    vel.set(0.0f, 0.0f);
                }
            }
            float alpha = 1.0f;
            if (progress > 0.5f) {
                alpha = (1.0f - progress) * 2.0f;
            }
            ship.setAlphaMult(alpha);
            if (first) {
                Global.getSoundPlayer().playLoop("reclamation_loop", ship, 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
                first = false;
            }
            this.spawnParticles(ship, amount, progress);
        }
        if (this.elapsed > this.fadeOutTime + this.delay || !anyInEngine) {
            for (ShipAPI ship : this.pieces) {
                engine.removeEntity(ship);
                ship.setAlphaMult(0.0f);
            }
            engine.removePlugin(this);
        }
    }

    protected void spawnParticles(ShipAPI ship, float amount, float progress) {
        if (ship == null) {
            return;
        }
        float remaining = this.fadeOutTime - (this.elapsed - this.delay);
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            CombatEngineAPI engine = Global.getCombatEngine();
            Color c = RiftLanceEffect.getColorForDarkening(VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR);
            c = Misc.setAlpha(c, 50);
            float baseDuration = 2.0f;
            Vector2f vel = new Vector2f((ReadableVector2f)ship.getVelocity());
            float size = ship.getCollisionRadius() * 0.33f;
            float extraDur = 0.0f;
            if (remaining < 1.0f) {
                extraDur = 1.0f;
            }
            int i = 0;
            while (i < 11) {
                Vector2f point = new Vector2f((ReadableVector2f)ship.getLocation());
                point = Misc.getPointWithinRadiusUniform(point, ship.getCollisionRadius() * 0.75f, Misc.random);
                float dur = baseDuration + baseDuration * (float)Math.random();
                dur += extraDur;
                float nSize = size;
                Vector2f pt = Misc.getPointWithinRadius(point, nSize * 0.5f);
                Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
                v.scale(nSize + nSize * (float)Math.random() * 0.5f);
                v.scale(0.2f);
                Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
                float maxSpeed = nSize * 1.5f * 0.2f;
                float minSpeed = nSize * 1.0f * 0.2f;
                float overMin = v.length() - minSpeed;
                if (overMin > 0.0f) {
                    float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
                    if (durMult < 0.1f) {
                        durMult = 0.1f;
                    }
                    dur *= 0.5f + 0.5f * durMult;
                }
                engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, 2.0f, 0.5f / dur, 0.0f, dur, c);
                ++i;
            }
        }
    }

    protected void spawnSwarms(float amount) {
        if (!this.spawnedSwarms) {
            int numSwarms = 3;
            for (ConstructionSwarmSystemScript.SwarmConstructableVariant curr : ConstructionSwarmSystemScript.CONSTRUCTABLE) {
                if (!curr.variantId.equals(this.primary.getVariant().getHullVariantId())) continue;
                numSwarms = Math.round(curr.cr * 100.0f);
                break;
            }
            int i = 0;
            while (i < numSwarms) {
                ShipAPI curr = this.launchSwarm();
                this.swarms.add(curr);
                ++i;
            }
            this.spawnedSwarms = true;
        }
        this.interval2.advance(amount * 2.0f);
        if (this.interval2.intervalElapsed()) {
            WeightedRandomPicker<ShipAPI> picker = new WeightedRandomPicker<ShipAPI>();
            picker.addAll(this.pieces);
            for (ShipAPI curr : this.swarms) {
                RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(curr);
                if (swarm == null || swarm.getNumActiveMembers() > swarm.params.baseMembersToMaintain) continue;
                RoilingSwarmEffect.SwarmMember p = swarm.addMember();
                ShipAPI piece = (ShipAPI)picker.pick();
                if (piece == null) continue;
                Vector2f loc = Misc.getPointWithinRadius(piece.getLocation(), piece.getCollisionRadius() * 0.5f);
                p.loc.set((ReadableVector2f)loc);
                p.fader.setDurationIn(0.3f);
            }
        }
    }

    protected ShipAPI launchSwarm() {
        String wingId = SwarmLauncherEffect.RECLAMATION_SWARM_WING;
        CombatEngineAPI engine = Global.getCombatEngine();
        CombatFleetManagerAPI manager = engine.getFleetManager(this.primary.getOriginalOwner());
        manager.setSuppressDeploymentMessages(true);
        Vector2f loc = this.primary.getLocation();
        float facing = (float)Math.random() * 360.0f;
        ShipAPI fighter = manager.spawnShipOrWing(wingId, loc, facing, 0.0f, null);
        fighter.getWing().setSourceShip(this.primary);
        manager.setSuppressDeploymentMessages(false);
        fighter.getMutableStats().getMaxSpeed().modifyMult("construction_swarm", RECLAMATION_SWARM_SPEED_MULT);
        Vector2f takeoffVel = Misc.getUnitVectorAtDegreeAngle(facing);
        takeoffVel.scale(fighter.getMaxSpeed() * 1.0f);
        fighter.setDoNotRender(true);
        fighter.setExplosionScale(0.0f);
        fighter.setHulkChanceOverride(0.0f);
        fighter.setImpactVolumeMult(SwarmLauncherEffect.IMPACT_VOLUME_MULT);
        fighter.getArmorGrid().clearComponentMap();
        Vector2f.add((Vector2f)fighter.getVelocity(), (Vector2f)takeoffVel, (Vector2f)fighter.getVelocity());
        RoilingSwarmEffect swarm = FragmentSwarmHullmod.createSwarmFor(fighter);
        RoilingSwarmEffect.getFlockingMap().remove(swarm.params.flockingClass, swarm);
        swarm.params.flockingClass = FragmentSwarmHullmod.RECLAMATION_SWARM_FLOCKING_CLASS;
        RoilingSwarmEffect.getFlockingMap().add(swarm.params.flockingClass, swarm);
        swarm.params.memberExchangeClass = FragmentSwarmHullmod.RECLAMATION_SWARM_EXCHANGE_CLASS;
        swarm.params.flashFrequency = 5.0f;
        swarm.params.flashProbability = 1.0f;
        swarm.params.flashFringeColor = new Color(255, 70, 30, 50);
        swarm.params.flashCoreRadiusMult = 0.0f;
        swarm.params.springStretchMult = 1.0f;
        float collisionMult = RECLAMATION_SWARM_COLLISION_MULT;
        float hpMult = RECLAMATION_SWARM_HP_MULT;
        for (BoundsAPI.SegmentAPI s : fighter.getExactBounds().getOrigSegments()) {
            s.getP1().scale(collisionMult);
            s.getP2().scale(collisionMult);
            s.set(s.getP1().x, s.getP1().y, s.getP2().x, s.getP2().y);
        }
        fighter.setCollisionRadius(fighter.getCollisionRadius() * collisionMult);
        fighter.setMaxHitpoints(fighter.getMaxHitpoints() * hpMult);
        fighter.setHitpoints(fighter.getHitpoints() * hpMult);
        swarm.params.maxOffset *= RECLAMATION_SWARM_RADIUS_MULT;
        swarm.params.initialMembers = 0;
        swarm.params.baseMembersToMaintain = 50;
        return fighter;
    }
}

