/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.PhaseCloakStats;

public class AdaptivePhaseCoils
extends BaseHullMod {
    public static float FLUX_THRESHOLD_INCREASE_PERCENT = 50.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("phase_cloak_flux_level_for_min_speed_mod").modifyPercent(id, FLUX_THRESHOLD_INCREASE_PERCENT);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return Math.round(FLUX_THRESHOLD_INCREASE_PERCENT) + "%";
        }
        if (index == 1) {
            return Math.round(PhaseCloakStats.BASE_FLUX_LEVEL_FOR_MIN_SPEED * 100.0f) + "%";
        }
        if (index == 2) {
            return Math.round(PhaseCloakStats.BASE_FLUX_LEVEL_FOR_MIN_SPEED * 100.0f * (1.0f + FLUX_THRESHOLD_INCREASE_PERCENT / 100.0f)) + "%";
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("phase_anchor")) {
            return false;
        }
        return ship.getHullSpec().isPhase();
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("phase_anchor")) {
            return "Incompatible with Phase Anchor";
        }
        if (!ship.getHullSpec().isPhase()) {
            return "Can only be installed on phase ships";
        }
        return super.getUnapplicableReason(ship);
    }
}

