/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class JitterUtil {
    private long seed = Misc.genRandomSeed();
    private Random random = new Random(this.seed);
    private boolean setSeedOnRender = true;
    private boolean circular;

    public static void renderWithJitter(SpriteAPI s, float x, float y, float maxJitter, int numCopies) {
        int i = 0;
        while (i < numCopies) {
            Vector2f jv = new Vector2f();
            jv.x = (float)Math.random() * maxJitter - maxJitter / 2.0f;
            jv.y = (float)Math.random() * maxJitter - maxJitter / 2.0f;
            s.renderAtCenter(x + jv.x, y + jv.y);
            ++i;
        }
    }

    public void updateSeed() {
        this.seed = Misc.genRandomSeed();
    }

    public Random getRandom() {
        this.random.setSeed(this.seed);
        return this.random;
    }

    public void render(SpriteAPI s, float x, float y, float maxJitter, int numCopies) {
        this.render(s, x, y, 0.0f, maxJitter, numCopies);
    }

    public boolean isSetSeedOnRender() {
        return this.setSeedOnRender;
    }

    public void setSetSeedOnRender(boolean resetSeedOnRender) {
        this.setSeedOnRender = resetSeedOnRender;
    }

    public void setUseCircularJitter(boolean circular) {
        this.circular = circular;
    }

    public void render(SpriteAPI s, float x, float y, float minJitter, float maxJitter, int numCopies) {
        if (this.setSeedOnRender) {
            this.random.setSeed(this.seed);
        }
        int i = 0;
        while (i < numCopies) {
            Vector2f jv = new Vector2f();
            if (this.circular) {
                float r = minJitter + (maxJitter - minJitter) * this.random.nextFloat();
                jv = Misc.getPointAtRadius(jv, r, this.random);
            } else if (minJitter <= 0.0f) {
                jv.x = this.random.nextFloat() * maxJitter - maxJitter / 2.0f;
                jv.y = this.random.nextFloat() * maxJitter - maxJitter / 2.0f;
            } else {
                jv.x = this.random.nextFloat() * (maxJitter - minJitter) + minJitter;
                jv.y = this.random.nextFloat() * (maxJitter - minJitter) + minJitter;
                if (jv.x < minJitter) {
                    jv.x = minJitter;
                }
                if (jv.y < minJitter) {
                    jv.y = minJitter;
                }
                jv.x *= Math.signum(this.random.nextFloat() - 0.5f);
                jv.y *= Math.signum(this.random.nextFloat() - 0.5f);
            }
            s.renderAtCenter(x + jv.x, y + jv.y);
            ++i;
        }
    }
}

