/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SmoothMovementUtil {
    protected Vector2f vel = new Vector2f();
    protected Vector2f loc = new Vector2f();
    protected Vector2f accel = new Vector2f();
    protected Vector2f dest = new Vector2f();
    protected Vector2f destVel = new Vector2f();
    protected float acceleration = 1.0f;
    protected float maxSpeed = 1.0f;
    protected boolean smoothCap = true;
    protected float hardSpeedLimit = -1.0f;

    public float getHardSpeedLimit() {
        return this.hardSpeedLimit;
    }

    public void setHardSpeedLimit(float hardSpeedLimit) {
        this.hardSpeedLimit = hardSpeedLimit;
    }

    public void setDest(Vector2f dest, Vector2f destVel) {
        if (dest == null) {
            this.dest.set(0.0f, 0.0f);
        } else {
            this.dest.set((ReadableVector2f)dest);
        }
        if (destVel == null) {
            float dir = Misc.getAngleInDegrees(this.loc, this.dest);
            this.destVel = Misc.getUnitVectorAtDegreeAngle(dir);
            this.destVel.scale(10000.0f);
        } else {
            this.destVel.set((ReadableVector2f)destVel);
        }
    }

    public void advance(float amount) {
        if (amount * amount == 0.0f || amount <= 0.0f) {
            return;
        }
        float effectiveMaxSpeed = this.maxSpeed;
        float accelMult = 1.0f;
        float speed = this.vel.length();
        float acc = this.acceleration;
        float effectiveAccel = acc * accelMult;
        if (effectiveAccel <= 0.0f) {
            this.accel.set(0.0f, 0.0f);
            return;
        }
        Vector2f toDest = Vector2f.sub((Vector2f)this.dest, (Vector2f)this.loc, (Vector2f)new Vector2f());
        Vector2f velDiff = Vector2f.sub((Vector2f)this.destVel, (Vector2f)this.vel, (Vector2f)new Vector2f());
        float timeToMatchVel = velDiff.length() / effectiveAccel;
        velDiff.scale(timeToMatchVel + 0.75f);
        Vector2f negate = (Vector2f)Vector2f.add((Vector2f)toDest, (Vector2f)velDiff, (Vector2f)new Vector2f()).negate();
        float maxAccel = negate.length() / (amount * amount);
        if (maxAccel > effectiveAccel) {
            maxAccel = effectiveAccel;
        }
        this.accel = maxAccel > 0.0f ? (Vector2f)Misc.normalise(negate).scale(-maxAccel) : (Vector2f)negate.negate();
        this.vel.x += this.accel.x * amount;
        this.vel.y += this.accel.y * amount;
        speed = this.vel.length();
        if (speed >= effectiveMaxSpeed && speed > 0.0f) {
            if (this.smoothCap) {
                float minMag;
                Vector2f cap = new Vector2f((ReadableVector2f)this.vel);
                cap.negate();
                Misc.normalise(cap);
                float mag = speed - effectiveMaxSpeed;
                if (mag < 50.0f) {
                    mag = 50.0f;
                }
                if (mag < (minMag = maxAccel * 2.0f)) {
                    mag = minMag;
                }
                if (mag * amount > speed - effectiveMaxSpeed && amount > 0.0f) {
                    mag = (speed - effectiveMaxSpeed) / amount;
                }
                cap.scale(mag);
                this.vel.x += cap.x * amount;
                this.vel.y += cap.y * amount;
            } else {
                this.vel.scale(effectiveMaxSpeed / speed);
            }
        }
        if (this.hardSpeedLimit >= 0.0f && speed > 0.0f) {
            this.vel.scale(this.hardSpeedLimit / speed);
        }
        this.loc.x += this.vel.x * amount;
        this.loc.y += this.vel.y * amount;
    }

    public ReadableVector2f getAccelVector() {
        return this.accel;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float acceleration) {
        this.acceleration = acceleration;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public Vector2f getVelocity() {
        return this.vel;
    }

    public Vector2f getLocation() {
        return this.loc;
    }

    public Vector2f getDest() {
        return this.dest;
    }
}

