/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.util.B;
import com.fs.graphics.util.GLListManager;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.RingBandAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.loading.O0OO;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class RingBand
extends BaseCampaignEntity
implements DoNotObfuscate,
RingBandAPI {
    private transient float bandWidthInTexture;
    private transient int bandIndex;
    private transient Color color;
    private transient float bandWidthInEngine;
    private transient float orbitDays;
    private transient float middleRadius;
    private transient float angle = (float)Math.random() * 360.0f;
    private transient String category;
    private transient String key;
    private transient boolean spiral = false;
    private transient float minSpiralRadius = 0.0f;
    private transient float spiralFactor = 2.0f;
    private String j1 = null;
    private SectorEntityToken focus;
    private transient com.fs.graphics.Object texture;
    private transient GLListManager.GLListToken token = null;
    private EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.RINGS);

    public RingBand(SectorEntityToken sectorEntityToken, String string, String string2, float f2, int n2, Color color, float f3, float f4, float f5) {
        super(null);
        this.focus = sectorEntityToken;
        this.category = string;
        this.key = string2;
        this.bandWidthInTexture = f2;
        this.bandIndex = n2;
        this.color = color;
        this.bandWidthInEngine = f3;
        this.orbitDays = f5;
        this.middleRadius = f4;
        this.readResolve();
    }

    @Override
    protected Object readResolve() {
        O0OO.o00000((Object)this, RingBand.class, this.j1, new String[]{"bandWidthInTexture", "bandIndex", "color", "bandWidthInEngine", "orbitDays", "middleRadius", "angle", "category", "key", "spiral", "minSpiralRadius", "spiralFactor"});
        this.texture = StarfarerSettings.\u00d300000(this.category, this.key);
        return super.readResolve();
    }

    @Override
    protected Object writeReplace() {
        super.writeReplace();
        this.j1 = O0OO.o00000((Object)this, RingBand.class, new String[]{"bandWidthInTexture", "bandIndex", "color", "bandWidthInEngine", "orbitDays", "middleRadius", "angle", "category", "key", "spiral", "minSpiralRadius", "spiralFactor"});
        return this;
    }

    public String getSpriteCategory() {
        return this.category;
    }

    public String getSpriteKey() {
        return this.key;
    }

    @Override
    public void advance(float f2) {
        super.advance(f2);
        this.getLocation().set((ReadableVector2f)this.focus.getLocation());
        float f3 = (float)Math.PI * 2 * this.middleRadius;
        float f4 = f3 / this.orbitDays;
        float f5 = 360.0f / (f3 / f4);
        float f6 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        this.angle -= f5 * f6;
    }

    public float getSpiralFactor() {
        return this.spiralFactor;
    }

    public void setSpiralFactor(float f2) {
        this.spiralFactor = f2;
    }

    public boolean isSpiral() {
        return this.spiral;
    }

    public void setSpiral(boolean bl) {
        this.spiral = bl;
    }

    public float getMinSpiralRadius() {
        return this.minSpiralRadius;
    }

    public void setMinSpiralRadius(float f2) {
        this.minSpiralRadius = f2;
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        float f2;
        float f3;
        Color color;
        float f4;
        float f5;
        Object object;
        if (!this.isVisible(this.middleRadius + this.bandWidthInEngine)) {
            return;
        }
        super.render(campaignEngineLayers, combatViewport);
        float f6 = combatViewport.getAlphaMult();
        float f7 = (float)(Math.PI * 2 * (double)this.middleRadius);
        float f8 = 50.0f;
        float f9 = Math.round(f7 / f8);
        float f10 = (float)Math.toRadians(0.0);
        float f11 = (float)Math.toRadians(360.0);
        float f12 = Utils.o00000(f11 - f10);
        float f13 = f12 / f9;
        Vector2f vector2f = this.getLocation();
        float f14 = vector2f.x;
        float f15 = vector2f.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f14, (float)f15, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        this.texture.\u00d800000();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color color2 = this.getLightColor();
        Vector3f vector3f = null;
        if (this.getLightSource() != null) {
            object = this.getLightSource().getLocation();
            f5 = Utils.\u00d800000(vector2f, (Vector2f)object);
            vector3f = new Vector3f(((Vector2f)object).x, ((Vector2f)object).y, f5 * 0.75f);
        }
        vector3f = null;
        object = this.color;
        if (color2 != null) {
            object = color2;
            f5 = ((Color)object).getRed();
            if ((float)((Color)object).getGreen() > f5) {
                f5 = ((Color)object).getGreen();
            }
            if ((float)((Color)object).getBlue() > f5) {
                f5 = ((Color)object).getBlue();
            }
            f4 = 255.0f / f5;
            color = B.\u00d600000((Color)object, (float)f4);
            object = B.o00000((Color)object, (Color)color, (float)0.33f);
        }
        GL11.glColor4ub((byte)((byte)((Color)object).getRed()), (byte)((byte)((Color)object).getGreen()), (byte)((byte)((Color)object).getBlue()), (byte)((byte)((float)((Color)object).getAlpha() * f6)));
        f5 = 0.0f;
        f4 = 0.0f;
        if (vector3f != null) {
            color = new Vector2f(vector3f.x, vector3f.y);
            f3 = Utils.o00000(new Vector3f(vector2f.x, vector2f.y, 0.0f), vector3f);
            f2 = Utils.\u00d800000(vector2f, (Vector2f)color);
            f4 = f2 / f3;
            f5 = Utils.class(vector2f, (Vector2f)color);
        }
        float f16 = this.bandWidthInEngine * 1.0f;
        f3 = this.middleRadius - f16 / 2.0f;
        f2 = 0.0f;
        float f17 = this.texture.o00000();
        float f18 = this.texture.\u00d400000();
        float f19 = f8 * f17 / f18 * this.bandWidthInTexture / f16;
        float f20 = Math.max(1.0f, (float)Math.round(f19 * f9));
        f19 = f20 / f9;
        float f21 = this.texture.\u00d2O0000();
        float f22 = this.texture.Object();
        float f23 = (float)this.bandIndex * f21 * this.bandWidthInTexture / f22;
        float f24 = ((float)this.bandIndex + 1.0f) * f21 * this.bandWidthInTexture / f22 - 0.001f;
        if (!GLListManager.callList((GLListManager.GLListToken)this.token)) {
            this.token = GLListManager.beginList();
            GL11.glBegin((int)8);
            if (!this.spiral) {
                float f25;
                float f26;
                float f27;
                float f28;
                float f29;
                float f30;
                float f31;
                float f32;
                float f33;
                float f34 = 0.0f;
                while (f34 < f9) {
                    f33 = f13 * f34;
                    f32 = (float)Math.cos(f33);
                    f31 = (float)Math.sin(f33);
                    f30 = f32 * f3;
                    f29 = f31 * f3;
                    f28 = f32 * (f3 + f16);
                    f27 = f31 * (f3 + f16);
                    if (vector3f != null) {
                        f26 = 1.0f - Utils.o00000((float)Math.toDegrees(f33), f5) / 180.0f;
                        f26 = (float)Math.pow(f26, 1.5);
                        f25 = 1.0f - f4 + f4 * f26;
                        f25 = f25 * 0.5f + 0.5f;
                        GL11.glColor4ub((byte)((byte)((float)((Color)object).getRed() * f25)), (byte)((byte)((float)((Color)object).getGreen() * f25)), (byte)((byte)((float)((Color)object).getBlue() * f25)), (byte)((byte)((float)((Color)object).getAlpha() * f6)));
                    }
                    GL11.glTexCoord2f((float)f23, (float)f2);
                    GL11.glVertex2f((float)f30, (float)f29);
                    GL11.glTexCoord2f((float)f24, (float)f2);
                    GL11.glVertex2f((float)f28, (float)f27);
                    f2 += f19;
                    f34 += 1.0f;
                }
                boolean bl = false;
                f33 = f13 * (float)bl;
                f32 = (float)Math.cos(f33);
                f31 = (float)Math.sin(f33);
                f30 = f32 * f3;
                f29 = f31 * f3;
                f28 = f32 * (f3 + f16);
                f27 = f31 * (f3 + f16);
                if (vector3f != null) {
                    f26 = 1.0f - Utils.o00000((float)Math.toDegrees(f33), f5) / 180.0f;
                    f26 = (float)Math.pow(f26, 1.5);
                    f25 = 1.0f - f4 + f4 * f26;
                    f25 = f25 * 0.5f + 0.5f;
                    GL11.glColor4ub((byte)((byte)((float)((Color)object).getRed() * f25)), (byte)((byte)((float)((Color)object).getGreen() * f25)), (byte)((byte)((float)((Color)object).getBlue() * f25)), (byte)((byte)((float)((Color)object).getAlpha() * f6)));
                }
                GL11.glTexCoord2f((float)f23, (float)f2);
                GL11.glVertex2f((float)f30, (float)f29);
                GL11.glTexCoord2f((float)f24, (float)f2);
                GL11.glVertex2f((float)f28, (float)f27);
            } else {
                float f35 = (f3 - this.minSpiralRadius) / (f16 * this.spiralFactor);
                if (f35 < 2.0f) {
                    f35 = 2.0f;
                }
                float f36 = 1.0f;
                float f37 = 10.0f;
                float f38 = 0.0f;
                float f39 = 0.0f;
                while (f39 < f9 * f35) {
                    float f40;
                    f36 = 1.0f - f39 / (f9 * f35);
                    f36 = (float)Math.sqrt(f36);
                    f37 = 1.0f;
                    float f41 = f39 / f9;
                    if (f39 > f9 * (f35 - 1.0f)) {
                        f41 = (f9 * f35 - f39) / f9;
                    }
                    if (f41 > 1.0f) {
                        f41 = 1.0f;
                    }
                    if (f41 < 0.0f) {
                        f41 = 0.0f;
                    }
                    GL11.glColor4ub((byte)((byte)((Color)object).getRed()), (byte)((byte)((Color)object).getGreen()), (byte)((byte)((Color)object).getBlue()), (byte)((byte)((float)((Color)object).getAlpha() * f41)));
                    f38 = f13 * f39;
                    float f42 = (float)Math.cos(f38);
                    float f43 = (float)Math.sin(f38);
                    float f44 = f42 * ((f3 - this.minSpiralRadius) * f36 + this.minSpiralRadius);
                    float f45 = f43 * ((f3 - this.minSpiralRadius) * f36 + this.minSpiralRadius);
                    float f46 = f42 * ((f3 - this.minSpiralRadius) * f36 + f16 * f37 + this.minSpiralRadius);
                    float f47 = f43 * ((f3 - this.minSpiralRadius) * f36 + f16 * f37 + this.minSpiralRadius);
                    if (vector3f != null) {
                        f40 = 1.0f - Utils.o00000((float)Math.toDegrees(f38), f5) / 180.0f;
                        f40 = (float)Math.pow(f40, 1.5);
                        float f48 = 1.0f - f4 + f4 * f40;
                        f48 = f48 * 0.5f + 0.5f;
                        GL11.glColor4ub((byte)((byte)((float)((Color)object).getRed() * f48)), (byte)((byte)((float)((Color)object).getGreen() * f48)), (byte)((byte)((float)((Color)object).getBlue() * f48)), (byte)((byte)((float)((Color)object).getAlpha() * f6)));
                    }
                    GL11.glTexCoord2f((float)f23, (float)f2);
                    GL11.glVertex2f((float)f44, (float)f45);
                    GL11.glTexCoord2f((float)f24, (float)f2);
                    GL11.glVertex2f((float)f46, (float)f47);
                    f40 = ((f3 - this.minSpiralRadius) * f36 + this.minSpiralRadius) / f3;
                    f2 += f19 * f40;
                    if (f39 == 0.0f) {
                        GL11.glColor4ub((byte)((byte)((Color)object).getRed()), (byte)((byte)((Color)object).getGreen()), (byte)((byte)((Color)object).getBlue()), (byte)((byte)((float)((Color)object).getAlpha() * f6)));
                    }
                    f39 += 1.0f;
                }
            }
            GL11.glEnd();
            GLListManager.endList();
        }
        GL11.glPopMatrix();
    }

    @Override
    public float getRadius() {
        return 0.0f;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public boolean isStar() {
        return false;
    }

    public SectorEntityToken getFocus() {
        return this.focus;
    }

    public void setFocus(SectorEntityToken sectorEntityToken) {
        this.focus = sectorEntityToken;
    }

    public float getBandWidthInTexture() {
        return this.bandWidthInTexture;
    }

    public void setBandWidthInTexture(float f2) {
        this.bandWidthInTexture = f2;
    }

    public int getBandIndex() {
        return this.bandIndex;
    }

    public void setBandIndex(int n2) {
        this.bandIndex = n2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getBandWidthInEngine() {
        return this.bandWidthInEngine;
    }

    public void setBandWidthInEngine(float f2) {
        this.bandWidthInEngine = f2;
    }

    public float getMiddleRadius() {
        return this.middleRadius;
    }

    public void setMiddleRadius(float f2) {
        this.middleRadius = f2;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public float getOrbitDays() {
        return this.orbitDays;
    }

    public void setOrbitDays(float f2) {
        this.orbitDays = f2;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
        this.texture = StarfarerSettings.\u00d300000(this.category, string);
    }
}

