/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.accidents;

import com.fs.starfarer.String;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.accidents.AccidentRisk;
import com.fs.starfarer.campaign.accidents.I;
import com.fs.starfarer.campaign.accidents.while;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class AccidentManager
implements DoNotObfuscate {
    private transient List<AccidentRisk> risks = new ArrayList<AccidentRisk>();
    private transient Random random;
    private long randomSeed;
    private IntervalTracker tracker;
    private CampaignFleet fleet;
    private float currentChance = 0.0f;
    private AccidentRisk.AccidentContext context = new AccidentRisk.AccidentContext();

    public AccidentManager(CampaignFleet campaignFleet) {
        this.fleet = campaignFleet;
        this.randomSeed = (long)(Math.random() * 9.223372036854776E18);
        this.tracker = new IntervalTracker(0.5f, 1.5f);
        this.readResolve();
    }

    public Object readResolve() {
        this.risks = new ArrayList<AccidentRisk>();
        this.random = new Random(this.randomSeed);
        this.risks.add(new I(this.fleet.getFleetData(), this.fleet.getFleetData().getCargoNoSync(), this.random));
        if (this.context == null) {
            this.context = new AccidentRisk.AccidentContext();
        }
        return this;
    }

    public I getRisk() {
        return (I)this.risks.get(0);
    }

    public List<AccidentRisk> getRisks() {
        return this.risks;
    }

    public AccidentRisk.o getHighestSeverity() {
        AccidentRisk.o o2 = AccidentRisk.o.\u00d600000;
        for (AccidentRisk accidentRisk : this.risks) {
            AccidentRisk.o o3 = accidentRisk.\u00d300000(this.context);
            if (o3.ordinal() <= o2.ordinal()) continue;
            o2 = o3;
        }
        return o2;
    }

    public void advance(float f2) {
        float f3 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        this.tracker.advance(f3);
        float f4 = this.fleet.getCargo().getSupplies();
        this.context.daysWithoutSupplies = f4 == 0.0f ? (this.context.daysWithoutSupplies += f3) : 0.0f;
        if (this.tracker.intervalElapsed()) {
            Object object;
            boolean bl = false;
            for (AccidentRisk accidentRisk : this.risks) {
                object = accidentRisk.\u00d300000(this.context);
                switch (AccidentManager.$SWITCH_TABLE$com$fs$starfarer$campaign$accidents$AccidentRisk$AccidentSeverity()[((Enum)object).ordinal()]) {
                    case 4: {
                        this.currentChance += 0.9f;
                        bl = true;
                        break;
                    }
                    case 3: {
                        this.currentChance += 0.5f;
                        bl = true;
                        break;
                    }
                    case 2: {
                        this.currentChance += 0.25f;
                        bl = true;
                    }
                }
            }
            if (this.currentChance > 0.9f) {
                this.currentChance = 0.9f;
            }
            if (!bl) {
                this.currentChance = 0.0f;
            } else if (this.random.nextFloat() < this.currentChance) {
                AccidentRisk accidentRisk;
                this.currentChance = 0.0f;
                accidentRisk = new WeightedRandomPicker(this.random);
                for (AccidentRisk accidentRisk2 : this.risks) {
                    switch (accidentRisk2.\u00d300000(this.context)) {
                        case \u00d400000: {
                            accidentRisk.add(accidentRisk2, 4.0f);
                            break;
                        }
                        case new: {
                            accidentRisk.add(accidentRisk2, 2.0f);
                            break;
                        }
                        case \u00d300000: {
                            if (!(this.context.daysWithoutSupplies > 0.0f)) break;
                            accidentRisk.add(accidentRisk2, 1.0f);
                            break;
                        }
                    }
                }
                AccidentRisk accidentRisk3 = (AccidentRisk)accidentRisk.pick();
                if (accidentRisk3 == null) {
                    return;
                }
                object = accidentRisk3.super(this.context);
                if (object != null && this.fleet.isPlayerFleet() && !((while)object).String().isEmpty()) {
                    if (((while)object).String().size() > 0) {
                        CampaignEngine.getInstance().getCampaignUI().showAccidentReport((while)object);
                    }
                } else if (object != null && StarfarerSettings.O\u00d30000() && this.fleet.isInCurrentLocation() && !this.fleet.isPlayerFleet()) {
                    CampaignEngine.getInstance().getCampaignUI().addMessage(java.lang.String.valueOf(this.fleet.getNameWithFaction()) + " (" + this.fleet.hashCode() + "): " + ((while)object).\u00d500000() + " (" + ((while)object).\u00f400000() + ")", String.super.new);
                }
            }
        }
    }

    public AccidentRisk.AccidentContext getContext() {
        return this.context;
    }
}

