/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.D;
import com.fs.starfarer.campaign.command.K;
import com.fs.starfarer.campaign.command.OO0O;
import com.fs.starfarer.campaign.command.do;
import com.fs.starfarer.campaign.command.super;
import com.fs.starfarer.campaign.ui.B;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.voidsuper;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.null;
import com.fs.starfarer.util.super.Object;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeaponBlueprintBrowser
extends OO0O
implements D,
UITable.Oo {
    public static String ALL_TECHS = "All designs";
    public static String ALL_SIZES = "All sizes";
    public static String ALL_TYPES = "All types";
    public static String SMALL = "Small";
    public static String MEDIUM = "Medium";
    public static String LARGE = "Large";
    public static String BALLISTIC = "Ballistic";
    public static String MISSILE = "Missile";
    public static String ENERGY = "Energy";
    private List<BaseWeaponSpec> Object.this$new = new ArrayList<BaseWeaponSpec>();
    private CustomProductionPanel \u00d4o\u00d3000;
    private TableColumns \u00d2o\u00d3000 = null;

    public WeaponBlueprintBrowser(CustomProductionPanel customProductionPanel, OO0O.o o2) {
        super(o2, customProductionPanel);
        this.\u00d4o\u00d3000 = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableWeapons() != null) {
            for (String string : customProductionPanel.getDelegate().getAvailableWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string);
                this.Object.this$new.add(baseWeaponSpec);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (String string : faction.getKnownWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string);
                this.Object.this$new.add(baseWeaponSpec);
            }
        }
    }

    public List<BaseWeaponSpec> getKnownWeapons() {
        return this.Object.this$new;
    }

    @Override
    protected UITable createTable() {
        voidsuper voidsuper2 = new voidsuper(this.faction);
        String string = "Weapon blueprint";
        String string2 = "No matching weapon blueprints";
        if (this.\u00d4o\u00d3000 != null && this.\u00d4o\u00d3000.isPickerMode() && this.\u00d4o\u00d3000.getDelegate() != null) {
            if (this.\u00d4o\u00d3000.getDelegate().getWeaponColumnNameOverride() != null) {
                string = this.\u00d4o\u00d3000.getDelegate().getWeaponColumnNameOverride();
            }
            if (this.\u00d4o\u00d3000.getDelegate().getNoMatchingBlueprintsLabelOverride() != null) {
                string2 = this.\u00d4o\u00d3000.getDelegate().getNoMatchingBlueprintsLabelOverride();
            }
        }
        voidsuper2.addColumn((java.lang.Object)TableColumns.NAME, string, 300.0f, true);
        voidsuper2.addColumn((java.lang.Object)TableColumns.SIZE, "Size", 80.0f, true);
        voidsuper2.addColumn((java.lang.Object)TableColumns.TYPE, "Type", 80.0f, true);
        voidsuper2.addColumn((java.lang.Object)TableColumns.TECH, "Design type", 200.0f, true);
        voidsuper2.setTooltip(0, "Weapon name. Mouse over the icon for a detailed tooltip with its stats.");
        voidsuper2.setTooltip(1, "Weapon size.");
        voidsuper2.setTooltip(2, "Weapon type - ballistic, energy, or missile.");
        voidsuper2.setTooltip(3, "The originator of the design (such as a corporation or a faction), or \"Common\" for designs found in use throughout the Sector.");
        if (this.mode == OO0O.o.\u00d300000) {
            voidsuper2.addColumn((java.lang.Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            voidsuper2.setTooltip(4, "Prioriziting a weapon will make it more likely to be used by your faction's fleets.");
        } else {
            voidsuper2.addColumn((java.lang.Object)TableColumns.COST, "Cost", 120.0f, true);
            voidsuper2.setTooltipAbove(4, new StandardTooltipV2Expandable(300.0f, false){

                @Override
                public void createImpl(boolean bl) {
                    this.addPara("Production cost.", 0.0f);
                }
            });
        }
        UITable uITable = new UITable(8000.0f, K.ROW_HEIGHT, voidsuper2, this);
        uITable.setEmptyText(string2);
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(K.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        boolean bl = true;
        if (this.\u00d4o\u00d3000 != null && this.\u00d4o\u00d3000.isPickerMode() && this.\u00d4o\u00d3000.getDelegate() != null) {
            bl = this.\u00d4o\u00d3000.getDelegate().isUseCreditSign();
        }
        Set<String> set = this.tags.getSelected();
        for (BaseWeaponSpec baseWeaponSpec : this.Object.this$new) {
            if (!this.weaponMatchesTags(baseWeaponSpec, set)) continue;
            super super_ = new super(this.\u00d4o\u00d3000, this.table.getHeader(), super.o.\u00d200000, baseWeaponSpec.getWeaponId(), this.mode);
            super_.setWithCreditSign(bl);
            this.table.addRow(super_);
            if (this.mode != OO0O.o.new) continue;
            super_.getButton().getLogic().o00000(null.Oo.\u00d400000);
        }
        this.table.resumeRecompute();
        this.table.sort((java.lang.Object)TableColumns.SIZE, false);
        super.updateTable();
    }

    protected boolean weaponMatchesTags(BaseWeaponSpec baseWeaponSpec, Set<String> set) {
        WeaponAPI.WeaponSize weaponSize = baseWeaponSpec.getSize();
        String string = null;
        if (weaponSize == WeaponAPI.WeaponSize.SMALL) {
            string = SMALL;
        }
        if (weaponSize == WeaponAPI.WeaponSize.MEDIUM) {
            string = MEDIUM;
        }
        if (weaponSize == WeaponAPI.WeaponSize.LARGE) {
            string = LARGE;
        }
        if (string != null && !set.contains(string)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC && !set.contains(BALLISTIC)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE && !set.contains(MISSILE)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.ENERGY && !set.contains(ENERGY)) {
            return false;
        }
        String string2 = baseWeaponSpec.getManufacturer();
        return string2 == null || set.contains(string2);
    }

    @Override
    protected do createTags() {
        do do_ = new do(this.table.getWidth(), this);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        CountingMap countingMap = new CountingMap();
        for (BaseWeaponSpec baseWeaponSpec : this.Object.this$new) {
            countingMap.add((java.lang.Object)baseWeaponSpec.getManufacturer());
            if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.SMALL) {
                ++n2;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                ++n3;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.LARGE) {
                ++n4;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC) {
                ++n5;
                continue;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE) {
                ++n6;
                continue;
            }
            if (baseWeaponSpec.getType() != WeaponAPI.WeaponType.ENERGY) continue;
            ++n7;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            do_.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                do_.addTag(string, string, countingMap.getCount((java.lang.Object)string));
            }
            do_.addGroup(0.0f);
        }
        do_.beginGroup(false, ALL_SIZES, 120.0f);
        do_.addTag(SMALL, n2);
        do_.addTag(MEDIUM, n3);
        do_.addTag(LARGE, n4);
        do_.addGroup(f2 * 1.0f);
        do_.beginGroup(false, ALL_TYPES, 120.0f);
        do_.addTag(BALLISTIC, n5);
        do_.addTag(MISSILE, n6);
        do_.addTag(ENERGY, n7);
        do_.addGroup(f3);
        return do_;
    }

    @Override
    public void tagsChanged(do do_) {
        TableColumns tableColumns = this.\u00d2o\u00d3000;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((java.lang.Object)tableColumns, null);
            this.table.sort((java.lang.Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<B> tableGetComparator(UITable uITable, final java.lang.Object object) {
        return new Comparator<B>(){

            public int o00000(B b2, B b3) {
                int n2;
                super super_ = (super)b2;
                super super_2 = (super)b3;
                WeaponBlueprintBrowser.this.\u00d2o\u00d3000 = (TableColumns)((java.lang.Object)object);
                if (object == TableColumns.SIZE && (n2 = super_.getSizeOrdinal() - super_2.getSizeOrdinal()) != 0) {
                    return n2;
                }
                if (object == TableColumns.TECH && (n2 = super_.getTechString().compareTo(super_2.getTechString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.TYPE && (n2 = super_.getTypeString().compareTo(super_2.getTypeString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.ENABLED) {
                    if (super_.isBlueprintEnabled() && !super_2.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (super_2.isBlueprintEnabled() && !super_.isBlueprintEnabled()) {
                        return 1;
                    }
                    n2 = super_.getSizeOrdinal() - super_2.getSizeOrdinal();
                    if (n2 != 0) {
                        return n2;
                    }
                }
                if (object == TableColumns.COST && (n2 = super_.getCostValue() - super_2.getCostValue()) != 0) {
                    return n2;
                }
                return super_.getNameString().compareTo(super_2.getNameString());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, B b2, java.lang.Object object) {
        super super_ = (super)b2;
        if (this.mode == OO0O.o.\u00d300000) {
            super_.setBlueprintEnabled(!super_.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n2 = 1;
            boolean bl = true;
            if (object instanceof Object) {
                cloneable = (Object)object;
                if (((Object)cloneable).isCtrlDown()) {
                    n2 = 1000;
                } else if (((Object)cloneable).isShiftDown()) {
                    n2 = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((Object)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.\u00d4o\u00d3000.getProd();
            if (bl) {
                int n3 = this.\u00d4o\u00d3000.getDelegate() == null ? 0 : (this.\u00d4o\u00d3000.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId(), n2, n3);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId(), n2);
            }
            this.\u00d4o\u00d3000.updatePlanTable(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId());
            super_.getButton().flash(false, 0.1f, 0.9f);
        }
        super_.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, voidsuper.o o2) {
    }

    @Override
    protected void selectAll() {
        for (B b2 : this.table.getRows()) {
            super super_ = (super)b2;
            super_.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (B b2 : this.table.getRows()) {
            super super_ = (super)b2;
            super_.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (String string : faction.getKnownWeapons()) {
            faction.removePriorityWeapon(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityWeapons().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownWeapons(bl);
    }

    @Override
    protected String getAutoEnableSubject() {
        return "weapon blueprints";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownWeapons();
    }

    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        SIZE,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

