/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.loading.ProjectileSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.ai.ProximityFuseAI;
import com.fs.starfarer.combat.entities.B;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.return;
import com.fs.starfarer.combat.entities.ship.A.E;
import com.fs.starfarer.combat.entities.ship.G;
import com.fs.starfarer.combat.o0OO.O0OO;
import com.fs.starfarer.combat.systems.Q;
import com.fs.starfarer.loading.specs.F;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.O0oO;
import com.fs.starfarer.renderers.while;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class BallisticProjectile
extends BaseEntity
implements return,
DamagingProjectileAPI,
ProximityFuseAI.o {
    private Ship source;
    private com.fs.starfarer.combat.o0OO.F damage;
    private F spec;
    private while.o projAnimator;
    private boolean didDamage = false;
    private B trailExtender;
    private float health;
    private CombatEngine engine;
    private O0oO shine;
    private OnHitEffectPlugin effect = null;
    private final Q weapon;
    private List<com.fs.starfarer.combat.o0OO.B> damagedAlready;
    private Vector2f spawnLocation = new Vector2f();
    private float elapsed = 0.0f;
    private com.fs.starfarer.combat.o0OO.B damageTarget;
    private EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_LAYER);
    private boolean fromMissile = false;

    public BallisticProjectile(Ship ship, Q q2, F f2, Vector2f vector2f, Vector2f vector2f2, float f3) {
        float f4;
        float f5;
        this.source = ship;
        this.weapon = q2;
        this.spec = f2;
        this.damage = f2.getDamage().clone();
        this.damage.setStats(ship.getStats());
        if (f2.isPassThroughMissiles() || f2.isPassThroughFighters()) {
            this.damagedAlready = new ArrayList<com.fs.starfarer.combat.o0OO.B>();
        }
        this.spawnLocation.set((ReadableVector2f)vector2f);
        float[] fArray = com.fs.starfarer.combat.entities.ship.E.computeExtraDamageComponents(ship, q2);
        if (fArray != null) {
            this.damage.getModifier().modifyPercent("core_edc_0", fArray[0]);
            this.damage.getModifier().modifyFlat("core_edc_1", fArray[1]);
            this.damage.getModifier().modifyMult("core_edc_2", fArray[2]);
        }
        this.engine = CombatEngine.getInstance();
        this.projAnimator = new while.o(f2.getBulletSpriteName());
        this.effect = f2.getOnHitEffect();
        this.setOwner(ship.getOwner());
        this.getVelocity().set((ReadableVector2f)vector2f2);
        this.getLocation().set((ReadableVector2f)vector2f);
        this.setFacing(f3);
        if (f2.getGlowRadius() > 0.0f) {
            this.shine = new O0oO(f2.getGlowRadius(), f2.getWidth() * 1.5f, f2.getGlowColor());
        }
        Vector2f vector2f3 = Utils.\u00d300000(f3);
        this.setCollisionRadius(f2.getWidth() / 2.0f);
        float f6 = 0.0f;
        if (f2.getBehaviorSpec() != null && f2.getBehaviorSpec().getParams() != null) {
            f6 = (float)f2.getBehaviorSpec().getParams().optDouble("shotRangeVariance", 0.0);
            f5 = (float)f2.getBehaviorSpec().getParams().optDouble("probOfVariance", 1.0);
            if ((float)Math.random() >= f5) {
                f6 = 0.0f;
            }
        }
        f5 = com.fs.starfarer.combat.entities.ship.E.getAdjustedBaseRange(f2.getMaxRange(), ship, q2);
        float f7 = com.fs.starfarer.combat.entities.ship.E.getThresholdAdjustedRange(ship, q2, f5 * (1.0f - f6 * (float)Math.random()) * com.fs.starfarer.combat.entities.ship.E.computeExtraRangeMult(ship, q2) + com.fs.starfarer.combat.entities.ship.E.computeExtraRangeFlat(ship, q2)) / f2.getMoveSpeed(ship.getStats(), q2);
        this.trailExtender = new B(vector2f, vector2f3, f2.getLength(), f2.getMoveSpeed(ship.getStats(), q2), f7, f2.getFadeTime());
        O0OO o0OO2 = new O0OO();
        float f8 = f2.getWidth() * 0.5f;
        float f9 = Math.min(f2.getLength() * 0.75f, f8 * 5.0f);
        if (f9 < (f4 = f2.getMoveSpeed(ship.getStats(), q2) * 1.0f / 30.0f * 3.0f)) {
            f9 = f4;
        }
        o0OO2.addSegment(f8 / 2.0f, 0.0f, -f9, 0.0f);
        o0OO2.addSegment(f8 / 2.0f, f8 / 2.0f, f8 / 2.0f, -f8 / 2.0f);
        this.setBounds(o0OO2);
        this.health = f2.getMaxHealth();
    }

    public Vector2f getSpawnLocation() {
        return this.spawnLocation;
    }

    @Override
    public void setFacing(float f2) {
        super.setFacing(f2);
        if (this.trailExtender != null) {
            this.trailExtender.super(Utils.\u00d300000(f2));
        }
    }

    @Override
    public WeaponAPI getWeapon() {
        return this.weapon;
    }

    @Override
    public boolean canCauseInsideBoundsCollision() {
        if (this.source != null && !this.source.isFighter()) {
            return true;
        }
        float f2 = this.spec.getMoveSpeed(this.source.getStats(), this.weapon);
        if (f2 <= 50.0f) {
            return this.elapsed > 0.5f;
        }
        return this.elapsed > 50.0f / f2;
    }

    @Override
    public void advance(float f2) {
        this.elapsed += f2;
        float f3 = 1.0f - this.trailExtender.String();
        if (this.trailExtender.\u00d200000()) {
            f3 = 1.0f;
        }
        f3 *= f3;
        if (this.didDamage) {
            f3 = 0.0f;
        }
        this.damage.setMultiplier(f3);
        if (this.isFading()) {
            this.damage.setSoftFlux(true);
        }
        this.projAnimator.super(f2, this.spec.getTextureScrollSpeed());
        this.trailExtender.super(f2, this.getLocation(), this.didDamage);
    }

    @Override
    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport) {
        if (!combatViewport.isNearViewport(this.getLocation(), this.spec.getLength() * 1.5f)) {
            return;
        }
        Vector2f vector2f = this.trailExtender.\u00d600000();
        Vector2f vector2f2 = this.getLocation();
        float f2 = this.trailExtender.super();
        if (this.shine != null) {
            this.shine.o00000(vector2f2.x, vector2f2.y, f2, false);
        }
        while.o00000(this.projAnimator, this.getVelocity(), this.spec.getFringeColor(), this.spec.getCoreColor(), vector2f2, vector2f, this.spec.getWidth(), this.spec.getCoreWidthMult(), f2);
    }

    @Override
    public com.fs.starfarer.combat.o0OO.F getDamage(Vector2f vector2f, com.fs.starfarer.combat.o0OO.B b2) {
        if (this.damagedAlready != null && this.damagedAlready.contains(b2)) {
            return new com.fs.starfarer.combat.o0OO.F(0.0f, false, this.damage.getType(), this.source.getStats());
        }
        return this.damage;
    }

    public com.fs.starfarer.combat.o0OO.F getDamage() {
        return this.damage;
    }

    public void setDamage(com.fs.starfarer.combat.o0OO.F f2) {
        this.damage = f2;
    }

    @Override
    public Ship getSource() {
        return this.source;
    }

    public void setSource(ShipAPI shipAPI) {
        this.source = (Ship)shipAPI;
    }

    @Override
    public boolean isDestroyedByCollision(com.fs.starfarer.combat.o0OO.B b2) {
        return false;
    }

    @Override
    public return.o notifyDealtDamage(Vector2f vector2f, G g2, com.fs.starfarer.combat.o0OO.B b2) {
        this.setDidDamage(vector2f, b2, g2);
        if (this.damagedAlready != null) {
            this.damagedAlready.add(b2);
        }
        if (this.damagedAlready != null && !this.didDamage) {
            return return.o.\u00d200000;
        }
        return return.o.String;
    }

    @Override
    public boolean didDamage() {
        return this.didDamage;
    }

    private void setDidDamage(Vector2f vector2f, com.fs.starfarer.combat.o0OO.B b2, G g2) {
        if (!(this.didDamage || this.damagedAlready != null && this.damagedAlready.contains(b2))) {
            this.damageTarget = b2;
            float f2 = this.spec.getHitGlowRadius();
            if (f2 == 0.0f) {
                f2 = this.spec.getLength() * 2.0f;
            }
            float f3 = f2 / 1.0f;
            float f4 = f2 / 2.0f;
            boolean bl = false;
            if (this.damagedAlready != null) {
                if (this.spec.isPassThroughMissiles() && b2 instanceof Missile) {
                    bl = true;
                } else if (this.spec.isPassThroughFighters() && b2 instanceof Ship && ((Ship)b2).isFighter() && (!this.spec.isPassThroughFightersOnlyWhenDestroyed() || b2.getHitpoints() <= 0.0f)) {
                    bl = true;
                }
            }
            if (!bl) {
                this.didDamage = true;
            }
            float f5 = f3 + (float)Math.random() * f4;
            f5 = Misc.getHitGlowSize((float)f5, (float)this.getDamage().getBaseDamage(), (ApplyDamageResultAPI)g2);
            if (!this.didDamage) {
                f5 *= 0.5f;
            }
            E.o00000(vector2f, g2, f5, b2, this.spec.getFringeColor(), this.damage.getMultiplier() * 0.4f, this.damage.getMultiplier());
            if ((this.didDamage || this.spec.isApplyOnHitEffectWhenPassThrough()) && this.effect != null) {
                this.effect.onHit((DamagingProjectileAPI)this, (CombatEntityAPI)b2, vector2f, g2.getDamageToShields() > 0.0f, (ApplyDamageResultAPI)g2, (CombatEngineAPI)CombatEngine.getInstance());
            }
        }
    }

    public CombatEntityAPI getDamageTarget() {
        return this.damageTarget instanceof CombatEntityAPI ? this.damageTarget : null;
    }

    @Override
    public G applyDamage(Vector2f vector2f, com.fs.starfarer.combat.o0OO.F f2, boolean bl, float f3, Object object) {
        if (this.health <= 0.0f) {
            return new G();
        }
        float f4 = f2.computeDamageDealt(f3);
        if (f4 > this.health) {
            f4 = this.health;
        }
        this.health -= f4;
        if (this.health <= 0.0f) {
            this.setDidDamage(this.getLocation(), null, new G());
            boolean bl2 = this.engine.getViewport().isNearViewport(vector2f, this.getCollisionRadius() * 1.5f);
            if (bl2) {
                CombatEngine.getInstance().getExplosionSystem().spawnExplosion(this);
            }
            this.getVelocity().set(0.0f, 0.0f);
        }
        return new G(f2.getType(), f4, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isExpired() {
        return this.trailExtender.void() || this.health < 0.0f;
    }

    @Override
    public float getMass() {
        return this.spec.getImpactMass();
    }

    public float getMoveSpeed() {
        return this.spec.getMoveSpeed(this.source.getStats(), this.weapon);
    }

    public float getBrightness() {
        return this.trailExtender.super();
    }

    @Override
    public boolean isFading() {
        return this.trailExtender.String() > 0.0f;
    }

    public void setDamageAmount(float f2) {
        this.damage.setDamage(f2);
    }

    public float getDamageAmount() {
        return this.damage.getDamage();
    }

    public float getBaseDamageAmount() {
        return this.damage.getBaseDamage();
    }

    public float getEmpAmount() {
        return this.damage.getFluxComponent();
    }

    public DamageType getDamageType() {
        return this.damage.getType();
    }

    public String getProjectileSpecId() {
        return this.spec.getId();
    }

    public ProjectileSpawnType getSpawnType() {
        return this.spec.getSpawnType();
    }

    public float getElapsed() {
        return this.elapsed;
    }

    @Override
    public boolean isFromMissile() {
        return this.fromMissile;
    }

    public void setFromMissile(boolean bl) {
        this.fromMissile = bl;
    }

    public void addDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public void removeDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public ProjectileSpecAPI getProjectileSpec() {
        return this.spec;
    }

    public Vector2f getTailEnd() {
        return this.trailExtender.\u00d600000();
    }

    public List<CombatEntityAPI> getDamagedAlready() {
        return null;
    }
}

