/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.coreui.refit.auto;

import com.fs.starfarer.api.campaign.AutofitVariantsAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.new;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.loading.specs.O;
import com.fs.starfarer.loading.specs.g;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SavedVariantData
implements AutofitVariantsAPI,
DoNotObfuscate {
    public static final int MAX_VISIBLE = 4;
    public static final int MAX_RECENT = 5;
    private Map<String, VariantSet> recent = new HashMap<String, VariantSet>();
    private Map<String, VariantArray> visible = new HashMap<String, VariantArray>();
    private Map<String, HullVariantSpec> variantMap = new HashMap<String, HullVariantSpec>();
    private Map<String, Boolean> optionState = new HashMap<String, Boolean>();

    public static String getBaseHullId(g g2) {
        if (g2.isDefaultDHull() && g2.getDParentHull() != null) {
            g2 = g2.getDParentHull();
        }
        if (g2.isBaseHull() || !g2.isCompatibleWithBase()) {
            return g2.getHullId();
        }
        g g3 = SpecStore.o00000(g.class, g2.getBaseHullId());
        return SavedVariantData.getBaseHullId(g3);
    }

    public void deleteSavedVariant(String string) {
        this.variantMap.remove(string);
    }

    public HullVariantSpec getSavedVariant(String string) {
        return this.variantMap.get(string);
    }

    public Collection<String> getAllSavedVariantIds() {
        return this.variantMap.keySet();
    }

    public void addToVisible(int n2, HullVariantSpec hullVariantSpec) {
        String string2;
        hullVariantSpec = hullVariantSpec.clone();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : hullVariantSpec.getHullMods()) {
            O o2 = SpecStore.o00000(O.class, string2);
            if (!o2.hasTag("dmod")) continue;
            arrayList.add(string2);
        }
        for (String string2 : arrayList) {
            hullVariantSpec.addSuppressedMod(string2);
        }
        string2 = SavedVariantData.getBaseHullId(hullVariantSpec.getHullSpec());
        this.getVisible(string2).add(n2, hullVariantSpec, this.variantMap);
        this.getRecent(string2).remove(hullVariantSpec.getHullVariantId(), this.variantMap);
    }

    public void addToVisible(int n2, String string) {
        HullVariantSpec hullVariantSpec = SpecStore.o00000(HullVariantSpec.class, string);
        String string2 = SavedVariantData.getBaseHullId(hullVariantSpec.getHullSpec());
        this.getVisible(string2).add(n2, string);
        this.getRecent(string2).remove(string, this.variantMap);
    }

    public void removeFromVisible(int n2, String string) {
        HullVariantSpec hullVariantSpec = SpecStore.o00000(HullVariantSpec.class, string);
        String string2 = SavedVariantData.getBaseHullId(hullVariantSpec.getHullSpec());
        this.getVisible(string2).remove(n2, hullVariantSpec.getHullVariantId(), this.variantMap);
    }

    public void removeFromVisible(int n2, HullVariantSpec hullVariantSpec) {
        String string = SavedVariantData.getBaseHullId(hullVariantSpec.getHullSpec());
        this.getRecent(string).add(hullVariantSpec, this.variantMap);
        this.getVisible(string).remove(n2, hullVariantSpec.getHullVariantId(), this.variantMap);
    }

    public List<VariantResolver> getCombinedRecent(String string) {
        List<HullVariantSpec> list = SavedVariantData.getStockGoalVariants(string);
        ArrayList<VariantResolver> arrayList = new ArrayList<VariantResolver>();
        for (HullVariantSpec hullVariantSpec : list) {
            arrayList.add(new VariantResolver(hullVariantSpec.getHullVariantId()));
        }
        VariantSet variantSet = this.getRecent(string);
        for (VariantResolver variantResolver : variantSet.variants) {
            arrayList.add(variantResolver);
        }
        return arrayList;
    }

    public VariantSet getRecent(String string) {
        VariantSet variantSet = this.recent.get(string);
        if (variantSet == null) {
            variantSet = new VariantSet(string, 5);
            this.recent.put(string, variantSet);
        }
        return variantSet;
    }

    public List<ShipVariantAPI> getTargetVariants(String string) {
        g g2 = SpecStore.o00000(g.class, string);
        VariantArray variantArray = this.getVisible(SavedVariantData.getBaseHullId(g2));
        ArrayList<ShipVariantAPI> arrayList = new ArrayList<ShipVariantAPI>();
        for (VariantResolver variantResolver : variantArray.variants) {
            if (variantResolver == null) continue;
            arrayList.add(variantResolver.getVariant());
        }
        return arrayList;
    }

    public VariantArray getVisible(String string) {
        VariantArray variantArray = this.visible.get(string);
        if (variantArray == null) {
            variantArray = new VariantArray(string, 4);
            List<HullVariantSpec> list = SavedVariantData.getStockGoalVariants(string);
            int n2 = 0;
            for (HullVariantSpec hullVariantSpec : list) {
                if (n2 >= 4) break;
                variantArray.add(n2, hullVariantSpec.getHullVariantId());
                ++n2;
            }
            this.visible.put(string, variantArray);
        }
        return variantArray;
    }

    public static List<HullVariantSpec> getStockGoalVariants(String string) {
        List<String> list = new.o00000();
        ArrayList<HullVariantSpec> arrayList = new ArrayList<HullVariantSpec>();
        for (String string2 : list) {
            String string3;
            HullVariantSpec hullVariantSpec = new.o00000(string2);
            if (!hullVariantSpec.isGoalVariant() || !hullVariantSpec.isStockVariant() || (string3 = SavedVariantData.getBaseHullId(hullVariantSpec.getHullSpec())) == null || !string3.equals(string)) continue;
            arrayList.add(hullVariantSpec);
        }
        Collections.sort(arrayList, new Comparator<HullVariantSpec>(){

            public int o00000(HullVariantSpec hullVariantSpec, HullVariantSpec hullVariantSpec2) {
                if (hullVariantSpec.getHullSpec().isBaseHull() && !hullVariantSpec2.getHullSpec().isBaseHull()) {
                    return -1;
                }
                if (hullVariantSpec2.getHullSpec().isBaseHull() && !hullVariantSpec.getHullSpec().isBaseHull()) {
                    return 1;
                }
                int n2 = hullVariantSpec2.getHullSpec().getOrdnancePoints(null) - hullVariantSpec.getHullSpec().getOrdnancePoints(null);
                n2 = hullVariantSpec.getDisplayName().compareTo(hullVariantSpec2.getDisplayName());
                return n2;
            }
        });
        return arrayList;
    }

    public Map<String, Boolean> getOptionState() {
        return this.optionState;
    }

    public Map<String, HullVariantSpec> getVariantMap() {
        return this.variantMap;
    }

    public static class VariantArray
    implements DoNotObfuscate {
        private String baseHullId;
        private List<VariantResolver> variants = new ArrayList<VariantResolver>();
        private final int max;

        public VariantArray(String string, int n2) {
            this.baseHullId = string;
            this.max = n2;
            while (this.variants.size() < n2) {
                this.variants.add(null);
            }
        }

        public List<VariantResolver> getVariants() {
            return this.variants;
        }

        public String getBaseHullId() {
            return this.baseHullId;
        }

        public void add(int n2, String string) {
            while (this.variants.size() < this.max) {
                this.variants.add(null);
            }
            this.variants.set(n2, new VariantResolver(string));
        }

        public void add(int n2, HullVariantSpec hullVariantSpec, Map<String, HullVariantSpec> map) {
            hullVariantSpec = hullVariantSpec.clone();
            String string = "svd_" + hullVariantSpec.getHullSpec().getHullId() + "_" + Misc.genUID();
            hullVariantSpec.setHullVariantId(string);
            hullVariantSpec.setSource(VariantSource.REFIT);
            while (this.variants.size() < this.max) {
                this.variants.add(null);
            }
            this.variants.set(n2, new VariantResolver(hullVariantSpec));
            map.put(string, hullVariantSpec);
            while (this.variants.size() > this.max) {
                VariantResolver variantResolver = this.variants.remove(0);
                if (variantResolver.variant == null) continue;
                map.remove(variantResolver.variant.getHullVariantId());
            }
        }

        public void remove(int n2, String string, Map<String, HullVariantSpec> map) {
            map.remove(string);
            this.variants.set(n2, null);
        }
    }

    public static class VariantResolver
    implements DoNotObfuscate {
        public String variantIdIfStock;
        public HullVariantSpec variant;

        public VariantResolver(String string) {
            this.variantIdIfStock = string;
        }

        public VariantResolver(HullVariantSpec hullVariantSpec) {
            this.variant = hullVariantSpec;
        }

        public HullVariantSpec getVariant() {
            if (this.variantIdIfStock != null) {
                return SpecStore.o00000(HullVariantSpec.class, this.variantIdIfStock);
            }
            return this.variant;
        }
    }

    public static class VariantSet
    implements DoNotObfuscate {
        private String baseHullId;
        private List<VariantResolver> variants = new ArrayList<VariantResolver>();
        private final int max;

        public VariantSet(String string, int n2) {
            this.baseHullId = string;
            this.max = n2;
        }

        public List<VariantResolver> getVariants() {
            return this.variants;
        }

        public String getBaseHullId() {
            return this.baseHullId;
        }

        public void add(String string) {
            this.variants.add(new VariantResolver(string));
            while (this.variants.size() > this.max) {
                this.variants.remove(0);
            }
        }

        public void add(HullVariantSpec hullVariantSpec, Map<String, HullVariantSpec> map) {
            hullVariantSpec = hullVariantSpec.clone();
            String string = "svd_" + hullVariantSpec.getHullSpec().getHullId() + "_" + Misc.genUID();
            hullVariantSpec.setHullVariantId(string);
            hullVariantSpec.setSource(VariantSource.REFIT);
            this.variants.add(new VariantResolver(hullVariantSpec));
            map.put(string, hullVariantSpec);
            while (this.variants.size() > this.max) {
                VariantResolver variantResolver = this.variants.remove(0);
                if (variantResolver.variant == null) continue;
                map.remove(variantResolver.variant.getHullVariantId());
            }
        }

        public void remove(String string, Map<String, HullVariantSpec> map) {
            map.remove(string);
            for (VariantResolver variantResolver : this.variants) {
                String string2 = variantResolver.getVariant().getHullVariantId();
                if (!string2.equals(string)) continue;
                this.variants.remove(variantResolver);
                break;
            }
        }
    }
}

