/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.launcher;

import com.fs.starfarer.Version;
import com.fs.starfarer.api.ModDependencyAPI;
import com.fs.starfarer.api.ModManagerAPI;
import com.fs.starfarer.api.ModPlugin;
import com.fs.starfarer.api.ModSpecAPI;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.VersionInfoAPI;
import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.DroneLauncherShipSystemAPI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.combat.ai.BasicShipAI;
import com.fs.starfarer.combat.ai.FighterAI;
import com.fs.starfarer.combat.ai.M;
import com.fs.starfarer.combat.ai.private;
import com.fs.starfarer.combat.ai.system.drones.DroneAI;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.systems.Q;
import com.fs.starfarer.combat.systems.oO0O;
import com.fs.starfarer.loading.LoadingUtils;
import com.fs.starfarer.loading.scripts.ScriptStore;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModManager
implements ModManagerAPI,
DoNotObfuscate {
    private static Logger log = Logger.getLogger(ModManager.class);
    private static volatile ModManager instance;
    private List<ModSpec> availableMods = new ArrayList<ModSpec>();
    private List<ModSpec> enabledMods = new ArrayList<ModSpec>();
    public static String MODS_KEY;
    private List<ModPlugin> plugins = null;

    static {
        MODS_KEY = "enabledMods";
    }

    public static synchronized ModManager getInstance() {
        if (instance == null) {
            instance = new ModManager();
        }
        return instance;
    }

    private ModManager() {
        this.availableMods.clear();
        this.updateList();
    }

    public synchronized void updateList() {
        String string = StarfarerSettings.super.return();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new RuntimeException(String.format("Mod location [%s] is not a directory", file.getAbsolutePath()));
        }
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                File file2 = new File(file, "mod_info.json");
                if (!file2.exists()) {
                    return false;
                }
                ModSpec modSpec = null;
                try {
                    modSpec = ModManager.this.loadModSpec(file, file2);
                }
                catch (Exception exception) {
                    log.info((Object)String.format("Error loading mod from [%s]", file));
                    log.info((Object)exception.getMessage(), (Throwable)exception);
                    return false;
                }
                try {
                    boolean bl = false;
                    for (ModSpec modSpec2 : ModManager.this.availableMods) {
                        if (modSpec2.getId() == null || !modSpec2.getId().equals(modSpec.getId())) continue;
                        bl = true;
                    }
                    if (!bl) {
                        ModManager.this.availableMods.add(modSpec);
                        log.info((Object)String.format("Found mod: %s [%s]", modSpec.getId(), file.getAbsolutePath()));
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("Error loading mod descriptor [%s]", file2.getAbsolutePath()), exception);
                }
                return true;
            }
        });
        Collections.sort(this.availableMods, new Comparator<ModSpec>(){

            public int super(ModSpec modSpec, ModSpec modSpec2) {
                return modSpec.getName().compareTo(modSpec2.getName());
            }
        });
        this.loadEnabledModList();
    }

    private synchronized ModSpec loadModSpec(File file, File file2) throws IOException, JSONException {
        JSONArray jSONArray;
        Object object;
        Object object2;
        int n2;
        JSONArray jSONArray2;
        FileInputStream fileInputStream = new FileInputStream(file2);
        JSONObject jSONObject = LoadingUtils.\u00d600000(file2.getAbsolutePath(), LoadingUtils.super(fileInputStream));
        ModSpec modSpec = new ModSpec();
        modSpec.setPath(file.getAbsolutePath());
        modSpec.setDirName(file.getName());
        modSpec.setDesc(jSONObject.getString("description"));
        modSpec.setId(jSONObject.getString("id"));
        modSpec.setName(jSONObject.getString("name"));
        modSpec.setSortString(jSONObject.optString("sortString", null));
        modSpec.setVersion(new VersionInfo(jSONObject, "version"));
        modSpec.setGameVersion(new VersionInfo(jSONObject, "gameVersion"));
        modSpec.setRequiredMemoryMB(jSONObject.optInt("requiredMemoryMB", 0));
        if (jSONObject.has("dependencies")) {
            jSONArray2 = jSONObject.getJSONArray("dependencies");
            n2 = 0;
            while (n2 < jSONArray2.length()) {
                object2 = jSONArray2.getJSONObject(n2);
                object = new ModDependency();
                ((ModDependency)object).setId(object2.getString("id"));
                ((ModDependency)object).setName(object2.optString("name", ((ModDependency)object).getId()));
                ((ModDependency)object).setVersion(new VersionInfo((JSONObject)object2, "version"));
                modSpec.getDependencies().add((ModDependencyAPI)object);
                ++n2;
            }
        }
        modSpec.setModPluginClassName(jSONObject.optString("modPlugin", null));
        modSpec.setAuthor(jSONObject.optString("author", null));
        jSONArray2 = jSONObject.optJSONArray("replace");
        if (jSONArray2 != null) {
            n2 = 0;
            while (n2 < jSONArray2.length()) {
                object2 = jSONArray2.getString(n2);
                if (!((String)object2).endsWith("settings.json")) {
                    modSpec.getFullOverrides().add((String)object2);
                }
                ++n2;
            }
        }
        if ((jSONArray = jSONObject.optJSONArray("jars")) != null) {
            int n3 = 0;
            while (n3 < jSONArray.length()) {
                object = jSONArray.getString(n3);
                modSpec.getJars().add((String)object);
                ++n3;
            }
        }
        modSpec.setTotalConversion(jSONObject.optBoolean("totalConversion", false));
        modSpec.setUtility(jSONObject.optBoolean("utility", false));
        return modSpec;
    }

    public synchronized List<ModSpec> getAvailableMods() {
        return this.availableMods;
    }

    public synchronized List<ModSpec> getEnabledMods() {
        return this.enabledMods;
    }

    public synchronized List<ModSpecAPI> getAvailableModsCopy() {
        return new ArrayList<ModSpecAPI>(this.availableMods);
    }

    public synchronized List<ModSpecAPI> getEnabledModsCopy() {
        return new ArrayList<ModSpecAPI>(this.enabledMods);
    }

    public synchronized boolean isModEnabled(String string) {
        for (ModSpec modSpec : this.getEnabledMods()) {
            if (!modSpec.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String getFilename() {
        return String.valueOf(StarfarerSettings.super.return()) + "/" + "enabled_mods.json";
    }

    public synchronized void saveEnabledModList() {
        String string = "";
        for (ModSpec modSpec : this.enabledMods) {
            string = String.valueOf(string) + modSpec.getId() + "|";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        log.info((Object)("Saving enabled mod list [" + string + "]"));
        try {
            ModSpec modSpec;
            modSpec = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (ModSpec object2 : this.enabledMods) {
                jSONArray.put((Object)object2.getId());
            }
            modSpec.put(MODS_KEY, jSONArray);
            String string2 = modSpec.toString(2);
            FileOutputStream fileOutputStream = new FileOutputStream(this.getFilename());
            fileOutputStream.write(string2.getBytes("UTF-8"));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            log.error((Object)"Error saving enabled mod list", (Throwable)exception);
        }
    }

    public synchronized void loadEnabledModList() {
        String[] stringArray;
        String string = "";
        try {
            JSONObject object;
            stringArray = new File(this.getFilename());
            if (stringArray.exists() && (object = LoadingUtils.\u00f400000(this.getFilename())).has(MODS_KEY)) {
                JSONArray jSONArray = object.getJSONArray(MODS_KEY);
                int n2 = 0;
                while (n2 < jSONArray.length()) {
                    String string2 = jSONArray.getString(n2);
                    string = String.valueOf(string) + string2 + "|";
                    ++n2;
                }
                if (!string.isEmpty()) {
                    string = string.substring(0, string.length() - 1);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)"Error loading enabled mod list", (Throwable)exception);
        }
        if (string == null) {
            return;
        }
        stringArray = string.split("\\|");
        this.enabledMods.clear();
        block3: for (ModSpec modSpec : this.availableMods) {
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string3 = stringArray2[n4];
                if (modSpec.getId() != null && modSpec.getId().equals(string3)) {
                    this.enabledMods.add(modSpec);
                    continue block3;
                }
                ++n4;
            }
        }
    }

    public synchronized List<ModPlugin> getEnabledModPlugins() {
        if (this.plugins == null) {
            ArrayList<ModPlugin> arrayList = new ArrayList<ModPlugin>();
            arrayList.add((ModPlugin)StarfarerSettings.\u00d3O0000("coreLifecyclePlugin"));
            for (ModSpec modSpec : this.getEnabledMods()) {
                if (modSpec.getModPluginClassName() == null) continue;
                ModPlugin modPlugin = (ModPlugin)ScriptStore.new(modSpec.getModPluginClassName());
                arrayList.add(modPlugin);
            }
            this.plugins = arrayList;
        }
        return this.plugins;
    }

    public AutofireAIPlugin pickWeaponAIPlugin(final WeaponAPI weaponAPI) {
        AutofireAIPlugin autofireAIPlugin = this.getPriorityPlugin(new O0<AutofireAIPlugin>(){

            @Override
            public PluginPick<AutofireAIPlugin> super(ModPlugin modPlugin) {
                return modPlugin.pickWeaponAutofireAI(weaponAPI);
            }
        });
        if (autofireAIPlugin == null) {
            return new private((Q)weaponAPI);
        }
        return autofireAIPlugin;
    }

    public ShipAIPlugin pickShipAIPlugin(final FleetMember fleetMember, final ShipAPI shipAPI) {
        ShipAIPlugin shipAIPlugin = this.getPriorityPlugin(new O0<ShipAIPlugin>(){

            @Override
            public PluginPick<ShipAIPlugin> super(ModPlugin modPlugin) {
                return modPlugin.pickShipAI((FleetMemberAPI)fleetMember, shipAPI);
            }
        });
        if (shipAIPlugin == null) {
            if (shipAPI.isFighter()) {
                return new FighterAI((Ship)shipAPI, (M)shipAPI.getWing());
            }
            return new BasicShipAI((Ship)shipAPI);
        }
        return shipAIPlugin;
    }

    public ShipAIPlugin pickDroneAIPlugin(final ShipAPI shipAPI, final ShipAPI shipAPI2, final DroneLauncherShipSystemAPI droneLauncherShipSystemAPI) {
        ShipAIPlugin shipAIPlugin = this.getPriorityPlugin(new O0<ShipAIPlugin>(){

            @Override
            public PluginPick<ShipAIPlugin> super(ModPlugin modPlugin) {
                return modPlugin.pickDroneAI(shipAPI, shipAPI2, droneLauncherShipSystemAPI);
            }
        });
        if (shipAIPlugin == null) {
            return new DroneAI((Ship)shipAPI, (Ship)shipAPI2, (oO0O)droneLauncherShipSystemAPI);
        }
        return shipAIPlugin;
    }

    public MissileAIPlugin pickMissileAIOverride(final MissileAPI missileAPI, final ShipAPI shipAPI) {
        MissileAIPlugin missileAIPlugin = this.getPriorityPlugin(new O0<MissileAIPlugin>(){

            @Override
            public PluginPick<MissileAIPlugin> super(ModPlugin modPlugin) {
                return modPlugin.pickMissileAI(missileAPI, shipAPI);
            }
        });
        return missileAIPlugin;
    }

    public <T> T getPriorityPlugin(O0<T> o02) {
        ArrayList<PluginPick<T>> arrayList = new ArrayList<PluginPick<T>>();
        for (ModPlugin modPlugin : this.getEnabledModPlugins()) {
            PluginPick<T> pluginPick = o02.super(modPlugin);
            if (pluginPick == null) continue;
            arrayList.add(pluginPick);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        Collections.sort(arrayList, new Comparator<PluginPick<T>>(){

            public int o00000(PluginPick<T> pluginPick, PluginPick<T> pluginPick2) {
                return pluginPick.priority.ordinal() - pluginPick2.priority.ordinal();
            }
        });
        return (T)((PluginPick)arrayList.get((int)(arrayList.size() - 1))).plugin;
    }

    public synchronized ModSpec getModSpec(String string) {
        for (ModSpec modSpec : this.getEnabledMods()) {
            if (!modSpec.getId().equals(string)) continue;
            return modSpec;
        }
        return null;
    }

    public synchronized ModSpec getAvailableModSpec(String string) {
        for (ModSpec modSpec : this.getAvailableMods()) {
            if (!modSpec.getId().equals(string)) continue;
            return modSpec;
        }
        return null;
    }

    public synchronized int getRequiredMemory() {
        int n2 = (int)StarfarerSettings.if("baseMemoryRequired");
        for (ModSpec modSpec : this.getEnabledMods()) {
            n2 += modSpec.getRequiredMemoryMB();
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        new VersionInfo("0.45.2");
        new VersionInfo("0.42.0");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum oo {
        return,
        \u00d500000,
        \u00d800000,
        \u00d400000,
        Object,
        \u00d200000;

    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        private String \u00d200000;
        private oo super = oo.return;

        public o(String string) {
            this.\u00d200000 = string;
        }

        public String o00000() {
            return this.\u00d200000;
        }

        public oo \u00d200000() {
            return this.super;
        }
    }

    public static class ModDependency
    implements DoNotObfuscate,
    ModDependencyAPI {
        private String id;
        private String name;
        private VersionInfo version;

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public VersionInfoAPI getVersionInfo() {
            return this.version;
        }

        public void setVersion(VersionInfo versionInfo) {
            this.version = versionInfo;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static interface O0<T> {
        public PluginPick<T> super(ModPlugin var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Oo {
        private oo new = oo.return;
        private List<o> o00000 = new ArrayList<o>();

        public Oo(ModSpec modSpec) {
            this.new = Version.versionInfoForMods.getCompatLevel(modSpec.getGameVersionInfo());
            for (ModDependencyAPI modDependencyAPI : modSpec.getAllDependencies()) {
                o o2 = new o(modDependencyAPI.getId());
                ModSpec modSpec2 = ModManager.getInstance().getAvailableModSpec(modDependencyAPI.getId());
                if (modSpec2 == null) {
                    o2.super = oo.\u00d200000;
                } else if (modDependencyAPI.getVersionInfo() != null && modDependencyAPI.getVersionInfo().isSet()) {
                    o2.super = ((VersionInfo)modDependencyAPI.getVersionInfo()).getCompatLevel(modSpec2.getVersionInfo());
                    oo oo2 = oo.Object;
                    if (modSpec2.getGameVersionInfo() != null) {
                        oo2 = ((VersionInfo)modSpec2.getGameVersionInfo()).getCompatLevel(Version.versionInfoForMods);
                    }
                    if (oo2.ordinal() > o2.super.ordinal() && (oo2 == oo.Object || oo2 == oo.\u00d400000)) {
                        o2.super = oo2;
                    }
                }
                this.o00000.add(o2);
            }
        }

        public oo new() {
            oo oo2 = this.new;
            for (o o2 : this.o00000) {
                if (o2.super.ordinal() <= oo2.ordinal()) continue;
                oo2 = o2.super;
            }
            return oo2;
        }

        public oo \u00d300000() {
            return this.new;
        }

        public List<o> o00000() {
            return this.o00000;
        }
    }

    public static class ModSpec
    implements DoNotObfuscate,
    ModSpecAPI {
        private String id;
        private String desc;
        private String name;
        private String sortString;
        private VersionInfo gameVersion;
        private String version;
        private VersionInfo versionInfo;
        private String author;
        private String path;
        private String dirName;
        private boolean totalConversion;
        private boolean utility;
        private String modPluginClassName;
        private Set<String> fullOverrides = new HashSet<String>();
        private List<String> jars = new ArrayList<String>();
        private int requiredMemoryMB = 0;
        private List<ModDependencyAPI> dependencies = new ArrayList<ModDependencyAPI>();

        protected Object readResolve() {
            if (this.versionInfo == null && this.version != null) {
                this.versionInfo = new VersionInfo(this.version);
            }
            return this;
        }

        public String getSortString() {
            return this.sortString;
        }

        public void setSortString(String string) {
            this.sortString = string;
        }

        public int getRequiredMemoryMB() {
            return this.requiredMemoryMB;
        }

        public void setRequiredMemoryMB(int n2) {
            this.requiredMemoryMB = n2;
        }

        public List<ModDependencyAPI> getDependencies() {
            return this.dependencies;
        }

        public List<ModDependencyAPI> getAllDependencies() {
            return this.getAllDependencies(new LinkedHashSet<String>(), this.dependencies);
        }

        private List<ModDependencyAPI> getAllDependencies(Set<String> set, List<ModDependencyAPI> list) {
            ArrayList<ModDependencyAPI> arrayList = new ArrayList<ModDependencyAPI>();
            for (ModDependencyAPI modDependencyAPI : list) {
                if (set.contains(modDependencyAPI.getId())) continue;
                arrayList.add(modDependencyAPI);
                set.add(modDependencyAPI.getId());
                ModSpec modSpec = ModManager.getInstance().getAvailableModSpec(modDependencyAPI.getId());
                if (modSpec == null) continue;
                arrayList.addAll(this.getAllDependencies(set, modSpec.getDependencies()));
            }
            return arrayList;
        }

        public boolean isUtility() {
            return this.utility;
        }

        public void setUtility(boolean bl) {
            this.utility = bl;
        }

        public String getModPluginClassName() {
            return this.modPluginClassName;
        }

        public void setModPluginClassName(String string) {
            this.modPluginClassName = string;
        }

        public boolean isTotalConversion() {
            return this.totalConversion;
        }

        public void setTotalConversion(boolean bl) {
            this.totalConversion = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getDesc() {
            String string = this.desc;
            return string;
        }

        public String getVersion() {
            if (this.versionInfo == null) {
                return null;
            }
            return this.versionInfo.getString();
        }

        public VersionInfoAPI getVersionInfo() {
            return this.versionInfo;
        }

        public void setVersion(VersionInfo versionInfo) {
            this.versionInfo = versionInfo;
        }

        public void setDesc(String string) {
            this.desc = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getDirName() {
            return this.dirName;
        }

        public void setDirName(String string) {
            this.dirName = string;
        }

        public VersionInfoAPI getGameVersionInfo() {
            return this.gameVersion;
        }

        public String getGameVersion() {
            return this.gameVersion != null ? this.gameVersion.getString() : null;
        }

        public void setGameVersion(VersionInfo versionInfo) {
            this.gameVersion = versionInfo;
        }

        public String toString() {
            if (this.isTotalConversion()) {
                return String.valueOf(this.getName()) + " " + this.getVersion() + " (total conversion)";
            }
            return String.valueOf(this.getName()) + " " + this.getVersion();
        }

        public Set<String> getFullOverrides() {
            return this.fullOverrides;
        }

        public List<String> getJars() {
            return this.jars;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String string) {
            this.author = string;
        }
    }

    public static class VersionInfo
    implements VersionInfoAPI,
    DoNotObfuscate {
        private String major = "";
        private String minor = "";
        private String patch = "";
        private String string = null;
        private boolean minorIsRC = false;

        public VersionInfo(String string) {
            this.setFromString(string);
        }

        public VersionInfo(JSONObject jSONObject, String string) {
            String string2 = jSONObject.optString(string);
            if (string2 != null && jSONObject.optJSONObject(string) == null) {
                this.setFromString(string2);
            } else {
                try {
                    if (jSONObject.has(string)) {
                        JSONObject jSONObject2 = jSONObject.getJSONObject(string);
                        this.major = jSONObject2.getString("major");
                        this.minor = jSONObject2.optString("minor", "");
                        this.patch = jSONObject2.optString("patch", "");
                    }
                }
                catch (JSONException jSONException) {
                    throw new RuntimeException(jSONException.getMessage(), jSONException);
                }
            }
        }

        public boolean isSet() {
            return !this.major.isEmpty();
        }

        public oo getCompatLevel(VersionInfoAPI versionInfoAPI) {
            if (versionInfoAPI == null) {
                return oo.Object;
            }
            if (this.major.isEmpty()) {
                return oo.Object;
            }
            if (versionInfoAPI.getMajor() == null || versionInfoAPI.getMajor().isEmpty()) {
                return oo.Object;
            }
            if (!this.major.equals(versionInfoAPI.getMajor())) {
                return oo.\u00d400000;
            }
            if (!(this.minorIsRC && versionInfoAPI instanceof VersionInfo && ((VersionInfo)versionInfoAPI).minorIsRC || this.minor.equals(versionInfoAPI.getMinor()))) {
                return oo.\u00d800000;
            }
            if (!this.patch.equals(versionInfoAPI.getPatch())) {
                return oo.\u00d500000;
            }
            return oo.return;
        }

        public String getString() {
            if (this.string == null) {
                if ((this.patch == null || this.patch.isEmpty()) && (this.minor == null || this.minor.isEmpty())) {
                    return this.major;
                }
                if (this.patch == null || this.patch.isEmpty()) {
                    return String.valueOf(this.major) + "." + this.minor;
                }
                return String.valueOf(this.major) + "." + this.minor + "." + this.patch;
            }
            return this.string;
        }

        public String toString() {
            return "major: " + this.major + " minor: " + this.minor + " patch: " + this.patch;
        }

        public void setFromString(String string) {
            this.string = string;
            String[] stringArray = string.split("\\.|a-RC|a");
            if (string.contains("-RC")) {
                this.minorIsRC = true;
            }
            if (stringArray.length == 2) {
                if (stringArray[0].equals("0")) {
                    this.major = String.valueOf(stringArray[0]) + "." + stringArray[1];
                } else {
                    this.major = stringArray[0];
                    this.minor = stringArray[1];
                }
            } else if (stringArray.length == 3) {
                if (stringArray[0].equals("0")) {
                    this.major = String.valueOf(stringArray[0]) + "." + stringArray[1];
                    this.minor = stringArray[2];
                } else {
                    this.major = stringArray[0];
                    this.minor = stringArray[1];
                    this.patch = stringArray[2];
                }
            } else if (stringArray.length == 4) {
                this.major = String.valueOf(stringArray[0]) + "." + stringArray[1];
                this.minor = stringArray[2];
                this.patch = stringArray[3];
            }
        }

        public String getMajor() {
            return this.major;
        }

        public void setMajor(String string) {
            this.major = string;
        }

        public String getMinor() {
            return this.minor;
        }

        public void setMinor(String string) {
            this.minor = string;
        }

        public String getPatch() {
            return this.patch;
        }

        public void setPatch(String string) {
            this.patch = string;
        }
    }
}

