/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.rpg;

import com.fs.starfarer.String;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.plog.OfficerSkillGainRecord;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.plugins.OfficerLevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.rpg.Person;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class OfficerData
implements DoNotObfuscate,
OfficerDataAPI {
    private Person person;
    private List<java.lang.String> skillPicks = new ArrayList<java.lang.String>();
    private boolean madePicks = false;

    public OfficerData(Person person) {
        this.person = person;
    }

    Object readResolve() {
        if (this.skillPicks == null) {
            this.skillPicks = new ArrayList<java.lang.String>();
        }
        return this;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(PersonAPI personAPI) {
        this.person = (Person)personAPI;
    }

    public void addXP(long l2) {
        this.addXP(l2, null);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI) {
        this.addXP(l2, textPanelAPI, true);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI, boolean bl) {
        CampaignFleet campaignFleet;
        if (Misc.isMercenary((PersonAPI)this.person)) {
            return;
        }
        OfficerLevelupPlugin officerLevelupPlugin = (OfficerLevelupPlugin)StarfarerSettings.\u00d600000("officerLevelUp");
        int n2 = officerLevelupPlugin.getMaxLevel((PersonAPI)this.person);
        if (bl && this.person.getStats().getLevel() >= n2) {
            this.person.getStats().setXP(officerLevelupPlugin.getXPForLevel(n2));
            return;
        }
        long l3 = this.person.getStats().getBonusXp();
        this.person.getStats().addXP(l2, null, false, true, false);
        long l4 = l3 - this.person.getStats().getBonusXp();
        long l5 = officerLevelupPlugin.getXPForLevel(n2);
        if (bl && this.person.getStats().getXP() > l5) {
            long l6 = this.person.getStats().getXP() - l5;
            this.person.getStats().setXP(l5);
            if ((l4 -= l6) < 0L) {
                l2 += l4;
                l4 = 0L;
            }
            if (l2 < 0L) {
                l2 = 0L;
            }
        }
        if ((campaignFleet = CampaignEngine.getInstance().getPlayerFleet()) != null && campaignFleet.getFleetData().getOfficers().contains(this) && l2 > 0L) {
            MessageIntel messageIntel;
            java.lang.String string;
            java.lang.String string2 = Misc.getWithDGS((float)(l2 + l4));
            java.lang.String string3 = Misc.getWithDGS((float)l4);
            if (l4 > 0L) {
                string = java.lang.String.valueOf(this.person.getName().getFullName()) + " gained " + string2 + " experience (" + string3 + " bonus xp used)";
                if (textPanelAPI != null) {
                    textPanelAPI.addParagraph(string, String.void.super);
                    textPanelAPI.highlightInLastPara(new java.lang.String[]{string2, string3});
                    textPanelAPI.setHighlightColorsInLastPara(new Color[]{String.\u00d5O0000, Misc.getStoryOptionColor()});
                } else {
                    messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new java.lang.String[]{string2, string3}, new Color[]{Misc.getHighlightColor(), Misc.getStoryOptionColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            } else {
                string = java.lang.String.valueOf(this.person.getName().getFullName()) + " gained " + string2 + " experience";
                if (textPanelAPI != null) {
                    textPanelAPI.addParagraph(string, String.void.super);
                    textPanelAPI.highlightLastInLastPara(string2, String.\u00d5O0000);
                } else {
                    messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new java.lang.String[]{string2}, new Color[]{Misc.getHighlightColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            }
            if (this.canLevelUp()) {
                string = java.lang.String.valueOf(this.person.getName().getFullName()) + " is ready to level up";
                if (textPanelAPI != null) {
                    textPanelAPI.addParagraph(string, String.\u00f5o0000);
                } else {
                    messageIntel = new MessageIntel(string, Misc.getBasePlayerColor());
                    messageIntel.setIcon(this.person.getPortraitSprite());
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            }
        }
        if (this.canLevelUp() && !this.madePicks) {
            this.makeSkillPicks();
        }
    }

    public void makeSkillPicks() {
        this.makeSkillPicks(null);
    }

    public void makeSkillPicks(Random random) {
        OfficerLevelupPlugin officerLevelupPlugin = (OfficerLevelupPlugin)StarfarerSettings.\u00d600000("officerLevelUp");
        this.skillPicks.clear();
        this.skillPicks.addAll(officerLevelupPlugin.pickLevelupSkills((PersonAPI)this.person, random));
        this.madePicks = true;
    }

    public boolean canLevelUp() {
        int n2;
        OfficerLevelupPlugin officerLevelupPlugin = (OfficerLevelupPlugin)StarfarerSettings.\u00d600000("officerLevelUp");
        return officerLevelupPlugin.getXPForLevel(n2 = this.person.getStats().getLevel() + 1) <= this.person.getStats().getXP() && n2 <= officerLevelupPlugin.getMaxLevel((PersonAPI)this.person);
    }

    public boolean canLevelUp(boolean bl) {
        int n2;
        OfficerLevelupPlugin officerLevelupPlugin = (OfficerLevelupPlugin)StarfarerSettings.\u00d600000("officerLevelUp");
        return officerLevelupPlugin.getXPForLevel(n2 = this.person.getStats().getLevel() + 1) <= this.person.getStats().getXP() && (bl || n2 <= officerLevelupPlugin.getMaxLevel((PersonAPI)this.person));
    }

    public void levelUp(java.lang.String string) {
        this.levelUp(string, null);
    }

    public void levelUp(java.lang.String string, Random random) {
        CampaignFleet campaignFleet;
        CharacterStats characterStats = this.person.getStats();
        int n2 = this.person.getStats().getLevel() + 1;
        characterStats.setLevel(n2);
        characterStats.increaseSkill(string);
        this.skillPicks.clear();
        this.madePicks = false;
        if (this.canLevelUp()) {
            this.makeSkillPicks(random);
        }
        if ((campaignFleet = CampaignEngine.getInstance().getPlayerFleet()) != null && campaignFleet.getFleetData().getOfficers().contains(this)) {
            OfficerSkillGainRecord officerSkillGainRecord = new OfficerSkillGainRecord(this.person.getId(), string, characterStats.getSkillLevel(string) >= 2.0f);
            PlaythroughLog.getInstance().addOfficerSkillRecord(officerSkillGainRecord);
        }
    }

    public List<java.lang.String> getSkillPicks() {
        return this.skillPicks;
    }

    public boolean isMadePicks() {
        return this.madePicks;
    }
}

