package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;

public class FieldModulation {
	
	public static float SHIELD_DAMAGE_REDUCTION = 15f;
	public static float FLUX_SHUNT_DISSIPATION = 20f;
	
	public static float PHASE_FLUX_UPKEEP_REDUCTION = 25f;
	public static float PHASE_COOLDOWN_REDUCTION = 50f;
	
	public static float ELITE_DAMAGE_TO_SHIELDS_PERCENT = 5f;
	public static float OVERLOAD_REDUCTION = 25f;


	public static class Level1 implements ShipSkillEffect {
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getShieldDamageTakenMult().modifyMult(id, 1f - SHIELD_DAMAGE_REDUCTION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getShieldDamageTakenMult().unmodify(id);
		}
		
		public String getEffectDescription(float level) {
			return "-" + (int)(SHIELD_DAMAGE_REDUCTION) + "% damage taken by shields";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}

		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level2 implements ShipSkillEffect {

		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getPhaseCloakUpkeepCostBonus().modifyMult(id, 1f - PHASE_FLUX_UPKEEP_REDUCTION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getPhaseCloakUpkeepCostBonus().unmodify(id);
		}
		
		public String getEffectDescription(float level) {
			return "-" + (int)(PHASE_FLUX_UPKEEP_REDUCTION) + "% flux generated by active phase cloak";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level3 implements ShipSkillEffect {

		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getHardFluxDissipationFraction().modifyFlat(id, FLUX_SHUNT_DISSIPATION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getHardFluxDissipationFraction().unmodify(id);
		}	
		
		public String getEffectDescription(float level) {
			return "" + (int)(FLUX_SHUNT_DISSIPATION) + "% hard flux dissipation while shields are active";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level4 implements ShipSkillEffect {
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getPhaseCloakCooldownBonus().modifyMult(id, 1f - PHASE_COOLDOWN_REDUCTION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getPhaseCloakCooldownBonus().unmodify(id);
		}
		
		public String getEffectDescription(float level) {
			return "-" + (int)(PHASE_COOLDOWN_REDUCTION) + "% phase cloak cooldown";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	
	public static class Level5 implements ShipSkillEffect {

		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getDamageToTargetShieldsMult().modifyPercent(id, ELITE_DAMAGE_TO_SHIELDS_PERCENT);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getDamageToTargetShieldsMult().unmodifyPercent(id);
		}
		
		public String getEffectDescription(float level) {
			return "+" + (int)(ELITE_DAMAGE_TO_SHIELDS_PERCENT) + "% damage dealt to shields";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level6 implements ShipSkillEffect {
		
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getOverloadTimeMod().modifyMult(id, 1f - OVERLOAD_REDUCTION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getOverloadTimeMod().unmodify(id);
		}	
		
		public String getEffectDescription(float level) {
			return "-" + (int)(OVERLOAD_REDUCTION) + "% overload duration";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
}
