/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.anim;

import com.fs.graphics.anim.Animation;
import com.fs.graphics.util.GenericTask;

public class BaseAnimation
implements Animation {
    private float duration = 1.0f;
    private int numFrames = 1;
    private boolean looping;
    private boolean reverse;
    private GenericTask before;
    private GenericTask after;
    private float elapsed;
    private float progress;
    private int currFrame;
    private int currLoop;
    private boolean stopNow = false;

    public void advance(float f) {
        float f2 = this.duration / (float)this.numFrames;
        this.elapsed += f;
        if (this.elapsed >= this.duration) {
            if (this.looping) {
                while (this.elapsed >= this.duration) {
                    this.elapsed -= this.duration;
                }
                ++this.currLoop;
            } else {
                this.progress = 1.0f;
                this.currFrame = this.numFrames - 1;
                return;
            }
        }
        this.currFrame = this.reverse ? this.numFrames - (int)(this.elapsed / f2) - 1 : (int)(this.elapsed / f2);
        this.progress = this.elapsed / this.duration;
    }

    public void stop() {
        this.stopNow = true;
    }

    public void finished() {
        if (this.after != null) {
            this.after.perform();
        }
    }

    public void started() {
        if (this.before != null) {
            this.before.perform();
        }
    }

    public boolean isDone() {
        return this.stopNow || !this.looping && this.elapsed >= this.duration;
    }

    public int getCurrFrame() {
        return this.currFrame;
    }

    public int getCurrLoop() {
        return this.currLoop;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float f) {
        this.duration = f;
    }

    public float getElapsed() {
        return this.elapsed;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean bl) {
        this.looping = bl;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void setNumFrames(int n) {
        this.numFrames = n;
    }

    public float getProgress() {
        return this.progress;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public void setAfter(GenericTask genericTask) {
        this.after = genericTask;
    }

    public void setBefore(GenericTask genericTask) {
        this.before = genericTask;
    }
}

