/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.anim.func;

import com.fs.graphics.anim.BaseAnimation;

public class NormalizedApproacher
extends BaseAnimation {
    public static final int QUADRATIC = 1;
    public static final int SQRT = 2;
    public static final int LINEAR = 3;
    public static final int INV_QUADRATIC = 4;
    private float value;
    private float target;
    private float rate;
    private int function = 3;
    private float delay = 0.0f;
    private boolean started = false;
    private boolean done = false;

    public NormalizedApproacher(float f, int n) {
        if (f <= 0.0f) {
            f = 1.0E-4f;
        }
        this.setDuration(f);
        this.value = 0.0f;
        this.target = 1.0f;
        this.function = n;
        this.advance(0.0f);
    }

    public void advance(float f) {
        float f2;
        float f3 = this.getElapsed();
        float f4 = this.getDuration();
        if (this.getElapsed() <= this.delay) {
            return;
        }
        this.started = true;
        f3 -= this.delay;
        if (this.value == this.target) {
            this.done = true;
            return;
        }
        if (this.function == 3) {
            this.rate = 1.0f / f4;
        } else if (this.function == 1) {
            f2 = 1.0f / f4;
            this.rate = 3.0f * f2 * f4 / 1.0f * (float)Math.pow(f3 / 1.0f, 2.0) / (float)Math.pow(f4 / 1.0f, 3.0);
        } else if (this.function == 2) {
            f2 = 1.0f / f4;
            this.rate = 1.5f * f2 * (float)Math.sqrt(f3 / f4);
        } else if (this.function == 4) {
            f2 = 1.0f / f4;
            this.rate = 3.0f * f2 * f4 / 1.0f * (float)Math.pow((f4 - f3) / 1.0f, 2.0) / (float)Math.pow(f4 / 1.0f, 3.0);
            if (this.rate < 1.0E-4f) {
                this.value = 1.0f;
            }
        }
        f2 = this.value;
        this.value += f * this.rate * Math.signum(this.target - this.value);
        if (this.target > this.value && f2 > this.target) {
            this.value = this.target;
        }
        if (this.target < this.value && f2 < this.target) {
            this.value = this.target;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public float getValue() {
        return this.value;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public boolean isStarted() {
        return this.started;
    }
}

