/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.particle;

import com.fs.graphics.C;
import com.fs.graphics.G;
import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.util.B;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class NegativeParticle
extends BaseParticle
implements DoNotObfuscate {
    private Color color;
    private float size;
    private static final String TEXTURE_ID = "graphics/fx/particlealpha64linear.png";
    private static final String TEXTURE_FILE = "graphics/fx/particlealpha64linear.png";
    private static C texture = null;
    private C override = null;
    private static ByteBuffer colors;
    private static FloatBuffer vertices;
    private static FloatBuffer texCoords;
    private static int numPoints;
    private float offsetX;
    private float offsetY;

    static {
        numPoints = 0;
    }

    public NegativeParticle(Color color, float f) {
        this.color = color;
        this.setSize(f);
        if (texture == null) {
            texture = G.new("graphics/fx/particlealpha64linear.png");
            try {
                G.o00000("graphics/fx/particlealpha64linear.png", "graphics/fx/particlealpha64linear.png");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            texture = G.new("graphics/fx/particlealpha64linear.png");
            if (texture == null) {
                throw new RuntimeException("Error loading negative particle texture");
            }
        }
    }

    public void preBatch() {
        GL14.glBlendEquation((int)32779);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (this.override != null) {
            this.override.\u00d800000();
        } else {
            texture.\u00d800000();
        }
        GL11.glBegin((int)7);
    }

    public void preBatch(int n) {
    }

    public void postBatch() {
        if (colors != null) {
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            GL11.glEnableClientState((int)32888);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            if (this.override != null) {
                this.override.\u00d800000();
            } else {
                texture.\u00d800000();
            }
            colors.flip();
            vertices.flip();
            texCoords.flip();
            GL11.glColorPointer((int)4, (boolean)true, (int)0, (ByteBuffer)colors);
            GL11.glVertexPointer((int)2, (int)0, (FloatBuffer)vertices);
            GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)texCoords);
            GL11.glDrawArrays((int)7, (int)0, (int)numPoints);
            GL11.glDisable((int)3553);
            GL11.glDisableClientState((int)32884);
            GL11.glDisableClientState((int)32886);
            GL11.glDisableClientState((int)32888);
            colors = null;
            vertices = null;
            texCoords = null;
            numPoints = 0;
        } else {
            GL11.glEnd();
            GL11.glDisable((int)3553);
        }
        GL14.glBlendEquation((int)32774);
    }

    public void render() {
        if (colors != null) {
            Color color = B.\u00d300000(this.color, this.getBrightness());
            int n = 0;
            while (n < 4) {
                colors.put((byte)color.getRed()).put((byte)color.getGreen()).put((byte)color.getBlue()).put((byte)color.getAlpha());
                ++n;
            }
            float f = this.getX();
            float f2 = this.getY();
            texCoords.put(0.0f).put(0.0f);
            vertices.put(f + this.offsetX).put(f2 + this.offsetY);
            texCoords.put(0.0f).put(1.0f);
            vertices.put(f + this.offsetX).put(f2 + this.offsetY + this.size);
            texCoords.put(1.0f).put(1.0f);
            vertices.put(f + this.offsetX + this.size).put(f2 + this.offsetY + this.size);
            texCoords.put(1.0f).put(0.0f);
            vertices.put(f + this.offsetX + this.size).put(f2 + this.offsetY);
        } else {
            GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * this.getBrightness())));
            float f = this.getX();
            float f3 = this.getY();
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)(f + this.offsetX), (float)(f3 + this.offsetY));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex2f((float)(f + this.offsetX), (float)(f3 + this.offsetY + this.size));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex2f((float)(f + this.offsetX + this.size), (float)(f3 + this.offsetY + this.size));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex2f((float)(f + this.offsetX + this.size), (float)(f3 + this.offsetY));
        }
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float f) {
        this.size = f;
        this.offsetX = -f / 2.0f;
        this.offsetY = -f / 2.0f;
    }

    public void setTexture(C c) {
        this.override = c;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public Color getColor() {
        return this.color;
    }
}

