/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.util;

import com.fs.util.DoNotObfuscate;

public class Fader
implements DoNotObfuscate {
    private float currBrightness;
    private float durationIn;
    private float durationOut;
    private State state;
    private boolean bounceDown = false;
    private boolean bounceUp = false;

    public Fader(float f, float f2) {
        this.currBrightness = f;
        this.durationIn = f2;
        this.durationOut = f2;
        this.state = State.IDLE;
    }

    public Fader(float f, float f2, float f3) {
        this.currBrightness = f;
        this.durationIn = f2;
        this.durationOut = f3;
        this.state = State.IDLE;
    }

    public Fader(float f, float f2, float f3, boolean bl, boolean bl2) {
        this(f, f2, f3);
        this.setBounce(bl, bl2);
    }

    public void setBounceDown(boolean bl) {
        this.bounceDown = bl;
    }

    public void setBounceUp(boolean bl) {
        this.bounceUp = bl;
    }

    public void setBounce(boolean bl, boolean bl2) {
        this.bounceUp = bl;
        this.bounceDown = bl2;
    }

    public void forceIn() {
        this.currBrightness = 1.0f;
        this.state = this.bounceDown ? State.OUT : State.IDLE;
    }

    public void forceOut() {
        this.currBrightness = 0.0f;
        this.state = this.bounceUp ? State.IN : State.IDLE;
    }

    public void fadeIn() {
        if (this.durationIn <= 0.0f) {
            this.forceIn();
        } else {
            this.state = State.IN;
        }
    }

    public void fadeOut() {
        if (this.durationOut <= 0.0f) {
            this.forceOut();
        } else {
            this.state = State.OUT;
        }
    }

    public boolean isFadedOut() {
        return this.getBrightness() == 0.0f && (this.isIdle() || this.isFadingOut());
    }

    public boolean isFadedIn() {
        return this.getBrightness() == 1.0f && this.isIdle();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isFadingOut() {
        return this.state == State.OUT;
    }

    public boolean isFadingIn() {
        return this.state == State.IN;
    }

    public boolean isIdle() {
        return this.state == State.IDLE;
    }

    public void advance(float f) {
        if (this.state == State.IDLE) {
            return;
        }
        if (this.state == State.IN) {
            if (this.currBrightness == 1.0f) {
                this.state = this.bounceDown ? State.OUT : State.IDLE;
                return;
            }
            float f2 = f / this.durationIn;
            this.currBrightness += f2;
            if (this.currBrightness > 1.0f) {
                this.currBrightness = 1.0f;
            }
        } else if (this.state == State.OUT) {
            if (this.currBrightness == 0.0f) {
                this.state = this.bounceUp ? State.IN : State.IDLE;
                return;
            }
            float f3 = f / this.durationOut;
            this.currBrightness -= f3;
            if (this.currBrightness < 0.0f) {
                this.currBrightness = 0.0f;
            }
        }
    }

    public void setDurationIn(float f) {
        this.durationIn = f;
    }

    public void setDurationOut(float f) {
        this.durationOut = f;
    }

    public Fader setDuration(float f, float f2) {
        this.durationIn = f;
        this.durationOut = f2;
        return this;
    }

    public float getBrightness() {
        return this.currBrightness;
    }

    public float getDurationIn() {
        return this.durationIn;
    }

    public float getDurationOut() {
        return this.durationOut;
    }

    public void setBrightness(float f) {
        this.currBrightness = f;
    }

    public String toString() {
        return String.format("%s, curr: %f, in: %f, out: %f, up: %b, down: %b", this.state.name(), Float.valueOf(this.currBrightness), Float.valueOf(this.durationIn), Float.valueOf(this.durationOut), this.bounceUp, this.bounceDown);
    }

    public boolean isBounceDown() {
        return this.bounceDown;
    }

    public boolean isBounceUp() {
        return this.bounceUp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State implements DoNotObfuscate
    {
        IN,
        OUT,
        IDLE;

    }
}

