/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.util.DoNotObfuscate;
import java.util.GregorianCalendar;

public class CampaignClock
implements CampaignClockAPI,
DoNotObfuscate {
    public static float SECONDS_PER_GAME_DAY = 10.0f;
    private static final float SECONDS_PER_REAL_DAY = 86400.0f;
    private static final long MILLISECONDS_PER_REAL_DAY = 86400000L;
    private float secondsPerDay = SECONDS_PER_GAME_DAY;
    private long timestamp;
    private transient GregorianCalendar cal = new GregorianCalendar(206, 0, 1);

    public CampaignClock() {
        this.timestamp = this.cal.getTimeInMillis();
    }

    Object readResolve() {
        this.cal = new GregorianCalendar();
        this.cal.setTimeInMillis(this.timestamp);
        return this;
    }

    public void set(int n2, int n3, int n4) {
        this.cal.set(n2, n3, n4);
    }

    public String getDateString() {
        return String.valueOf(this.getShortMonthString()) + " " + this.getDay() + ", c" + this.getCycle();
    }

    public String getShortDate() {
        return this.getCycle() + "." + this.getMonth() + "." + this.getDay();
    }

    public String getCycleString() {
        return "c" + this.getCycle();
    }

    public void advance(float f2) {
        int n2 = (int)(f2 / this.secondsPerDay * 86400.0f);
        this.cal.add(13, n2);
        this.timestamp = this.cal.getTimeInMillis();
    }

    public int getCycle() {
        return this.cal.get(1);
    }

    public int getMonth() {
        return this.cal.get(2) + 1;
    }

    public int getDay() {
        return this.cal.get(5);
    }

    public int getHour() {
        return this.cal.get(11);
    }

    public GregorianCalendar getCal() {
        return this.cal;
    }

    public float convertToDays(float f2) {
        return f2 / this.secondsPerDay;
    }

    public float convertToSeconds(float f2) {
        return f2 * this.secondsPerDay;
    }

    public float convertToMonths(float f2) {
        return f2 / this.secondsPerDay / 30.0f;
    }

    public CampaignClock createClock(long l) {
        CampaignClock campaignClock = new CampaignClock();
        campaignClock.timestamp = l;
        campaignClock.readResolve();
        return campaignClock;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public float getElapsedDaysSince(long l) {
        if (l == 0L) {
            return Float.MAX_VALUE;
        }
        double d2 = (double)(this.getTimestamp() - l) / 8.64E7;
        if (d2 > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        return (float)d2;
    }

    public String getMonthString() {
        switch (this.getMonth()) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "Unknown: [" + this.getMonth() + "]";
    }

    public String getShortMonthString() {
        switch (this.getMonth()) {
            case 1: {
                return "Jan";
            }
            case 2: {
                return "Feb";
            }
            case 3: {
                return "Mar";
            }
            case 4: {
                return "Apr";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "Jun";
            }
            case 7: {
                return "Jul";
            }
            case 8: {
                return "Aug";
            }
            case 9: {
                return "Sep";
            }
            case 10: {
                return "Oct";
            }
            case 11: {
                return "Nov";
            }
            case 12: {
                return "Dec";
            }
        }
        return "Unk: [" + this.getMonth() + "]";
    }

    public float getSecondsPerDay() {
        return this.secondsPerDay;
    }

    public static void main(String[] stringArray) {
        CampaignClock campaignClock = new CampaignClock();
        long l = campaignClock.getTimestamp();
        campaignClock.advance(100.0f);
        System.out.println(campaignClock.getElapsedDaysSince(l));
        System.out.println(campaignClock.getShortMonthString());
    }
}

