/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.C;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.MutatingValue;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class DynamicRingBand
implements DoNotObfuscate {
    private float bandWidthInTexture;
    private int bandIndex;
    private Color color;
    private float bandWidthInEngine;
    private float angularVelocity;
    private float innerRadius;
    private float pixelsPerSegment;
    private transient C texture;
    private float angle = (float)Math.random() * 360.0f;
    private float waveAngle = (float)Math.random() * 360.0f;
    private final String category;
    private final String key;
    private float maxFluctuation;
    private boolean additiveBlend;
    private float fluctuationAngVel;
    private float fluctuationAngleMult;
    private float extraAlphaMult = 1.0f;
    private List<MutatingValue> offsets = new ArrayList<MutatingValue>();

    public DynamicRingBand(String string, String string2, float f2, int n2, Color color, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        this.category = string;
        this.key = string2;
        this.bandWidthInTexture = f2;
        this.bandIndex = n2;
        this.color = color;
        this.bandWidthInEngine = f3;
        this.pixelsPerSegment = f4;
        this.angularVelocity = f6;
        this.innerRadius = f5;
        this.maxFluctuation = f7;
        this.fluctuationAngVel = f8;
        this.fluctuationAngleMult = f9;
        this.additiveBlend = bl;
        this.readResolve();
    }

    protected Object readResolve() {
        this.texture = StarfarerSettings.\u00d300000(this.category, this.key);
        return this;
    }

    public void advance(float f2) {
        this.angle += this.angularVelocity * f2;
        this.waveAngle += this.fluctuationAngVel * f2;
        for (MutatingValue mutatingValue : this.offsets) {
            mutatingValue.advance(f2);
        }
    }

    public float getExtraAlphaMult() {
        return this.extraAlphaMult;
    }

    public void setExtraAlphaMult(float f2) {
        this.extraAlphaMult = f2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getInnerRadius() {
        return this.innerRadius;
    }

    private void updateOffsets() {
        float f2 = (float)(Math.PI * 2 * (double)this.innerRadius);
        int n2 = Math.round(f2 / this.pixelsPerSegment);
        if (this.offsets.size() != n2) {
            while (this.offsets.size() > n2 && n2 > 0) {
                this.offsets.remove(this.offsets.size() - 1);
            }
            while (this.offsets.size() < n2) {
                MutatingValue mutatingValue = new MutatingValue(-this.maxFluctuation, this.maxFluctuation, this.maxFluctuation * (1.0f + (float)Math.random()));
                mutatingValue.setRandomRateSign();
                mutatingValue.setValue(0.0f);
                this.offsets.add(mutatingValue);
            }
        }
    }

    public void render(float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        f4 *= this.extraAlphaMult;
        this.updateOffsets();
        float f14 = this.bandWidthInEngine * 1.0f;
        float f15 = (float)(Math.PI * 2 * (double)this.innerRadius);
        float f16 = Math.round(f15 / this.pixelsPerSegment);
        float f17 = (float)Math.toRadians(0.0);
        float f18 = (float)Math.toRadians(360.0);
        float f19 = Utils.o00000(f18 - f17);
        float f20 = f19 / f16;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        this.texture.\u00d800000();
        GL11.glEnable((int)3042);
        if (this.additiveBlend) {
            GL11.glBlendFunc((int)770, (int)1);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * f4)));
        float f21 = this.innerRadius;
        float f22 = 0.0f;
        float f23 = this.texture.o00000();
        float f24 = this.texture.\u00d400000();
        float f25 = this.pixelsPerSegment * f23 / f24 * this.bandWidthInTexture / f14;
        float f26 = Math.max(1.0f, (float)Math.round(f25 * f16));
        f25 = f26 / f16;
        float f27 = this.texture.while();
        float f28 = this.texture.\u00d300000();
        float f29 = (float)this.bandIndex * f27 * this.bandWidthInTexture / f28;
        float f30 = ((float)this.bandIndex + 1.0f) * f27 * this.bandWidthInTexture / f28 - 0.001f;
        GL11.glBegin((int)8);
        float f31 = 0.0f;
        while (f31 < f16) {
            f13 = f20 * f31;
            f12 = (float)Math.cos(f13);
            f11 = (float)Math.sin(f13);
            f10 = 0.0f;
            if ((float)this.offsets.size() > f31) {
                f10 = this.offsets.get((int)f31).getValue();
            }
            f9 = this.maxFluctuation * (f10 *= (float)Math.sin((double)(f13 * this.fluctuationAngleMult) + Math.toRadians(this.waveAngle)));
            f9 = f10;
            f8 = f12 * (f21 + f9);
            f7 = f11 * (f21 + f9);
            f6 = f12 * (f21 + f14 + f9);
            f5 = f11 * (f21 + f14 + f9);
            GL11.glTexCoord2f((float)f29, (float)f22);
            GL11.glVertex2f((float)f8, (float)f7);
            GL11.glTexCoord2f((float)f30, (float)f22);
            GL11.glVertex2f((float)f6, (float)f5);
            f22 += f25;
            f31 += 1.0f;
        }
        int n2 = 0;
        f13 = f20 * (float)n2;
        f12 = (float)Math.cos(f13);
        f11 = (float)Math.sin(f13);
        f10 = 0.0f;
        if (this.offsets.size() > n2) {
            f10 = this.offsets.get(n2).getValue();
        }
        f9 = this.maxFluctuation * (f10 *= (float)Math.sin((double)(f13 * this.fluctuationAngleMult) + Math.toRadians(this.waveAngle)));
        f9 = f10;
        f8 = f12 * (f21 + f9);
        f7 = f11 * (f21 + f9);
        f6 = f12 * (f21 + f14 + f9);
        f5 = f11 * (f21 + f14 + f9);
        GL11.glTexCoord2f((float)f29, (float)f22);
        GL11.glVertex2f((float)f8, (float)f7);
        GL11.glTexCoord2f((float)f30, (float)f22);
        GL11.glVertex2f((float)f6, (float)f5);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public float getBandWidthInTexture() {
        return this.bandWidthInTexture;
    }

    public void setBandWidthInTexture(float f2) {
        this.bandWidthInTexture = f2;
    }

    public int getBandIndex() {
        return this.bandIndex;
    }

    public void setBandIndex(int n2) {
        this.bandIndex = n2;
    }

    public float getBandWidthInEngine() {
        return this.bandWidthInEngine;
    }

    public void setBandWidthInEngine(float f2) {
        this.bandWidthInEngine = f2;
    }

    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(float f2) {
        this.angularVelocity = f2;
    }

    public float getPixelsPerSegment() {
        return this.pixelsPerSegment;
    }

    public void setPixelsPerSegment(float f2) {
        this.pixelsPerSegment = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getWaveAngle() {
        return this.waveAngle;
    }

    public void setWaveAngle(float f2) {
        this.waveAngle = f2;
    }

    public float getMaxFluctuation() {
        return this.maxFluctuation;
    }

    public void setMaxFluctuation(float f2) {
        if (this.maxFluctuation != f2) {
            this.offsets.clear();
        }
        this.maxFluctuation = f2;
    }

    public boolean isAdditiveBlend() {
        return this.additiveBlend;
    }

    public void setAdditiveBlend(boolean bl) {
        this.additiveBlend = bl;
    }

    public float getFluctuationAngVel() {
        return this.fluctuationAngVel;
    }

    public void setFluctuationAngVel(float f2) {
        this.fluctuationAngVel = f2;
    }

    public float getFluctuationAngleMult() {
        return this.fluctuationAngleMult;
    }

    public void setFluctuationAngleMult(float f2) {
        this.fluctuationAngleMult = f2;
    }

    public void setInnerRadius(float f2) {
        this.innerRadius = f2;
    }
}

