/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CharacterDataAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AdminData;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.rpg.Person;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerCharacterData
implements DoNotObfuscate,
CharacterDataAPI {
    public static String SAVEFILE_VERSION_0951a = "0.95.1a";
    private String name = "Default";
    private String portraitName = "graphics/portraits/portrait_hegemony01.png";
    private Person person;
    private boolean isIronMode = false;
    private Set<String> abilities = new HashSet<String>();
    private Set<String> hullMods = new HashSet<String>();
    private Set<String> skillsEverMadeElite = new HashSet<String>();
    private Map<String, Object> custom = new HashMap<String, Object>();
    private List<AdminData> admins = new ArrayList<AdminData>();
    private String honorific;
    private String savefileVersion = SAVEFILE_VERSION_0951a;
    private Memory memory;

    public PlayerCharacterData() {
        this.person = new Person("steady");
        this.person.setPortraitSprite(this.portraitName);
    }

    public String getSavefileVersion() {
        return this.savefileVersion;
    }

    public void setSavefileVersion(String string) {
        this.savefileVersion = string;
    }

    public List<AdminData> getAdmins() {
        return this.admins;
    }

    public void addAdmin(PersonAPI personAPI) {
        this.removeAdmin(personAPI);
        AdminData adminData = new AdminData(personAPI);
        personAPI.setFaction("player");
        this.admins.add(adminData);
    }

    public void removeAdmin(PersonAPI personAPI) {
        for (AdminData adminData : new ArrayList<AdminData>(this.admins)) {
            if (adminData.getPerson() != personAPI) continue;
            adminData.getPerson().setFaction("independent");
            this.admins.remove(adminData);
        }
    }

    public Set<String> getAbilities() {
        return this.abilities;
    }

    public void addAbility(String string) {
        this.abilities.add(string);
        CampaignEngine.getInstance().getPlayerFleet().addAbility(string);
    }

    public void removeAbility(String string) {
        this.abilities.remove(string);
        CampaignEngine.getInstance().getPlayerFleet().removeAbility(string);
    }

    public boolean knowsHullMod(String string) {
        return CampaignEngine.getInstance().getCampaignUI().isHullModAvailable(string);
    }

    public Set<String> getHullMods() {
        return this.hullMods;
    }

    public void addHullMod(String string) {
        this.hullMods.add(string);
    }

    public void removeHullMod(String string) {
        this.hullMods.remove(string);
    }

    public MemoryAPI getMemory() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        for (CampaignPlugin campaignPlugin : CampaignEngine.getInstance().getModAndPluginData().getPlugins()) {
            campaignPlugin.updatePlayerFacts((MemoryAPI)this.memory);
        }
        return this.memory;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    Object readResolve() {
        if (this.person == null) {
            this.person = new Person("steady");
            this.person.setPortraitSprite(this.portraitName);
        }
        this.person.setPortraitSprite(this.portraitName);
        if (this.hullMods == null) {
            this.hullMods = new HashSet<String>();
        }
        if (this.admins == null) {
            this.admins = new ArrayList<AdminData>();
        }
        if (this.skillsEverMadeElite == null) {
            this.skillsEverMadeElite = new HashSet<String>();
        }
        return this;
    }

    public Set<String> getSkillsEverMadeElite() {
        return this.skillsEverMadeElite;
    }

    public Person getPerson() {
        return this.person;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.setName(string, FullName.Gender.ANY);
    }

    public void setName(String string, FullName.Gender gender) {
        this.name = string = string.trim();
        String string2 = string;
        String string3 = "";
        if (string.contains(" ")) {
            string2 = string.split(" ")[0];
            string3 = string.substring(string.indexOf(32) + 1);
        }
        this.person.setName(new FullName(string2, string3, gender));
    }

    public String getPortraitName() {
        return this.person.getPortraitSprite();
    }

    public void setPortraitName(String string) {
        this.portraitName = string;
        this.person.setPortraitSprite(string);
    }

    public boolean isIronMode() {
        return this.isIronMode;
    }

    public void setIronMode(boolean bl) {
        this.isIronMode = bl;
    }

    public Map<String, Object> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, Object> map) {
        this.custom = map;
    }

    public String getHonorific() {
        return this.honorific;
    }

    public void setHonorific(String string) {
        this.honorific = string;
    }
}

