/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.comms;

import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.campaign.CampaignClock;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.util.DoNotObfuscate;
import com.fs.util.container.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerTransactionLineItemData
implements DoNotObfuscate {
    private Map<Pair<CargoAPI.CargoItemType, String>, List<PlayerMarketTransaction.TransactionLineItem>> data = new HashMap<Pair<CargoAPI.CargoItemType, String>, List<PlayerMarketTransaction.TransactionLineItem>>();

    public void performCleanup(float f2) {
        CampaignClock campaignClock = CampaignEngine.getInstance().getClock();
        for (Pair<CargoAPI.CargoItemType, String> pair : this.data.keySet()) {
            List<PlayerMarketTransaction.TransactionLineItem> list = this.data.get(pair);
            Iterator<PlayerMarketTransaction.TransactionLineItem> iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                PlayerMarketTransaction.TransactionLineItem transactionLineItem = iterator.next();
                float f3 = campaignClock.getElapsedDaysSince(transactionLineItem.getTimestamp());
                if (f3 > f2) {
                    iterator.remove();
                    continue;
                }
                if (++n2 <= 5) continue;
                iterator.remove();
                --n2;
            }
        }
        this.compress();
    }

    private void compress() {
        for (Pair<CargoAPI.CargoItemType, String> pair : this.data.keySet()) {
            List<PlayerMarketTransaction.TransactionLineItem> list = this.data.get(pair);
            Iterator<PlayerMarketTransaction.TransactionLineItem> iterator = list.iterator();
            PlayerMarketTransaction.TransactionLineItem transactionLineItem = null;
            while (iterator.hasNext()) {
                PlayerMarketTransaction.TransactionLineItem transactionLineItem2 = iterator.next();
                if (transactionLineItem != null && (int)transactionLineItem.getDemandPrice() == (int)transactionLineItem2.getDemandPrice() && (int)transactionLineItem.getDemandTariff() == (int)transactionLineItem2.getDemandTariff() && (int)(transactionLineItem.getPrice() / transactionLineItem.getQuantity()) == (int)(transactionLineItem2.getPrice() / transactionLineItem2.getQuantity()) && (int)(transactionLineItem.getTariff() / transactionLineItem.getQuantity()) == (int)(transactionLineItem2.getTariff() / transactionLineItem2.getQuantity())) {
                    transactionLineItem.setQuantity(transactionLineItem.getQuantity() + transactionLineItem2.getQuantity());
                    transactionLineItem.setPrice(transactionLineItem.getPrice() + transactionLineItem2.getPrice());
                    transactionLineItem.setTariff(transactionLineItem.getTariff() + transactionLineItem2.getTariff());
                    iterator.remove();
                    continue;
                }
                transactionLineItem = transactionLineItem2;
            }
        }
    }

    public void addItem(PlayerMarketTransaction.TransactionLineItem transactionLineItem) {
        List<PlayerMarketTransaction.TransactionLineItem> list = this.getList(transactionLineItem.getCargoType(), transactionLineItem.getId());
        list.add(0, transactionLineItem);
    }

    public List<PlayerMarketTransaction.TransactionLineItem> getList(CargoAPI.CargoItemType cargoItemType, String string) {
        Pair pair = new Pair();
        pair.one = cargoItemType;
        pair.two = string;
        List<PlayerMarketTransaction.TransactionLineItem> list = this.data.get(pair);
        if (list == null) {
            list = new ArrayList<PlayerMarketTransaction.TransactionLineItem>();
            this.data.put((Pair<CargoAPI.CargoItemType, String>)pair, list);
        }
        return list;
    }
}

