/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.CoreLifecyclePluginImpl;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask2;
import com.fs.starfarer.campaign.econ.reach.ReachEconomy;
import com.fs.starfarer.campaign.econ.reach.ReachEconomyStepper;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Economy
implements DoNotObfuscate,
EconomyAPI {
    public static float ECONOMY_INTERVAL_IN_GAME_DAYS = StarfarerSettings.\u00f500000("economyIntervalnGameDays");
    public static final int NUM_ITER_PER_MONTH = (int)StarfarerSettings.\u00f500000("economyIterPerMonth");
    public static int MIN_DEMAND_FOR_PRICING = (int)StarfarerSettings.\u00f500000("economyMinDemandForPricing");
    public static int MIN_STOCKPILE_FOR_PRICING = (int)StarfarerSettings.\u00f500000("economyMinStockpileForPricing");
    public static float ECONOMY_GREED_FRACTION = StarfarerSettings.\u00f500000("economyGreedFraction");
    public static float ECONOMY_NO_DEMAND_PRICE_MULT = StarfarerSettings.\u00f500000("economyNoDemandPriceMult");
    public static float UNITS_PER_LY = StarfarerSettings.\u00f500000("unitsPerLightYear");
    public static float ACCESS_BASE = StarfarerSettings.\u00f500000("accessibilityBaseValue");
    public static float ACCESS_NO_SPACEPORT = StarfarerSettings.\u00f500000("accessibilityNoSpaceport");
    public static float RANGE_FOR_MAX_EXOTIC_DEMAND = StarfarerSettings.\u00f500000("rangeForMaxExoticDemand");
    public static float EXOTIC_UTILITY_MULT = StarfarerSettings.\u00f500000("exoticUtilityMultAtMaxRange");
    public static float DEFICIT_PRICE_INCR_PER_UNIT = StarfarerSettings.\u00f500000("economyDeficitPriceIncrPerUnit");
    public static float DEFICIT_PRICE_MULT_MAX = StarfarerSettings.\u00f500000("economyDeficitPriceMultMax");
    public static float EXCESS_PRICE_DECR_PER_UNIT = StarfarerSettings.\u00f500000("economyExcessPriceDecrPerUnit");
    public static float EXCESS_PRICE_MULT_MIN = StarfarerSettings.\u00f500000("economyExcessPriceMultMin");
    public static boolean DEBUG = true;
    private float maxExoticDemandAtRange = 1.0f;
    private ReachEconomyStepper stepper;
    private ReachEconomy econ = new ReachEconomy();
    private boolean simMode;
    private boolean skipMarketAdvance = false;
    private List<EconomyAPI.EconomyUpdateListener> listeners;

    public Economy(boolean bl) {
        this.simMode = bl;
        this.stepper = new ReachEconomyStepper(this.econ);
    }

    Object readResolve() {
        return this;
    }

    Object writeReplace() {
        return this;
    }

    public boolean isSimMode() {
        return this.simMode;
    }

    public void setSimMode(boolean bl) {
        this.simMode = bl;
    }

    public List<MarketAPI> getMarkets(LocationAPI locationAPI) {
        return this.econ.getMarkets(locationAPI);
    }

    public List<LocationAPI> getLocationsWithMarkets() {
        return this.econ.getLocationsWithMarkets();
    }

    public List<StarSystemAPI> getStarSystemsWithMarkets() {
        return this.econ.getStarSystemsWithMarkets();
    }

    public void addMarket(MarketAPI marketAPI, boolean bl) {
        this.econ.addMarket(marketAPI);
        if (bl) {
            CoreLifecyclePluginImpl.addJunk((MarketAPI)marketAPI);
            float f2 = 300.0f + (float)marketAPI.getSize() * 200.0f;
            marketAPI.getContainingLocation().addRadioChatter(marketAPI.getPrimaryEntity(), f2);
        }
    }

    public void removeMarket(MarketAPI marketAPI) {
        this.econ.removeMarket(marketAPI);
    }

    public MarketAPI getMarket(String string) {
        return this.econ.getIdToMarket().get(string);
    }

    public ReachEconomyStepper getStepper() {
        return this.stepper;
    }

    public void advance(float f2) {
        DEBUG = false;
        this.econ.setLocationCacheNeedsUpdate(true);
        this.econ.updateLocationMap();
        if (StarfarerSettings.String("economyEnabled")) {
            float f3 = CampaignEngine.getInstance().getClock().convertToDays(f2);
            this.stepper.nextFrame(f3);
        }
        if (!this.skipMarketAdvance) {
            for (MarketAPI marketAPI : this.getMarketsCopy()) {
                marketAPI.advance(f2);
            }
        }
    }

    public void advanceMarketConditionsWhenPaused(float f2) {
        if (!this.skipMarketAdvance) {
            for (MarketAPI marketAPI : this.getMarketsCopy()) {
                for (MarketConditionAPI marketConditionAPI : new ArrayList(marketAPI.getConditions())) {
                    if (!marketConditionAPI.getPlugin().runWhilePaused()) continue;
                    marketConditionAPI.getPlugin().advance(f2);
                }
            }
        }
    }

    public void updateAllPrices() {
        Profiler.\u00d200000((String)"Updating prices");
        for (MarketAPI marketAPI : this.econ.getMarkets()) {
            marketAPI.updatePrices();
        }
        Profiler.o00000();
    }

    public void updatePriceMult(MarketAPI marketAPI) {
    }

    public List<MarketAPI> getMarkets() {
        return this.econ.getMarkets();
    }

    public List<String> getAllCommodityIds() {
        ArrayList<String> arrayList = new ArrayList<String>(SpecStore.String(F.class));
        return new ArrayList<String>(arrayList);
    }

    public CommoditySpecAPI getCommoditySpec(String string) {
        return SpecStore.super(F.class, string);
    }

    public List<MarketAPI> getMarketsCopy() {
        return new ArrayList<MarketAPI>(this.getMarkets());
    }

    public int getNumMarkets() {
        return this.getMarkets().size();
    }

    public float getMaxExoticDemandAtRange() {
        return this.maxExoticDemandAtRange;
    }

    public void setMaxExoticUtilityAtRange(float f2) {
        this.maxExoticDemandAtRange = f2;
    }

    public ReachEconomy getEconomy() {
        return this.econ;
    }

    public void setEcon(ReachEconomy reachEconomy) {
        this.econ = reachEconomy;
    }

    public void tripleStep() {
        this.nextStep();
        this.nextStep();
        this.nextStep();
    }

    public void doubleStep() {
        this.nextStep();
        this.nextStep();
    }

    public void nextStep() {
        this.nextStep(null);
    }

    /*
     * WARNING - void declaration
     */
    public void nextStep(MainWorkTask.EconWorkParams econWorkParams) {
        void var2_6;
        for (MarketAPI econWorkParams22 : this.getMarkets()) {
            ((Market)econWorkParams22).updatePrevStability();
        }
        MainWorkTask.EconWorkParams econWorkParams2 = new MainWorkTask.EconWorkParams();
        econWorkParams2.withIncomeAndUpkeep = false;
        econWorkParams2.withStockpileUpdate = true;
        econWorkParams2.withImmigration = true;
        if (econWorkParams != null) {
            MainWorkTask.EconWorkParams econWorkParams3 = econWorkParams;
        }
        this.econ.nextStep((MainWorkTask.EconWorkParams)var2_6);
    }

    public void addUpdateListener(EconomyAPI.EconomyUpdateListener economyUpdateListener) {
        this.getUpdateListeners().add(economyUpdateListener);
    }

    public void removeUpdateListener(EconomyAPI.EconomyUpdateListener economyUpdateListener) {
        this.getUpdateListeners().remove(economyUpdateListener);
    }

    public List<EconomyAPI.EconomyUpdateListener> getUpdateListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EconomyAPI.EconomyUpdateListener>();
        }
        return this.listeners;
    }

    public void forceStockpileUpdate(MarketAPI marketAPI) {
        for (CommodityOnMarketAPI commodityOnMarketAPI : marketAPI.getAllCommodities()) {
            if (commodityOnMarketAPI.isNonEcon()) continue;
            MainWorkTask2.updateStockpileAndPrice((Market)marketAPI, (F)commodityOnMarketAPI.getCommodity());
        }
    }

    public List<MarketAPI> getMarketsInGroup(String string) {
        return this.econ.getMarketsInGroup(string);
    }

    public List<MarketAPI> getMarketsWithSameGroup(MarketAPI marketAPI) {
        return this.econ.getMarketsWithSameGroup(marketAPI);
    }

    public List<MarketAPI> getMarketsWithSameGroup(MarketAPI marketAPI, List<MarketAPI> list) {
        return this.econ.getMarketsWithSameGroup(marketAPI, list);
    }
}

