/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.events;

import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.events.EventProbabilityAPI;
import com.fs.starfarer.campaign.BaseLocation;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.events.EventProbability;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.OO0oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import com.fs.util.container.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignEventManager
implements DoNotObfuscate,
CampaignEventManagerAPI {
    public static float EVENT_CHECK_PERIOD = StarfarerSettings.\u00f500000("eventCheckInterval");
    private Map<Pair<String, CampaignEventTarget>, EventProbability> eventProbabilities = new HashMap<Pair<String, CampaignEventTarget>, EventProbability>();
    private List<CampaignEventPlugin> ongoingEvents = new ArrayList<CampaignEventPlugin>();
    private IntervalTracker tracker = new IntervalTracker(1.0f, 1.0f);
    private List<Pair<String, CampaignEventTarget>> keyList = new ArrayList<Pair<String, CampaignEventTarget>>();
    private int currIndex = 0;
    private List<Pair<String, CampaignEventTarget>> keyListForWarnings = new ArrayList<Pair<String, CampaignEventTarget>>();
    private int currIndexForWarning = 0;
    private boolean checkWarning = true;

    Object readResolve() {
        if (this.keyListForWarnings == null) {
            this.keyListForWarnings = new ArrayList<Pair<String, CampaignEventTarget>>();
        }
        return this;
    }

    public EventProbabilityAPI getProbability(String string, LocationAPI locationAPI) {
        CampaignEventTarget campaignEventTarget = new CampaignEventTarget(locationAPI);
        return this.getProbability(string, campaignEventTarget);
    }

    public EventProbabilityAPI getProbability(String string, SectorEntityToken sectorEntityToken) {
        CampaignEventTarget campaignEventTarget = new CampaignEventTarget(sectorEntityToken);
        return this.getProbability(string, campaignEventTarget);
    }

    public EventProbabilityAPI getProbability(String string, Object object) {
        CampaignEventTarget campaignEventTarget = new CampaignEventTarget(object);
        return this.getProbability(string, campaignEventTarget);
    }

    public EventProbabilityAPI getProbability(String string, MarketAPI marketAPI) {
        CampaignEventTarget campaignEventTarget = new CampaignEventTarget(marketAPI.getPrimaryEntity());
        return this.getProbability(string, campaignEventTarget);
    }

    public EventProbabilityAPI getProbability(String string, CampaignEventTarget campaignEventTarget) {
        Pair pair = new Pair((Object)string, (Object)campaignEventTarget);
        EventProbability eventProbability = this.eventProbabilities.get(pair);
        if (eventProbability == null) {
            eventProbability = new EventProbability(string, campaignEventTarget);
            this.eventProbabilities.put((Pair<String, CampaignEventTarget>)pair, eventProbability);
        }
        return eventProbability;
    }

    public void advance(float f2) {
        if (CampaignEngine.getInstance().isPaused()) {
            return;
        }
        float f3 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        this.tracker.advance(f3);
        if (this.tracker.intervalElapsed()) {
            boolean bl = this.checkWarning = !this.checkWarning;
            if (this.checkWarning) {
                this.processNextWarning();
            } else {
                this.processNextEventCheck();
            }
            float f4 = EVENT_CHECK_PERIOD / Math.max(1.0f, (float)this.eventProbabilities.size() * 2.0f);
            this.tracker.setInterval(f4 * 0.5f, f4 * 1.5f);
        }
        ArrayList<CampaignEventPlugin> arrayList = new ArrayList<CampaignEventPlugin>();
        for (CampaignEventPlugin campaignEventPlugin : new ArrayList<CampaignEventPlugin>(this.ongoingEvents)) {
            campaignEventPlugin.advance(f2);
            if (!campaignEventPlugin.isDone()) continue;
            arrayList.add(campaignEventPlugin);
        }
        for (CampaignEventPlugin campaignEventPlugin : arrayList) {
            campaignEventPlugin.cleanup();
            this.ongoingEvents.remove(campaignEventPlugin);
        }
    }

    public void endEvent(CampaignEventPlugin campaignEventPlugin) {
        if (this.ongoingEvents.contains(campaignEventPlugin)) {
            campaignEventPlugin.cleanup();
            this.ongoingEvents.remove(campaignEventPlugin);
        } else {
            Pair pair = new Pair((Object)campaignEventPlugin.getEventType(), (Object)campaignEventPlugin.getEventTarget());
            campaignEventPlugin.cleanup();
            this.eventProbabilities.remove(pair);
        }
    }

    private void processNextEventCheck() {
        EventProbability eventProbability;
        ++this.currIndex;
        if (this.currIndex >= this.keyList.size()) {
            this.keyList = new ArrayList<Pair<String, CampaignEventTarget>>(this.eventProbabilities.keySet());
            Collections.shuffle(this.keyList);
            this.currIndex = 0;
        }
        if (!this.keyList.isEmpty() && (eventProbability = this.eventProbabilities.get(this.keyList.get(this.currIndex))) != null && !eventProbability.isPrimed()) {
            float f2 = eventProbability.getProbability();
            boolean bl = eventProbability.checkProbability();
            int n2 = SpecStore.super(OO0oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.class, eventProbability.getEventType()).getMaxOngoing();
            int n3 = this.getNumOngoing(eventProbability.getEventType());
            if (bl && !this.isOngoing(eventProbability) && (n2 < 0 || n2 > n3)) {
                CampaignEventPlugin campaignEventPlugin = eventProbability.getPlugin();
                this.ongoingEvents.add(campaignEventPlugin);
                campaignEventPlugin.setProbability(f2);
                campaignEventPlugin.startEvent();
                this.eventProbabilities.remove(this.keyList.get(this.currIndex));
            } else if (eventProbability.getProbability() <= 0.0f) {
                CampaignEventPlugin campaignEventPlugin = eventProbability.getPlugin();
                campaignEventPlugin.cleanup();
                this.eventProbabilities.remove(this.keyList.get(this.currIndex));
            }
        }
    }

    public CampaignEventPlugin primeEvent(CampaignEventTarget campaignEventTarget, String string, Object object) {
        Object object2;
        if (campaignEventTarget == null) {
            object2 = new BaseLocation.LocationToken(null, (float)Math.random(), (float)Math.random());
            campaignEventTarget = new CampaignEventTarget((SectorEntityToken)object2);
            campaignEventTarget.setLocation((LocationAPI)CampaignEngine.getInstance().getHyperspace());
        }
        if (!(object2 = this.getProbability(string, campaignEventTarget)).getPlugin().allowMultipleOngoingForSameTarget() && this.isOngoing((EventProbabilityAPI)object2)) {
            return null;
        }
        if (object != null) {
            object2.getPlugin().setParam(object);
        }
        object2.setPrimed(true);
        return object2.getPlugin();
    }

    public void startEvent(CampaignEventPlugin campaignEventPlugin) {
        this.ongoingEvents.add(campaignEventPlugin);
        Pair pair = new Pair((Object)campaignEventPlugin.getEventType(), (Object)campaignEventPlugin.getEventTarget());
        this.eventProbabilities.remove(pair);
        campaignEventPlugin.setProbability(1.0f);
        campaignEventPlugin.startEvent();
    }

    public CampaignEventPlugin startEvent(CampaignEventTarget campaignEventTarget, String string, Object object) {
        Object object2;
        if (campaignEventTarget == null) {
            object2 = new BaseLocation.LocationToken(null, (float)Math.random(), (float)Math.random());
            campaignEventTarget = new CampaignEventTarget((SectorEntityToken)object2);
            campaignEventTarget.setLocation((LocationAPI)CampaignEngine.getInstance().getHyperspace());
        }
        if (!(object2 = this.getProbability(string, campaignEventTarget)).getPlugin().allowMultipleOngoingForSameTarget() && this.isOngoing((EventProbabilityAPI)object2)) {
            return null;
        }
        if (object != null) {
            object2.getPlugin().setParam(object);
        }
        this.ongoingEvents.add(object2.getPlugin());
        Pair pair = new Pair((Object)string, (Object)campaignEventTarget);
        this.eventProbabilities.remove(pair);
        object2.getPlugin().setProbability(1.0f);
        object2.getPlugin().startEvent();
        return object2.getPlugin();
    }

    public boolean isOngoing(EventProbabilityAPI eventProbabilityAPI) {
        return this.getOngoingEvent(eventProbabilityAPI.getEventTarget(), eventProbabilityAPI.getEventType()) != null;
    }

    public boolean isOngoing(CampaignEventTarget campaignEventTarget, String string) {
        return this.getOngoingEvent(campaignEventTarget, string) != null;
    }

    public CampaignEventPlugin getOngoingEvent(CampaignEventTarget campaignEventTarget, String string) {
        for (CampaignEventPlugin campaignEventPlugin : this.ongoingEvents) {
            if (campaignEventTarget != null && (campaignEventTarget == null || !campaignEventTarget.equals((Object)campaignEventPlugin.getEventTarget())) || !string.equals(campaignEventPlugin.getEventType())) continue;
            return campaignEventPlugin;
        }
        return null;
    }

    public List<CampaignEventPlugin> getOngoingEvents() {
        return this.ongoingEvents;
    }

    public int getNumOngoing(String string) {
        int n2 = 0;
        for (CampaignEventPlugin campaignEventPlugin : this.ongoingEvents) {
            if (!string.equals(campaignEventPlugin.getEventType())) continue;
            ++n2;
        }
        return n2;
    }

    private void processNextWarning() {
        EventProbability eventProbability;
        ++this.currIndexForWarning;
        if (this.currIndexForWarning >= this.keyListForWarnings.size()) {
            this.keyListForWarnings = new ArrayList<Pair<String, CampaignEventTarget>>(this.eventProbabilities.keySet());
            Collections.shuffle(this.keyListForWarnings);
            this.currIndexForWarning = 0;
        }
        if (!this.keyListForWarnings.isEmpty() && (eventProbability = this.eventProbabilities.get(this.keyListForWarnings.get(this.currIndexForWarning))) != null && !this.isOngoing(eventProbability)) {
            float f2 = eventProbability.getProbability();
            if (f2 >= 1.0f) {
                String string = eventProbability.getPlugin().getStageIdForLikely();
                CampaignEngine.getInstance().reportEventStage(eventProbability.getPlugin(), string, eventProbability.getPlugin().getWarningWhenLikelyPriority());
            } else if (f2 > 0.25f) {
                String string = eventProbability.getPlugin().getStageIdForPossible();
                CampaignEngine.getInstance().reportEventStage(eventProbability.getPlugin(), string, eventProbability.getPlugin().getWarningWhenPossiblePriority());
            }
        }
    }
}

