/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.graphics.LayeredRenderable;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.combat.CombatViewport;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleetAbilityRenderer
implements LayeredRenderable<CampaignEngineLayers, CombatViewport> {
    private CampaignFleet fleet;
    private EnumSet<CampaignEngineLayers> layers = null;

    public FleetAbilityRenderer(CampaignFleet campaignFleet) {
        this.fleet = campaignFleet;
    }

    public void updateLayers() {
        HashSet hashSet = new HashSet();
        EnumSet<CampaignEngineLayers> enumSet = this.layers;
        Iterator<AbilityPlugin> iterator = this.fleet.getAbilities().values().iterator();
        while (iterator.hasNext()) {
            AbilityPlugin abilityPlugin = iterator.next();
            EnumSet enumSet2 = abilityPlugin.getActiveLayers();
            if (enumSet2 == null) continue;
            hashSet.addAll(enumSet2);
        }
        this.layers = hashSet.isEmpty() ? null : EnumSet.copyOf(hashSet);
        boolean bl = this.layers == null && enumSet != null;
        bl |= this.layers != null && enumSet == null;
        if ((bl |= enumSet != null && !enumSet.equals(this.layers)) && (iterator = this.fleet.getContainingLocation().getRenderer()) != null) {
            iterator.recompile(this);
        }
    }

    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        for (AbilityPlugin abilityPlugin : this.fleet.getAbilities().values()) {
            EnumSet enumSet = abilityPlugin.getActiveLayers();
            if (enumSet == null || !enumSet.contains(campaignEngineLayers)) continue;
            abilityPlugin.render(campaignEngineLayers, (ViewportAPI)combatViewport);
        }
    }
}

