/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.campaign.WarpingSpriteRenderer;
import com.fs.starfarer.combat.R;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.ReplaceableSprite;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class BackgroundAndStars
implements DoNotObfuscate,
ReplaceableSprite.SpriteUpdateDelegate {
    private transient R starfield;
    private transient R starfield2;
    private transient R starfield3;
    private Vector2f bgOffset = new Vector2f();
    private ReplaceableSprite sprite;
    private boolean hyperspaceMode = false;
    private WarpingSpriteRenderer warpngRenderer = null;

    public BackgroundAndStars(boolean bl) {
        this.hyperspaceMode = bl;
        if (bl) {
            this.warpngRenderer = new WarpingSpriteRenderer(16, 16);
            this.sprite = new ReplaceableSprite(StarfarerSettings.\u00d200000("backgrounds", "defaultHyperBackground"), this);
        } else {
            this.sprite = new ReplaceableSprite(StarfarerSettings.\u00d200000("backgrounds", "defaultSpaceBackground"), this);
        }
        this.readResolve();
    }

    Object readResolve() {
        float f2 = StarfarerSettings.\u00f8\u00d20000();
        float f3 = StarfarerSettings.void.new();
        this.starfield = new R(0.0f, 0.0f, f2, f3, 0.25f);
        this.starfield2 = new R(0.0f, 0.0f, f2, f3, 0.25f);
        this.starfield3 = new R(0.0f, 0.0f, f2, f3, 0.25f);
        if (this.hyperspaceMode && this.warpngRenderer == null) {
            this.warpngRenderer = new WarpingSpriteRenderer(16, 16);
        }
        this.spriteUpdated();
        return this;
    }

    public void advance(float f2) {
        if (this.warpngRenderer != null) {
            this.warpngRenderer.advance(f2);
        }
    }

    public void updateStarfield(float f2, float f3, float f4, float f5) {
        this.starfield.o00000(f2, f3, f4, f5);
        this.starfield2.o00000(f2 / 2.0f, f3 / 2.0f, f4, f5);
        this.starfield3.o00000(f2 / 4.0f, f3 / 4.0f, f4, f5);
    }

    public void renderBG(float f2, float f3) {
        this.renderBG(f2, f3, 1.0f);
    }

    public void renderBG(float f2, float f3, float f4) {
        boolean bl;
        this.sprite.update();
        boolean bl2 = bl = f4 < 1.0f;
        if (bl) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        this.sprite.getSprite().setAlphaMult(f4);
        if (this.warpngRenderer != null) {
            this.warpngRenderer.renderNoBlendOrRotate(this.sprite.getSprite(), f2 - this.bgOffset.x, f3 - this.bgOffset.y, !bl);
        } else {
            this.sprite.getSprite().renderNoBlendOrRotate(f2 - this.bgOffset.x, f3 - this.bgOffset.y, !bl);
        }
    }

    public void renderStarfield(float f2, float f3) {
        this.starfield.o00000(0.0f, 0.0f);
        this.starfield2.o00000(f2 / 2.0f, f3 / 2.0f);
        this.starfield3.o00000(f2 * 0.75f, f3 * 0.75f);
    }

    public void setDefaultBackground() {
        if (this.hyperspaceMode) {
            this.replaceBackground(StarfarerSettings.\u00d200000("backgrounds", "defaultHyperBackground"));
        } else {
            this.replaceBackground(StarfarerSettings.\u00d200000("backgrounds", "defaultSpaceBackground"));
        }
    }

    public void replaceBackground(String string) {
        if (string == null) {
            string = this.hyperspaceMode ? StarfarerSettings.\u00d200000("backgrounds", "defaultHyperBackground") : StarfarerSettings.\u00d200000("backgrounds", "defaultSpaceBackground");
        }
        this.sprite.replaceTexture(string);
    }

    public void spriteUpdated() {
        float f2 = StarfarerSettings.\u00f8\u00d20000();
        float f3 = StarfarerSettings.void.new();
        float f4 = StarfarerSettings.\u00d4\u00d60000;
        this.sprite.getSprite().setSize(this.sprite.getSprite().getWidth() / f4, this.sprite.getSprite().getHeight() / f4);
        float f5 = this.sprite.getSprite().getWidth();
        float f6 = this.sprite.getSprite().getHeight();
        if (f2 > f5) {
            this.sprite.getSprite().setWidth(f2);
            this.sprite.getSprite().setHeight(f6 * f2 / f5);
        }
        f5 = this.sprite.getSprite().getWidth();
        f6 = this.sprite.getSprite().getHeight();
        if (f3 > f6) {
            this.sprite.getSprite().setHeight(f3);
            this.sprite.getSprite().setWidth(f5 * f3 / f6);
        }
        this.bgOffset.x = (float)Math.random() * (this.sprite.getSprite().getWidth() - f2);
        this.bgOffset.y = (float)Math.random() * (this.sprite.getSprite().getHeight() - f3);
    }

    public ReplaceableSprite getSprite() {
        return this.sprite;
    }

    public void setBackgroundOffset(float f2, float f3) {
        this.bgOffset.x = f2;
        this.bgOffset.y = f3;
    }
}

