/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.Sprite;
import com.fs.graphics.util.Fader;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.InteractionDialogImageVisual;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityPlugin;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BaseLocation;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.CampaignPlanet;
import com.fs.starfarer.campaign.CircularOrbit;
import com.fs.starfarer.campaign.CircularOrbitPointDown;
import com.fs.starfarer.campaign.CircularOrbitWithSpin;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.SensorContactIndicatorManager;
import com.fs.starfarer.campaign.StarSystem;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.PlanetConditionMarket;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CampaignFloatingText;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.campaign.ui.oOO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.campaign.util.A;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.rpg.Person;
import com.fs.starfarer.settings.StarfarerSettings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCampaignEntity
implements CampaignEntity {
    private Vector2f loc = new Vector2f();
    private Vector2f vel = new Vector2f();
    private transient String name;
    private transient boolean expired = false;
    private transient Color lightColor;
    private transient String customDescriptionId = null;
    private transient String id;
    private transient boolean tOn = false;
    protected transient float facing = 0.0f;
    private transient boolean freeTransfer = false;
    private String j0 = null;
    private Faction owner = Faction.NO_FACTION;
    private OrbitAPI orbit;
    private BaseLocation containingLocation;
    protected SectorEntityToken lightSource;
    private transient A indicator;
    private transient oOO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO selectionIndicator;
    private Memory memory = null;
    private MarketAPI market;
    private List<EveryFrameScript> scripts = new ArrayList<EveryFrameScript>();
    private Person activePerson = null;
    private List<CampaignFloatingText> floatingText = null;
    private Map<String, AbilityPlugin> abilities = null;
    private Map<String, Object> customData = null;
    private SensorContactIndicatorManager scim;
    private Boolean discoverable = null;
    private Float discoveryXP = null;
    private Float salvageXP = null;
    private List<SalvageEntityGenDataSpec.DropData> dropValue = null;
    private List<SalvageEntityGenDataSpec.DropData> dropRandom = null;
    private Fader sensorFader = new Fader(1.0f, 0.2f, 0.2f);
    private Fader sensorContactFader = new Fader(0.0f, 0.2f, 0.2f);
    private InteractionDialogImageVisual customVisual = null;
    private HashSet<String> tags = null;
    private transient String autogenJumpPointNameInSystem = null;
    private transient String autogenJumpPointNameInHyper = null;
    private transient boolean skipForJumpPointAutoGen = false;
    private Boolean alwaysUseSensorFaderBrightness = null;
    private Float sensorStrength = null;
    private Float sensorProfile = null;
    private StatBonus detectedRangeMod = new StatBonus();
    private StatBonus sensorRangeMod = new StatBonus();
    private Float detectionRangeDetailsOverrideMult = null;

    public List<EveryFrameScript> getScripts() {
        return this.scripts;
    }

    public BaseCampaignEntity(String string) {
        this.id = string == null ? Misc.genUID() : string;
        this.indicator = new A(this);
        this.selectionIndicator = new oOO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO(this);
    }

    public List<SalvageEntityGenDataSpec.DropData> getDropValue() {
        if (this.dropValue == null) {
            return new ArrayList<SalvageEntityGenDataSpec.DropData>();
        }
        return this.dropValue;
    }

    public List<SalvageEntityGenDataSpec.DropData> getDropRandom() {
        if (this.dropRandom == null) {
            return new ArrayList<SalvageEntityGenDataSpec.DropData>();
        }
        return this.dropRandom;
    }

    public void addDropValue(SalvageEntityGenDataSpec.DropData dropData) {
        if (this.dropValue == null) {
            this.dropValue = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        }
        this.dropValue.add(dropData);
    }

    public void addDropValue(String string, int n2) {
        SalvageEntityGenDataSpec.DropData dropData = new SalvageEntityGenDataSpec.DropData();
        dropData.group = string;
        dropData.value = n2;
        dropData.chances = -1;
        this.addDropValue(dropData);
    }

    public void addDropRandom(String string, int n2) {
        this.addDropRandom(string, n2, -1);
    }

    public void addDropRandom(SalvageEntityGenDataSpec.DropData dropData) {
        if (this.dropRandom == null) {
            this.dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        }
        this.dropRandom.add(dropData);
    }

    public void addDropRandom(String string, int n2, int n3) {
        SalvageEntityGenDataSpec.DropData dropData = new SalvageEntityGenDataSpec.DropData();
        dropData.group = string;
        dropData.value = n3;
        dropData.chances = n2;
        this.addDropRandom(dropData);
    }

    public CustomCampaignEntityPlugin getCustomPlugin() {
        return null;
    }

    public CustomEntitySpecAPI getCustomEntitySpec() {
        return null;
    }

    public boolean isDiscoverable() {
        return this.discoverable != null && this.discoverable != false;
    }

    public void setDiscoverable(Boolean bl) {
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.discoverable = bl;
    }

    public Float getDiscoveryXP() {
        if (this.discoveryXP == null) {
            return Float.valueOf(0.0f);
        }
        return this.discoveryXP;
    }

    public void setDiscoveryXP(Float f2) {
        this.discoveryXP = f2;
    }

    public Float getSalvageXP() {
        if (this.salvageXP == null) {
            return Float.valueOf(0.0f);
        }
        return this.salvageXP;
    }

    public void setSalvageXP(Float f2) {
        this.salvageXP = f2;
    }

    public boolean hasDiscoveryXP() {
        return this.discoveryXP != null;
    }

    public boolean hasSalvageXP() {
        return this.salvageXP != null;
    }

    public Color getIndicatorColor() {
        if (this.indicator == null) {
            return this.getFaction().getBaseUIColor();
        }
        return this.indicator.\u00d200000();
    }

    @Override
    public boolean isTransponderOn() {
        return this.tOn;
    }

    @Override
    public void setTransponderOn(boolean bl) {
        this.tOn = bl;
    }

    @Override
    public void addFloatingText(String string, Color color, float f2) {
        if (!this.isVisibleToPlayerFleet()) {
            return;
        }
        CampaignFloatingText campaignFloatingText = new CampaignFloatingText(this, string, color, f2);
        if (this.floatingText == null) {
            this.floatingText = new ArrayList<CampaignFloatingText>();
        }
        this.floatingText.add(campaignFloatingText);
    }

    public void addFloatingText(String string, Color color, float f2, boolean bl) {
        if (!this.isVisibleToPlayerFleet()) {
            return;
        }
        CampaignFloatingText campaignFloatingText = new CampaignFloatingText(this, string, color, f2);
        campaignFloatingText.setShowWhenContact(bl);
        if (this.floatingText == null) {
            this.floatingText = new ArrayList<CampaignFloatingText>();
        }
        this.floatingText.add(campaignFloatingText);
    }

    public List<CampaignFloatingText> getFloatingText() {
        return this.floatingText;
    }

    public void addAbility(String string) {
        if (this.abilities != null && this.abilities.containsKey(string)) {
            return;
        }
        if (this.abilities == null) {
            this.abilities = new LinkedHashMap<String, AbilityPlugin>();
        }
        com.fs.starfarer.loading.specs.A a2 = SpecStore.super(com.fs.starfarer.loading.specs.A.class, string);
        AbilityPlugin abilityPlugin = a2.getNewPluginInstance(this);
        this.abilities.put(string, abilityPlugin);
        if (abilityPlugin instanceof EveryFrameScript) {
            this.addScript((EveryFrameScript)abilityPlugin);
        }
    }

    public void removeAbility(String string) {
        if (this.abilities != null) {
            AbilityPlugin abilityPlugin = this.abilities.remove(string);
            if (abilityPlugin instanceof EveryFrameScript) {
                this.removeScript((EveryFrameScript)abilityPlugin);
            }
            if (abilityPlugin != null && abilityPlugin.isActiveOrInProgress()) {
                abilityPlugin.cleanup();
            }
            if (this.abilities.isEmpty()) {
                this.abilities = null;
            }
        }
    }

    public void clearAbilities() {
        for (String string : new ArrayList<String>(this.abilities.keySet())) {
            this.removeAbility(string);
        }
    }

    public void clearFloatingText() {
        this.getFloatingText().clear();
    }

    public AbilityPlugin getAbility(String string) {
        if (this.abilities == null) {
            return null;
        }
        return this.abilities.get(string);
    }

    public boolean hasAbility(String string) {
        if (this.abilities == null) {
            return false;
        }
        return this.abilities.containsKey(string);
    }

    public Map<String, AbilityPlugin> getAbilities() {
        if (this.abilities == null) {
            return new LinkedHashMap<String, AbilityPlugin>();
        }
        return this.abilities;
    }

    @Override
    public Fader getSensorFader() {
        if (this.sensorFader == null) {
            this.sensorFader = new Fader(1.0f, 0.2f, 0.2f);
            if (this.hasSensorProfile()) {
                this.sensorFader.forceOut();
            }
        }
        return this.sensorFader;
    }

    public void forceSensorFaderOut() {
        this.getSensorFader();
        if (this.sensorFader != null) {
            this.sensorFader.forceOut();
        }
    }

    @Override
    public Fader getSensorContactFader() {
        if (this.sensorContactFader == null) {
            this.sensorContactFader = !this.hasSensorProfile() ? new Fader(1.0f, 0.2f, 0.2f) : new Fader(0.0f, 0.2f, 0.2f);
        }
        return this.sensorContactFader;
    }

    public float getSensorFaderBrightness() {
        return this.getSensorFader().getBrightness();
    }

    public void forceSensorFaderBrightness(float f2) {
        this.getSensorFader().setBrightness(f2);
    }

    public void forceSensorContactFaderBrightness(float f2) {
        this.getSensorContactFader().setBrightness(f2);
    }

    public float getSensorContactFaderBrightness() {
        return this.getSensorContactFader().getBrightness();
    }

    @Override
    public boolean isRenderCircleIndicator() {
        return true;
    }

    @Override
    public boolean isRenderCircleIndicatorSelectionFlash() {
        return true;
    }

    public Person getActivePerson() {
        return this.activePerson;
    }

    public void setActivePerson(PersonAPI personAPI) {
        this.activePerson = (Person)personAPI;
    }

    public void setInteractionImage(String string, String string2) {
        String string3 = StarfarerSettings.\u00d200000(string, string2);
        Sprite sprite = new Sprite(string3);
        InteractionDialogImageVisual interactionDialogImageVisual = new InteractionDialogImageVisual(string3, sprite.getWidth(), sprite.getHeight());
        this.setCustomInteractionDialogImageVisual(interactionDialogImageVisual);
    }

    public boolean isPlayerFleet() {
        return false;
    }

    public void addScript(EveryFrameScript everyFrameScript) {
        if (everyFrameScript == null) {
            return;
        }
        this.scripts.add(everyFrameScript);
    }

    public boolean isInCurrentLocation() {
        return this.getContainingLocation() == CampaignEngine.getInstance().getCurrentLocation();
    }

    public void removeScript(EveryFrameScript everyFrameScript) {
        Iterator<EveryFrameScript> iterator = this.scripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript2 = iterator.next();
            if (everyFrameScript2 != everyFrameScript) continue;
            iterator.remove();
        }
    }

    public boolean hasScriptOfClass(Class clazz) {
        for (EveryFrameScript everyFrameScript : this.scripts) {
            if (everyFrameScript.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public void removeScriptsOfClass(Class clazz) {
        Iterator<EveryFrameScript> iterator = this.scripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript = iterator.next();
            if (everyFrameScript.getClass() != clazz) continue;
            iterator.remove();
        }
    }

    @Override
    public float getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(float f2) {
        this.facing = f2;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public A getIndicator() {
        return this.indicator;
    }

    public String getCustomDescriptionId() {
        return this.customDescriptionId;
    }

    public void setCustomDescriptionId(String string) {
        this.customDescriptionId = string;
    }

    public MemoryAPI getMemory() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        for (CampaignPlugin campaignPlugin : CampaignEngine.getInstance().getModAndPluginData().getPlugins()) {
            campaignPlugin.updateEntityFacts((SectorEntityToken)this, (MemoryAPI)this.memory);
        }
        return this.memory;
    }

    public void setMemory(MemoryAPI memoryAPI) {
        this.memory = (Memory)memoryAPI;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public Map<String, Object> getCustomData() {
        if (this.customData == null) {
            this.customData = new HashMap<String, Object>();
        }
        return this.customData;
    }

    protected Object readResolve() {
        com.fs.starfarer.loading.String.o00000((Object)this, BaseCampaignEntity.class, this.j0, new String[]{"name", "expired", "lightColor", "customDescriptionId", "id", "tOn", "facing", "freeTransfer"});
        this.indicator = new A(this);
        this.selectionIndicator = new oOO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO(this);
        if (this.abilities != null && !(this.abilities instanceof LinkedHashMap)) {
            this.abilities = new LinkedHashMap<String, AbilityPlugin>(this.abilities);
        }
        if (this.market instanceof PlanetConditionMarket) {
            PlanetConditionMarket planetConditionMarket = (PlanetConditionMarket)this.market;
            this.market = planetConditionMarket.convertToRegular();
            this.market.setPlanetConditionMarketOnly(true);
        }
        return this;
    }

    protected Object writeReplace() {
        if (this.name == null || "null".equals(this.name)) {
            this.name = "Null";
        }
        this.j0 = com.fs.starfarer.loading.String.o00000((Object)this, BaseCampaignEntity.class, new String[]{"name", "expired", "lightColor", "customDescriptionId", "id", "tOn", "facing", "freeTransfer"});
        if (this.market instanceof Market && this.market.isPlanetConditionMarketOnly() && !this.market.isForceNoConvertOnSave()) {
            Market market = (Market)this.market;
            this.market = market.convertToCondition();
        }
        if (this.sensorFader != null && (this.sensorFader.isFadedOut() || !this.hasSensorProfile())) {
            this.sensorFader = null;
        }
        if (this.sensorContactFader != null && (this.sensorContactFader.isFadedOut() || !this.hasSensorProfile())) {
            this.sensorContactFader = null;
        }
        if (this.customData != null && this.customData.isEmpty()) {
            this.customData = null;
        }
        if (this.detectedRangeMod != null && this.detectedRangeMod.isUnmodified()) {
            this.detectedRangeMod = null;
        }
        if (this.sensorRangeMod != null && this.sensorRangeMod.isUnmodified()) {
            this.sensorRangeMod = null;
        }
        if (this.scim != null && this.scim.isEmpty()) {
            this.scim = null;
        }
        if (this.dropValue != null && this.dropValue.isEmpty()) {
            this.dropValue = null;
        }
        if (this.dropRandom != null && this.dropRandom.isEmpty()) {
            this.dropRandom = null;
        }
        if (this.tags != null && this.tags.isEmpty()) {
            this.tags = null;
        }
        return this;
    }

    @Override
    public Vector2f getLocation() {
        return this.loc;
    }

    public void setLocation(float f2, float f3) {
        this.loc.set(f2, f3);
    }

    @Override
    public Vector2f getVelocity() {
        return this.vel;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void init() {
    }

    @Override
    public void advance(float f2) {
        if (!(this.getFaction() == null || this.getIndicator() == null || this.getFaction().isNeutralFaction() && !(this instanceof CampaignFleetAPI) || this instanceof CampaignPlanet)) {
            this.getIndicator().super(this.getFaction().getSpec().getColor(), this.getFaction().getSpec().getSecondaryUIColor(), this.getFaction().getSpec().getSecondarySegments());
        }
        this.getContactIndicator().advance(f2);
        this.selectionIndicator.\u00d200000(f2);
        this.getSensorFader().advance(f2);
        this.getSensorContactFader().advance(f2);
        if (this.memory != null) {
            this.memory.advance(f2);
        }
        if (this.market != null && this.market.isPlanetConditionMarketOnly()) {
            this.market.advance(f2);
        }
        if (this.floatingText != null) {
            Iterator<CampaignFloatingText> iterator = this.floatingText.iterator();
            while (iterator.hasNext()) {
                CampaignFloatingText campaignFloatingText = iterator.next();
                if (campaignFloatingText.isDone()) {
                    iterator.remove();
                    continue;
                }
                campaignFloatingText.advance(f2);
            }
            if (this.floatingText.isEmpty()) {
                this.floatingText = null;
            }
        }
        this.runScripts(f2);
    }

    @Override
    public void advanceEvenIfPaused(float f2) {
        if (Global.getSector().isPaused()) {
            this.runScripts(f2);
        }
        if (Global.getSector().isPaused() && this.isPlayerFleet() && this.floatingText != null) {
            Iterator<CampaignFloatingText> iterator = this.floatingText.iterator();
            while (iterator.hasNext()) {
                CampaignFloatingText campaignFloatingText = iterator.next();
                if (campaignFloatingText.isDone()) {
                    iterator.remove();
                    continue;
                }
                campaignFloatingText.advance(f2);
            }
            if (this.floatingText.isEmpty()) {
                this.floatingText = null;
            }
        }
    }

    private void runScripts(float f2) {
        ArrayList<EveryFrameScript> arrayList = new ArrayList<EveryFrameScript>(this.scripts);
        for (EveryFrameScript everyFrameScript : arrayList) {
            if (everyFrameScript.isDone()) {
                this.scripts.remove(everyFrameScript);
                continue;
            }
            if (!everyFrameScript.runWhilePaused() && CampaignEngine.getInstance().isPaused()) continue;
            everyFrameScript.advance(f2);
            if (!everyFrameScript.isDone()) continue;
            this.scripts.remove(everyFrameScript);
        }
    }

    @Override
    public SensorContactIndicatorManager getContactIndicator() {
        if (this.scim == null) {
            this.scim = new SensorContactIndicatorManager(this);
        }
        return this.scim;
    }

    @Override
    public oOO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO getSelectionIndicator() {
        return this.selectionIndicator;
    }

    @Override
    public Faction getFaction() {
        if (this.owner == null) {
            return Faction.NO_FACTION;
        }
        return this.owner;
    }

    public void setFaction(Faction faction) {
        this.owner = faction;
    }

    public void setFaction(String string) {
        this.owner = CampaignEngine.getInstance().getFaction(string);
    }

    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return null;
    }

    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public OrbitAPI getOrbit() {
        return this.orbit;
    }

    public float getCircularOrbitRadius() {
        if (this.orbit instanceof CircularOrbit) {
            return ((CircularOrbit)this.orbit).getRadius();
        }
        if (this.orbit instanceof CircularOrbitPointDown) {
            return ((CircularOrbitPointDown)this.orbit).getRadius();
        }
        if (this.orbit instanceof CircularOrbitWithSpin) {
            return ((CircularOrbitWithSpin)this.orbit).getRadius();
        }
        return 0.0f;
    }

    public float getCircularOrbitPeriod() {
        if (this.orbit instanceof CircularOrbit) {
            return ((CircularOrbit)this.orbit).getOrbitalPeriod();
        }
        if (this.orbit instanceof CircularOrbitPointDown) {
            return ((CircularOrbitPointDown)this.orbit).getOrbitalPeriod();
        }
        if (this.orbit instanceof CircularOrbitWithSpin) {
            return ((CircularOrbitWithSpin)this.orbit).getOrbitalPeriod();
        }
        return 0.0f;
    }

    public float getCircularOrbitAngle() {
        if (this.orbit instanceof CircularOrbit) {
            return ((CircularOrbit)this.orbit).getCurrAngle();
        }
        if (this.orbit instanceof CircularOrbitPointDown) {
            return ((CircularOrbitPointDown)this.orbit).getCurrAngle();
        }
        if (this.orbit instanceof CircularOrbitWithSpin) {
            return ((CircularOrbitWithSpin)this.orbit).getCurrAngle();
        }
        return 0.0f;
    }

    public void setCircularOrbitAngle(float f2) {
        if (this.orbit instanceof CircularOrbit) {
            ((CircularOrbit)this.orbit).setCurrAngle(f2);
        }
        if (this.orbit instanceof CircularOrbitPointDown) {
            ((CircularOrbitPointDown)this.orbit).setCurrAngle(f2);
        }
        if (this.orbit instanceof CircularOrbitWithSpin) {
            ((CircularOrbitWithSpin)this.orbit).setCurrAngle(f2);
        }
    }

    public SectorEntityToken getOrbitFocus() {
        if (this.orbit == null) {
            return null;
        }
        return this.orbit.getFocus();
    }

    @Override
    public void setOrbit(OrbitAPI orbitAPI) {
        this.orbit = orbitAPI;
        if (orbitAPI != null) {
            this.orbit.setEntity((SectorEntityToken)this);
            orbitAPI.advance(0.0f);
        }
    }

    public CargoAPI getCargo() {
        return null;
    }

    @Override
    public void setContainingLocation(LocationAPI locationAPI) {
        this.containingLocation = (BaseLocation)locationAPI;
    }

    public BaseLocation getContainingLocation() {
        return this.containingLocation;
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean bl) {
        this.expired = bl;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.getFaction() == null) {
            return this.getName();
        }
        if (this.getName().startsWith("Hidden")) {
            return "Hidden " + Misc.ucFirst((String)this.getFaction().getDisplayName()) + " " + this.getName().replaceFirst("Hidden ", "");
        }
        if (this.getFaction().isNeutralFaction()) {
            return this.getName();
        }
        if (this.getFaction().getEntityNamePrefix().isEmpty()) {
            return this.getName();
        }
        return String.valueOf(this.getFaction().getEntityNamePrefix()) + " " + this.getName();
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setLightSource(SectorEntityToken sectorEntityToken, Color color) {
        this.lightSource = sectorEntityToken;
        this.lightColor = color;
    }

    public SectorEntityToken getLightSource() {
        return this.lightSource;
    }

    public Color getLightColor() {
        return this.lightColor;
    }

    @Override
    public void setLightSource(SectorEntityToken sectorEntityToken) {
        this.lightSource = sectorEntityToken;
    }

    @Override
    public void setLightColor(Color color) {
        this.lightColor = color;
    }

    @Override
    public abstract float getRadius();

    public boolean isVisible() {
        return this.isVisible(100.0f);
    }

    public boolean isVisible(float f2) {
        return this.getContainingLocation() == CampaignEngine.getInstance().getCurrentLocation() && CampaignEngine.getInstance().getViewport().isNearViewport(this.getLocation(), this.getRadius() + f2);
    }

    public void setCustomInteractionDialogImageVisual(InteractionDialogImageVisual interactionDialogImageVisual) {
        this.customVisual = interactionDialogImageVisual;
    }

    public InteractionDialogImageVisual getCustomInteractionDialogImageVisual() {
        return this.customVisual;
    }

    public void setFreeTransfer(boolean bl) {
        this.freeTransfer = bl;
    }

    public boolean isFreeTransfer() {
        return this.freeTransfer;
    }

    public boolean hasTag(String string) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(string);
    }

    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        this.tags.add(string);
    }

    public void removeTag(String string) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(string);
        if (this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    public Collection<String> getTags() {
        if (this.tags == null) {
            return new ArrayList<String>();
        }
        return this.tags;
    }

    public void clearTags() {
        if (this.tags != null) {
            this.tags.clear();
        }
        this.tags = null;
    }

    public void setFixedLocation(float f2, float f3) {
        this.setOrbit(null);
        this.getLocation().set(f2, f3);
    }

    public void setCircularOrbit(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
        this.setOrbit(new CircularOrbit(this, sectorEntityToken, f3).setPeriod(f4).setCurrAngle(f2));
    }

    public void setCircularOrbitPointingDown(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
        this.setOrbit(new CircularOrbitPointDown(this, sectorEntityToken, f3).setPeriod(f4).setCurrAngle(f2));
    }

    public void setCircularOrbitWithSpin(SectorEntityToken sectorEntityToken, float f2, float f3, float f4, float f5, float f6) {
        this.setOrbit(new CircularOrbitWithSpin(this, sectorEntityToken, f3, f2, f5, f6).setPeriod(f4));
    }

    public void convertMarketToNormal() {
        if (this.market instanceof PlanetConditionMarket) {
            PlanetConditionMarket planetConditionMarket = (PlanetConditionMarket)this.market;
            this.market = planetConditionMarket.convertToRegular();
        }
    }

    public MarketAPI getMarket() {
        if (this.market instanceof PlanetConditionMarket) {
            PlanetConditionMarket planetConditionMarket = (PlanetConditionMarket)this.market;
            this.market = planetConditionMarket.convertToRegular();
            this.market.setPlanetConditionMarketOnly(true);
        }
        return this.market;
    }

    public void setMarket(MarketAPI marketAPI) {
        this.market = marketAPI;
    }

    public Vector2f getLocationInHyperspace() {
        if (this.getContainingLocation() == null || this.getContainingLocation().isHyperspace()) {
            return this.getLocation();
        }
        return this.getContainingLocation().getLocation();
    }

    public boolean isInHyperspace() {
        if (this.getContainingLocation() == null) {
            return false;
        }
        return this.getContainingLocation().isHyperspaceMode();
    }

    public boolean isInOrNearSystem(StarSystemAPI starSystemAPI) {
        if (starSystemAPI == null) {
            return false;
        }
        float f2 = Global.getSettings().getFloat("commRelayRangeAroundSystem");
        float f3 = Misc.getDistanceLY((Vector2f)this.getLocationInHyperspace(), (Vector2f)starSystemAPI.getLocation());
        return !(f3 > f2);
    }

    public boolean isAlive() {
        return this.getContainingLocation() != null && this.getContainingLocation().getObjects().contains((Object)this);
    }

    public String getAutogenJumpPointNameInSystem() {
        return this.autogenJumpPointNameInSystem;
    }

    public void setAutogenJumpPointNameInSystem(String string) {
        this.autogenJumpPointNameInSystem = string;
    }

    public String getAutogenJumpPointNameInHyper() {
        return this.autogenJumpPointNameInHyper;
    }

    public void setAutogenJumpPointNameInHyper(String string) {
        this.autogenJumpPointNameInHyper = string;
    }

    public boolean isSkipForJumpPointAutoGen() {
        return this.skipForJumpPointAutoGen;
    }

    public void setSkipForJumpPointAutoGen(boolean bl) {
        this.skipForJumpPointAutoGen = bl;
    }

    public String getCustomEntityType() {
        return null;
    }

    public float getSensorStrength() {
        if (this.sensorStrength == null) {
            return 0.0f;
        }
        return this.sensorStrength.floatValue();
    }

    public void setSensorStrength(Float f2) {
        this.sensorStrength = f2;
    }

    public float getSensorProfile() {
        if (this.sensorProfile == null) {
            return 0.0f;
        }
        return this.sensorProfile.floatValue();
    }

    public void setSensorProfile(Float f2) {
        this.sensorProfile = f2;
    }

    public boolean hasSensorStrength() {
        return this.sensorStrength != null;
    }

    public boolean hasSensorProfile() {
        return this.sensorProfile != null;
    }

    public Boolean getAlwaysUseSensorFaderBrightness() {
        return this.alwaysUseSensorFaderBrightness;
    }

    public void setAlwaysUseSensorFaderBrightness(Boolean bl) {
        this.alwaysUseSensorFaderBrightness = bl;
    }

    public StatBonus getDetectedRangeMod() {
        if (this.detectedRangeMod == null) {
            this.detectedRangeMod = new StatBonus();
        }
        return this.detectedRangeMod;
    }

    public StatBonus getSensorRangeMod() {
        if (this.sensorRangeMod == null) {
            this.sensorRangeMod = new StatBonus();
        }
        return this.sensorRangeMod;
    }

    @Override
    public boolean isVisibleToPlayerFleet() {
        return this.isVisibleToPlayerFleet(true);
    }

    @Override
    public boolean isVisibleToPlayerFleet(boolean bl) {
        if (CampaignEngine.getInstance().getPlayerFleet() == null) {
            return false;
        }
        if (bl && this.getContainingLocation() != CampaignEngine.getInstance().getPlayerFleet().getContainingLocation()) {
            return false;
        }
        if (!StarfarerSettings.\u00d5o0000() && !this.hasTag("ghost")) {
            return true;
        }
        if (!this.hasSensorProfile()) {
            return true;
        }
        return this.isVisibleToSensorsOf(CampaignEngine.getInstance().getPlayerFleet());
    }

    @Override
    public boolean isVisibleToSensorsOf(SectorEntityToken sectorEntityToken) {
        float f2;
        if (sectorEntityToken == null) {
            return false;
        }
        if (!StarfarerSettings.\u00d5o0000() && sectorEntityToken.isPlayerFleet() && !this.hasTag("ghost")) {
            return true;
        }
        if (!this.hasSensorProfile()) {
            return true;
        }
        if (!sectorEntityToken.hasSensorStrength()) {
            return false;
        }
        if (sectorEntityToken.getContainingLocation() != this.getContainingLocation()) {
            return false;
        }
        float f3 = Utils.\u00d800000(this.getLocation(), sectorEntityToken.getLocation());
        if ((f3 -= this.getRadius() + sectorEntityToken.getRadius()) < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > (f2 = StarfarerSettings.super(this.getContainingLocation()))) {
            return false;
        }
        float f4 = BaseCampaignEntity.getMaxSensorRangeToDetect(sectorEntityToken, this);
        return f3 <= f4;
    }

    public static float getMaxSensorRangeToDetect(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2) {
        float f2;
        float f3;
        float f4 = sectorEntityToken.getBaseSensorRangeToDetect(sectorEntityToken2.getSensorProfile());
        StatBonus statBonus = sectorEntityToken2.getDetectedRangeMod();
        StatBonus statBonus2 = sectorEntityToken.getSensorRangeMod();
        float f5 = statBonus.getFlatBonus();
        float f6 = statBonus.getPercentMod();
        float f7 = statBonus.getMult();
        float f8 = statBonus2.getFlatBonus();
        float f9 = statBonus2.getPercentMod();
        if ((f4 = (f4 + f4 * (f6 + f9) / 100.0f + (f5 + f8)) * (f7 * (f3 = statBonus2.getMult()))) < 0.0f) {
            f4 = 0.0f;
        }
        if (sectorEntityToken.isTransponderOn() && sectorEntityToken2.isTransponderOn()) {
            f4 *= StarfarerSettings.\u00d600000();
        }
        if (sectorEntityToken.isPlayerFleet() && Misc.isEasy()) {
            f4 += StarfarerSettings.super.Object();
        }
        if (f4 > (f2 = StarfarerSettings.super(sectorEntityToken.getContainingLocation()))) {
            return f2;
        }
        return f4;
    }

    public float getMaxSensorRangeToDetect(SectorEntityToken sectorEntityToken) {
        return BaseCampaignEntity.getMaxSensorRangeToDetect(this, sectorEntityToken);
    }

    public float getBaseSensorRangeToDetect(float f2) {
        return f2 + this.getSensorStrength();
    }

    public SectorEntityToken.VisibilityLevel getVisibilityLevelToPlayerFleet() {
        if (CampaignEngine.getInstance().getPlayerFleet() == null) {
            return SectorEntityToken.VisibilityLevel.NONE;
        }
        return this.getVisibilityLevelTo(CampaignEngine.getInstance().getPlayerFleet());
    }

    public SectorEntityToken.VisibilityLevel getVisibilityLevelOfPlayerFleet() {
        if (CampaignEngine.getInstance().getPlayerFleet() == null) {
            return SectorEntityToken.VisibilityLevel.NONE;
        }
        return CampaignEngine.getInstance().getPlayerFleet().getVisibilityLevelTo(this);
    }

    public SectorEntityToken.VisibilityLevel getVisibilityLevelTo(SectorEntityToken sectorEntityToken) {
        float f2;
        if (!StarfarerSettings.\u00d5o0000() && sectorEntityToken.isPlayerFleet() && !this.hasTag("ghost")) {
            return SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS;
        }
        if (!this.hasSensorProfile()) {
            return SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS;
        }
        if (!sectorEntityToken.hasSensorStrength()) {
            return SectorEntityToken.VisibilityLevel.NONE;
        }
        if (sectorEntityToken.getContainingLocation() != this.getContainingLocation()) {
            return SectorEntityToken.VisibilityLevel.NONE;
        }
        float f3 = Utils.\u00d800000(this.getLocation(), sectorEntityToken.getLocation());
        if ((f3 -= this.getRadius() + sectorEntityToken.getRadius()) < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > (f2 = StarfarerSettings.super(this.getContainingLocation()))) {
            return SectorEntityToken.VisibilityLevel.NONE;
        }
        float f4 = BaseCampaignEntity.getMaxSensorRangeToDetect(sectorEntityToken, this);
        float f5 = f4 * StarfarerSettings.\u00d6\u00d60000();
        float f6 = Math.max(f4 * StarfarerSettings.private(), StarfarerSettings.\u00f8O0000());
        boolean bl = this.isTransponderOn();
        boolean bl2 = false;
        if (!(this instanceof CampaignFleet)) {
            float f7 = StarfarerSettings.\u00f5\u00d40000();
            if (this.detectionRangeDetailsOverrideMult != null && (f7 = this.detectionRangeDetailsOverrideMult.floatValue()) < 0.0f) {
                bl2 = true;
            }
            if (f5 > (f6 = Math.max(f4 * f7, StarfarerSettings.\u00f8O0000()))) {
                f5 = f6;
            }
        }
        if (!bl2 && (bl && f3 <= f4 || f3 <= f6)) {
            return SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS;
        }
        if (f3 <= f5 && !bl2) {
            return SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS;
        }
        if (f3 <= f4) {
            return SectorEntityToken.VisibilityLevel.SENSOR_CONTACT;
        }
        return SectorEntityToken.VisibilityLevel.NONE;
    }

    public Float getDetectionRangeDetailsOverrideMult() {
        return this.detectionRangeDetailsOverrideMult;
    }

    public void setDetectionRangeDetailsOverrideMult(Float f2) {
        this.detectionRangeDetailsOverrideMult = f2;
    }

    public Constellation getConstellation() {
        if (this.getContainingLocation() == null) {
            return null;
        }
        return this.getContainingLocation().getConstellation();
    }

    public boolean isInConstellation() {
        if (this.getContainingLocation() == null) {
            return false;
        }
        return this.getContainingLocation().isInConstellation();
    }

    public static void main(String[] stringArray) {
        float f2 = 1200.0f;
        System.out.println("Strength: " + (int)f2);
        float f3 = 800.0f;
        while (f3 <= 2400.0f) {
            float f4 = Math.abs(f2 - f3);
            int n2 = (int)(f2 + f3);
            System.out.println(String.format("Prof: % 5d -> Range: % 5d", (int)f3, n2));
            f3 += 100.0f;
        }
    }

    public boolean isSystemCenter() {
        return this.getContainingLocation() instanceof StarSystemAPI && ((StarSystemAPI)this.getContainingLocation()).getCenter() == this;
    }

    public StarSystemAPI getStarSystem() {
        if (this.getContainingLocation() instanceof StarSystemAPI) {
            return (StarSystemAPI)this.getContainingLocation();
        }
        return null;
    }

    public void autoUpdateHyperLocationBasedOnInSystemEntityAtRadius(SectorEntityToken sectorEntityToken, float f2) {
        this.setOrbit(new StarSystem.UpdateFromSystemLocationOrbit(((StarSystemAPI)sectorEntityToken.getContainingLocation()).getHyperspaceAnchor(), ((StarSystemAPI)sectorEntityToken.getContainingLocation()).getCenter(), sectorEntityToken, this, f2));
    }
}

