/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.CommDirectoryAPI;
import com.fs.starfarer.api.campaign.CommDirectoryEntryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.campaign.CommDirectoryEntry;
import com.fs.starfarer.rpg.Person;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommDirectory
implements CommDirectoryAPI,
DoNotObfuscate {
    private List<CommDirectoryEntry> entries = new ArrayList<CommDirectoryEntry>();

    public CommDirectoryEntryAPI getEntryForPerson(PersonAPI personAPI) {
        return this.getEntryForPerson(personAPI.getId());
    }

    public CommDirectoryEntryAPI getEntryForPerson(String string) {
        for (CommDirectoryEntry commDirectoryEntry : this.entries) {
            PersonAPI personAPI;
            if (commDirectoryEntry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || !(commDirectoryEntry.getEntryData() instanceof PersonAPI) || !string.equals((personAPI = (PersonAPI)commDirectoryEntry.getEntryData()).getId())) continue;
            return commDirectoryEntry;
        }
        return null;
    }

    public String addPerson(PersonAPI personAPI) {
        return this.addPerson(personAPI, -1);
    }

    public String addPerson(PersonAPI personAPI, int n2) {
        for (CommDirectoryEntry object2 : this.entries) {
            if (object2.getEntryData() != personAPI) continue;
            return object2.getId();
        }
        Person person = (Person)personAPI;
        CommDirectoryEntry commDirectoryEntry = new CommDirectoryEntry(CommDirectoryEntryAPI.EntryType.PERSON, person);
        if (n2 < 0 || this.entries.isEmpty()) {
            this.entries.add(commDirectoryEntry);
        } else {
            this.entries.add(Math.min(n2, this.entries.size() - 1), commDirectoryEntry);
        }
        return commDirectoryEntry.getId();
    }

    public List<CommDirectoryEntry> getEntries() {
        return this.entries;
    }

    public List<CommDirectoryEntryAPI> getEntriesCopy() {
        return new ArrayList<CommDirectoryEntryAPI>(this.entries);
    }

    public void setEntries(List<CommDirectoryEntry> list) {
        this.entries = list;
    }

    public void removeEntry(CommDirectoryEntryAPI commDirectoryEntryAPI) {
        if (commDirectoryEntryAPI != null) {
            this.removeEntry(commDirectoryEntryAPI.getId());
        }
    }

    public void removeEntry(String string) {
        for (CommDirectoryEntry commDirectoryEntry : this.entries) {
            if (!commDirectoryEntry.getId().equals(string)) continue;
            this.entries.remove(commDirectoryEntry);
            break;
        }
    }

    public void removePerson(PersonAPI personAPI) {
        for (CommDirectoryEntry commDirectoryEntry : new ArrayList<CommDirectoryEntry>(this.entries)) {
            if (commDirectoryEntry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || commDirectoryEntry.getEntryData() != personAPI) continue;
            this.entries.remove(commDirectoryEntry);
        }
    }

    public void clear() {
        this.entries.clear();
    }
}

