/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.Sprite;
import com.fs.starfarer.api.InteractionDialogImageVisual;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityPlugin;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.BaseLocation;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.oooO;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.O;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCampaignEntity
extends BaseCampaignEntity
implements DoNotObfuscate,
CustomCampaignEntityAPI {
    private transient Sprite shadowMask;
    private transient Sprite sprite;
    private transient float width;
    private transient float height;
    private transient float radius;
    private transient int sheetCellX = -1;
    private transient int sheetCellY = -1;
    private transient String type;
    private String j1;
    private CargoData cargo = new CargoData(false);
    private EnumSet<CampaignEngineLayers> layers = null;
    private CampaignEngineLayers firstLayer = null;
    private CustomCampaignEntityPlugin plugin;
    private CampaignFleet fleetForVisual = null;
    private transient oooO spec = null;
    private transient boolean inConstructor = false;

    public CustomCampaignEntity(String string, String string2, String string3, String string4, float f2, float f3, float f4, CampaignEntity campaignEntity, Object object) {
        super(string);
        this.type = string3;
        if (string4 == null) {
            string4 = "neutral";
        }
        this.setFaction(CampaignEngine.getInstance().getFaction(string4));
        this.lightSource = campaignEntity;
        this.setFaction(CampaignEngine.getInstance().getFaction(string4));
        this.radius = f2;
        this.width = f3;
        this.height = f4;
        this.inConstructor = true;
        this.readResolve();
        this.inConstructor = false;
        if (f2 < 0.0f) {
            f2 = this.spec.getDefaultRadius();
        }
        this.radius = f2;
        this.plugin = this.spec.getPlugin();
        if (string2 == null) {
            string2 = this.spec.getDefaultName();
        }
        this.setName(string2);
        this.setCustomDescriptionId(this.spec.getCustomDescriptionId());
        if (this.spec.getInteractionImage() != null) {
            Sprite object2 = new Sprite(this.spec.getInteractionImage());
            InteractionDialogImageVisual interactionDialogImageVisual = new InteractionDialogImageVisual(this.spec.getInteractionImage(), object2.getWidth(), object2.getHeight());
            this.setCustomInteractionDialogImageVisual(interactionDialogImageVisual);
        }
        this.cargo.initMothballedShips(string4);
        this.layers = EnumSet.noneOf(CampaignEngineLayers.class);
        for (CampaignEngineLayers campaignEngineLayers : this.spec.getLayers()) {
            if (this.firstLayer == null) {
                this.firstLayer = campaignEngineLayers;
            }
            this.layers.add(campaignEngineLayers);
        }
        for (String string5 : this.spec.getTags()) {
            this.addTag(string5);
        }
        this.setFacing(90.0f);
        if (this.plugin != null) {
            this.plugin.init((SectorEntityToken)this, object);
        }
        if (this.spec.getDetectionRange() > 0.0f) {
            this.setSensorProfile(Float.valueOf(1.0f));
            this.setDiscoverable(this.spec.isDiscoverable());
            if (this.spec.getDiscoveryXP() > 0.0f) {
                this.setDiscoveryXP(Float.valueOf(this.spec.getDiscoveryXP()));
            }
            this.getDetectedRangeMod().modifyFlat("gen", this.spec.getDetectionRange());
        }
    }

    public boolean isShowNameOnMap() {
        return this.spec.isShowNameOnMap();
    }

    public boolean isShowInCampaign() {
        return this.spec.isShowInCampaign();
    }

    public boolean isShowIconOnMap() {
        return this.spec.isShowIconOnMap();
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        com.fs.starfarer.loading.String.o00000((Object)this, CustomCampaignEntity.class, this.j1, new String[]{"width", "height", "radius", "sheetCellX", "sheetCellY", "type"});
        this.spec = SpecStore.super(oooO.class, this.type);
        this.layers = EnumSet.noneOf(CampaignEngineLayers.class);
        for (CampaignEngineLayers campaignEngineLayers : this.spec.getLayers()) {
            if (this.firstLayer == null) {
                this.firstLayer = campaignEngineLayers;
            }
            this.layers.add(campaignEngineLayers);
        }
        if (this.cargo == null) {
            this.cargo = new CargoData(false);
            this.cargo.initMothballedShips(this.getFaction().getId());
        }
        if (!this.inConstructor) {
            if (this.plugin == null && this.spec.getPluginClassName() != null) {
                this.plugin = this.spec.getPlugin();
                if (this.plugin != null) {
                    this.plugin.init((SectorEntityToken)this, null);
                }
            } else if (this.plugin != null && this.spec.getPluginClassName() == null) {
                this.plugin = null;
            }
        }
        if (this.getCustomDescriptionId() == null) {
            this.setCustomDescriptionId(this.spec.getCustomDescriptionId());
        } else if (this.spec.getCustomDescriptionId() == null) {
            this.setCustomDescriptionId(null);
        }
        if (this.width < 0.0f) {
            this.width = this.spec.getSpriteWidth();
        }
        if (this.height < 0.0f) {
            this.height = this.spec.getSpriteHeight();
        }
        if (this.spec.isInteractable()) {
            this.getIndicator().super(this.getFaction().getSpec().getColor(), this.getFaction().getSpec().getSecondaryUIColor(), this.getFaction().getSpec().getSecondarySegments());
        }
        if (this.spec.getSpriteName() != null) {
            this.sprite = new Sprite(this.spec.getSpriteName());
            this.sprite.setSize(this.width, this.height);
            this.shadowMask = new Sprite("graphics/fx/ship_shadow_mask.png");
            this.shadowMask.setSize(this.width * 1.7f, this.height * 1.7f);
        } else if (this.spec.getSheetName() != null) {
            this.sprite = new Sprite(this.spec.getSheetName());
            float f2 = this.sprite.getWidth();
            float f3 = this.sprite.getHeight();
            int n2 = (int)(f2 / this.spec.getSheetCellSize());
            int n3 = (int)(f3 / this.spec.getSheetCellSize());
            float f4 = (int)(Math.random() * (double)n2);
            float f5 = (int)(Math.random() * (double)n3);
            if (this.sheetCellX >= 0) {
                f4 = this.sheetCellX;
            }
            if (this.sheetCellY >= 0) {
                f5 = this.sheetCellY;
            }
            float f6 = this.sprite.getTexture().while() / (float)n2;
            float f7 = this.sprite.getTexture().o00000() / (float)n3;
            this.sprite.setTexX(f4 * f6);
            this.sprite.setTexY(f5 * f7);
            this.sprite.setTexWidth(f6);
            this.sprite.setTexHeight(f7);
            this.sprite.setSize(this.width, this.height);
            this.shadowMask = new Sprite("graphics/fx/ship_shadow_mask.png");
            this.shadowMask.setSize(this.width * 1.7f, this.height * 1.7f);
        } else {
            this.sprite = null;
            this.shadowMask = null;
        }
        return this;
    }

    @Override
    protected Object writeReplace() {
        super.writeReplace();
        this.j1 = com.fs.starfarer.loading.String.o00000((Object)this, CustomCampaignEntity.class, new String[]{"width", "height", "radius", "sheetCellX", "sheetCellY", "type"});
        if (this.cargo != null && this.cargo.isEmpty()) {
            this.cargo = null;
        }
        return this;
    }

    public oooO getSpec() {
        return this.spec;
    }

    @Override
    public CustomEntitySpecAPI getCustomEntitySpec() {
        return this.spec;
    }

    @Override
    public boolean isRenderCircleIndicator() {
        return this.spec.isRenderCircleIndicator();
    }

    @Override
    public boolean isRenderCircleIndicatorSelectionFlash() {
        return this.spec.isRenderCircleIndicatorSelectionFlash();
    }

    public String getIconSpriteName() {
        return this.spec.getIconName();
    }

    @Override
    public CargoData getCargo() {
        return this.cargo;
    }

    @Override
    public String getFullName() {
        return super.getFullName();
    }

    @Override
    public void advance(float f2) {
        super.advance(f2);
        if (this.plugin != null) {
            this.plugin.advance(f2);
        }
        if (this.fleetForVisual != null && !this.fleetForVisual.isAlive()) {
            boolean bl = this.fleetForVisual.isHidden();
            LocationAPI locationAPI = this.fleetForVisual.getContainingLocation();
            this.fleetForVisual.setHidden(false);
            if (bl) {
                this.fleetForVisual.getSensorFader().forceIn();
                this.fleetForVisual.getSensorContactFader().forceIn();
            }
            this.fleetForVisual.setContainingLocation(this.getContainingLocation());
            this.fleetForVisual.setLocation(this.getLocation().x, this.getLocation().y);
            this.fleetForVisual.setLightSource(this.lightSource);
            this.fleetForVisual.setLightColor(this.getLightColor());
            this.fleetForVisual.setFacing(this.getFacing());
            this.fleetForVisual.advance(f2);
            if (this.fleetForVisual.getOrbit() != null) {
                this.fleetForVisual.getOrbit().advance(f2);
            }
            this.fleetForVisual.setContainingLocation(locationAPI);
            this.fleetForVisual.setHidden(bl);
            if (bl) {
                this.fleetForVisual.getSensorFader().forceOut();
                this.fleetForVisual.getSensorContactFader().forceOut();
            }
        }
    }

    @Override
    public CustomCampaignEntityPlugin getCustomPlugin() {
        return this.plugin;
    }

    public float getSelectionSize() {
        return this.radius;
    }

    @Override
    public float getRadius() {
        return this.getSelectionSize();
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        if (!this.spec.isShowInCampaign()) {
            return;
        }
        if (this.fleetForVisual != null) {
            SectorEntityToken.VisibilityLevel visibilityLevel = this.getVisibilityLevelToPlayerFleet();
            if (visibilityLevel == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || visibilityLevel == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS) {
                boolean bl = this.fleetForVisual.isHidden();
                LocationAPI locationAPI = this.fleetForVisual.getContainingLocation();
                this.fleetForVisual.setHidden(false);
                if (bl) {
                    this.fleetForVisual.getSensorFader().forceIn();
                    this.fleetForVisual.getSensorContactFader().forceIn();
                }
                this.fleetForVisual.setContainingLocation(this.getContainingLocation());
                this.fleetForVisual.setLocation(this.getLocation().x, this.getLocation().y);
                this.fleetForVisual.setLightSource(this.lightSource);
                this.fleetForVisual.setLightColor(this.getLightColor());
                if (this.fleetForVisual.getFleetView() != null) {
                    this.fleetForVisual.getFleetView().setLightSource(this.lightSource, this.getLightColor());
                }
                this.fleetForVisual.setFacing(this.getFacing());
                this.fleetForVisual.render(campaignEngineLayers, combatViewport);
                this.fleetForVisual.setContainingLocation(locationAPI);
                this.fleetForVisual.setHidden(bl);
                if (bl) {
                    this.fleetForVisual.getSensorFader().forceOut();
                    this.fleetForVisual.getSensorContactFader().forceOut();
                }
            }
            return;
        }
        float f2 = combatViewport.getAlphaMult();
        f2 *= this.getSensorFader().getBrightness();
        if ((f2 *= this.getSensorContactFader().getBrightness()) <= 0.0f) {
            return;
        }
        if (combatViewport.isNearViewport(this.getLocation(), Math.max(this.width, this.height) + 100.0f) && this.firstLayer == campaignEngineLayers && this.sprite != null && this.shadowMask != null) {
            if (this.lightSource != null && this.getLightColor() != null && this.spec.isUseLightColor()) {
                this.sprite.setColor(this.getLightColor());
            } else {
                this.sprite.setColor(Color.white);
            }
            this.sprite.setAngle(this.getFacing() - 90.0f);
            Vector2f vector2f = this.getLocation();
            this.sprite.setNormalBlend();
            this.sprite.setAlphaMult(f2);
            this.sprite.renderAtCenter(vector2f.x, vector2f.y);
            if (this.lightSource != null && this.spec.isRenderShadow() && !this.lightSource.hasTag("ambient_ls")) {
                float f3;
                float f4 = f3 = this.shadowMask.getWidth() * 1.41f;
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
                O.class(0.0f - f3 / 2.0f - 1.0f, 0.0f - f4 / 2.0f - 1.0f, f3 + 2.0f, f4 + 2.0f, O.o00000, 0.0f);
                GL11.glPopMatrix();
                this.sprite.setBlendFunc(1, 0);
                this.sprite.renderAtCenter(vector2f.x, vector2f.y);
                float f5 = Utils.\u00d500000(this.getLocation(), this.lightSource.getLocation());
                this.shadowMask.setAlphaMult(f2);
                this.shadowMask.setAngle(f5);
                this.shadowMask.setBlendFunc(0, 770);
                this.shadowMask.renderAtCenter(vector2f.x, vector2f.y);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.shadowMask.setBlendFunc(772, 773);
                this.shadowMask.renderAtCenter(vector2f.x, vector2f.y);
            }
        }
        if (this.plugin != null && combatViewport.isNearViewport(this.getLocation(), this.plugin.getRenderRange())) {
            this.plugin.render(campaignEngineLayers, (ViewportAPI)combatViewport);
        }
    }

    public void setLightSource(CampaignEntity campaignEntity) {
        this.lightSource = campaignEntity;
        this.lightSource = campaignEntity;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public void setActiveLayers(CampaignEngineLayers ... campaignEngineLayersArray) {
        BaseLocation baseLocation;
        this.layers = EnumSet.noneOf(CampaignEngineLayers.class);
        this.firstLayer = null;
        if (campaignEngineLayersArray != null) {
            CampaignEngineLayers[] campaignEngineLayersArray2 = campaignEngineLayersArray;
            int n2 = campaignEngineLayersArray.length;
            int n3 = 0;
            while (n3 < n2) {
                baseLocation = campaignEngineLayersArray2[n3];
                if (this.firstLayer == null) {
                    this.firstLayer = baseLocation;
                }
                this.layers.add((CampaignEngineLayers)baseLocation);
                ++n3;
            }
        }
        if ((baseLocation = this.getContainingLocation()) != null) {
            baseLocation.renderingLayersUpdated(this);
        }
    }

    @Override
    public String getCustomEntityType() {
        return this.type;
    }

    public boolean isStar() {
        return false;
    }

    public CampaignFleetAPI getFleetForVisual() {
        return this.fleetForVisual;
    }

    public void setFleetForVisual(CampaignFleetAPI campaignFleetAPI) {
        this.fleetForVisual = (CampaignFleet)campaignFleetAPI;
    }
}

