/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.AssignmentModulePlugin;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.ai.CampaignFleetAI;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentModule
implements DoNotObfuscate,
AssignmentModulePlugin {
    private CampaignFleet fleet;
    private List<CampaignFleetAI.FleetAssignmentData> assignments = new ArrayList<CampaignFleetAI.FleetAssignmentData>();
    private Boolean fr = null;

    public AssignmentModule(CampaignFleet campaignFleet, ModularFleetAIAPI modularFleetAIAPI) {
        this.fleet = campaignFleet;
    }

    public void freezeAssignments() {
        this.fr = true;
    }

    public boolean areAssignmentsFrozen() {
        return this.fr != null;
    }

    public void advance(float f2) {
        float f3;
        CampaignFleetAI.FleetAssignmentData fleetAssignmentData = null;
        while (fleetAssignmentData == null && !this.assignments.isEmpty()) {
            CampaignFleetAI.FleetAssignmentData fleetAssignmentData2 = fleetAssignmentData = this.assignments.isEmpty() ? null : this.assignments.get(0);
            if (fleetAssignmentData.elapsedDays <= 0.0f && fleetAssignmentData.onStart != null) {
                fleetAssignmentData.onStart.run();
                fleetAssignmentData.onStart = null;
            }
            boolean bl = false;
            if (!(fleetAssignmentData.target == null || fleetAssignmentData.target.isAlive() || fleetAssignmentData.getAssignment() != FleetAssignment.ORBIT_AGGRESSIVE && fleetAssignmentData.getAssignment() != FleetAssignment.ORBIT_PASSIVE)) {
                bl = true;
            }
            if (fleetAssignmentData == null || !fleetAssignmentData.isExpired() && !bl) continue;
            this.assignments.remove(0);
            if (fleetAssignmentData.onCompletion != null) {
                fleetAssignmentData.onCompletion.run();
                fleetAssignmentData.onCompletion = null;
            }
            if (fleetAssignmentData.assignment == FleetAssignment.ORBIT_PASSIVE || fleetAssignmentData.assignment == FleetAssignment.ORBIT_AGGRESSIVE) {
                this.fleet.setOrbit(null);
            }
            if (fleetAssignmentData.addTimeToNext != null && fleetAssignmentData.addTimeToNext.booleanValue()) {
                float f4 = f3 = fleetAssignmentData.timeToAdd != null ? fleetAssignmentData.timeToAdd.floatValue() : 0.0f;
                if (f3 > 0.0f && !this.assignments.isEmpty()) {
                    this.assignments.get((int)0).maxDurationInDays += f3;
                }
            }
            fleetAssignmentData = null;
        }
        if (fleetAssignmentData == null) {
            fleetAssignmentData = new CampaignFleetAI.FleetAssignmentData(FleetAssignment.PATROL_SYSTEM, null, 1.0f, null, null);
        }
        fleetAssignmentData.advanceDays(f2);
        Vector2f vector2f = new Vector2f();
        f3 = 0.0f;
        if (fleetAssignmentData.target != null) {
            StarSystemAPI starSystemAPI;
            vector2f = fleetAssignmentData.target.getLocation();
            f3 = Utils.\u00d800000(vector2f, this.fleet.getLocation());
            f3 -= fleetAssignmentData.target.getRadius();
            if (fleetAssignmentData.target.hasTag("station")) {
                f3 -= 20.0f;
            }
            if (fleetAssignmentData.target.getContainingLocation() != this.fleet.getContainingLocation()) {
                f3 = Float.MAX_VALUE;
            } else if (fleetAssignmentData.assignment == FleetAssignment.GO_TO_LOCATION && fleetAssignmentData.target != null && fleetAssignmentData.target.getContainingLocation() instanceof StarSystemAPI && (starSystemAPI = (StarSystemAPI)fleetAssignmentData.target.getContainingLocation()).getCenter() == fleetAssignmentData.target) {
                f3 = 0.0f;
            }
        }
        float f5 = 50.0f;
        if (Global.getSector().isInFastAdvance()) {
            f5 = 500.0f;
        }
        switch (fleetAssignmentData.assignment) {
            case RESUPPLY: {
                if (!(f3 < f5)) break;
                this.resupplyAndRestoreFightingStrength();
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case DELIVER_RESOURCES: 
            case DELIVER_SUPPLIES: 
            case DELIVER_FUEL: 
            case DELIVER_PERSONNEL: 
            case DELIVER_CREW: 
            case DELIVER_MARINES: 
            case GO_TO_LOCATION: {
                if (!(f3 < f5)) break;
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case GO_TO_LOCATION_AND_DESPAWN: {
                if (!(f3 < f5)) break;
                this.fleet.despawn(CampaignEventListener.FleetDespawnReason.REACHED_DESTINATION, fleetAssignmentData.target);
                fleetAssignmentData.expire();
                if (fleetAssignmentData.onCompletion != null) {
                    fleetAssignmentData.onCompletion.run();
                    fleetAssignmentData.onCompletion = null;
                }
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
            }
        }
    }

    public FleetAssignmentDataAPI getCurrentAssignment() {
        CampaignFleetAI.FleetAssignmentData fleetAssignmentData = this.assignments.isEmpty() ? null : this.assignments.get(0);
        return fleetAssignmentData;
    }

    public List<FleetAssignmentDataAPI> getAssignmentsCopy() {
        return new ArrayList<FleetAssignmentDataAPI>(this.assignments);
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        this.assignments.add(new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, null, script));
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, boolean bl, Script script, Script script2) {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        this.assignments.add(new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, bl, script, script2));
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        this.assignments.add(new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, script));
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        this.assignments.add(0, new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, script));
        this.fleet.setInteractionTarget(null);
        this.fleet.setOrbit(null);
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        this.assignments.add(0, new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, null, script));
        this.fleet.setInteractionTarget(null);
        this.fleet.setOrbit(null);
    }

    public boolean isCurrentAssignment(FleetAssignment fleetAssignment) {
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.getCurrentAssignment();
        return fleetAssignmentDataAPI != null && fleetAssignmentDataAPI.getAssignment() == fleetAssignment;
    }

    public void removeFirstAssignmentIfItIs(FleetAssignment fleetAssignment) {
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.getCurrentAssignment();
        if (fleetAssignmentDataAPI != null && fleetAssignmentDataAPI.getAssignment() == fleetAssignment) {
            this.removeFirstAssignment();
        }
    }

    public void removeFirstAssignment() {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        if (!this.assignments.isEmpty()) {
            this.assignments.remove(0);
        }
    }

    public void removeAssignment(FleetAssignmentDataAPI fleetAssignmentDataAPI) {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        this.assignments.remove(fleetAssignmentDataAPI);
    }

    public void clearAssignments() {
        if (this.areAssignmentsFrozen()) {
            return;
        }
        this.assignments.clear();
    }

    private void resupplyAndRestoreFightingStrength() {
        float f2;
        if (!this.fleet.isAIMode()) {
            float f3 = this.fleet.getTotalSupplyCostPerDay() * 30.0f;
            float f4 = f3 * 0.33f;
            F f5 = SpecStore.super(F.class, "supplies");
            f2 = this.fleet.getCargo().getSpaceLeft() / f5.getCargoSpace();
            if (f2 < f4) {
                this.fleet.despawn(CampaignEventListener.FleetDespawnReason.NO_REASON_PROVIDED, null);
                return;
            }
            f3 = Math.min(f3, f2);
            this.fleet.getCargo().addSupplies(f3);
            float f6 = this.fleet.getCargo().getSpaceLeft();
            this.fleet.getCargo().addSupplies((float)((int)f6) * 0.5f);
            float f7 = this.fleet.getCargo().getMaxFuel() - this.fleet.getCargo().getFuel();
            this.fleet.getCargo().addFuel(f7);
        }
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            fleetMember.getStatus().repairFully();
            float f8 = fleetMember.getRepairTracker().getMaxCR();
            f2 = fleetMember.getRepairTracker().getBaseCR();
            if (!(f8 > f2)) continue;
            fleetMember.getRepairTracker().applyCREvent(f8 - f2, "Repaired at station");
        }
    }
}

