/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.NavigationModulePlugin;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationModule
implements DoNotObfuscate,
NavigationModulePlugin {
    private CampaignFleet fleet;
    private TimeoutTracker<AvoidData> avoiding = new TimeoutTracker();
    private TimeoutTracker<SectorEntityToken> doNotAvoid = new TimeoutTracker();
    private Vector2f destination = new Vector2f();
    private Vector2f clickLocation = new Vector2f();
    private boolean hasDest = false;

    public NavigationModule(CampaignFleet campaignFleet, ModularFleetAIAPI modularFleetAIAPI) {
        this.fleet = campaignFleet;
    }

    protected Object writeReplace() {
        return this;
    }

    public void doNotAvoid(SectorEntityToken sectorEntityToken, float f2) {
        this.getDoNotAvoid().set((Object)sectorEntityToken, f2);
    }

    public TimeoutTracker<SectorEntityToken> getDoNotAvoid() {
        if (this.doNotAvoid == null) {
            this.doNotAvoid = new TimeoutTracker();
        }
        return this.doNotAvoid;
    }

    public TimeoutTracker<AvoidData> getAvoiding() {
        return this.avoiding;
    }

    public void advance(float f2) {
        Vector2f vector2f;
        float f3;
        this.avoiding.advance(f2);
        this.getDoNotAvoid().advance(f2);
        Vector2f vector2f2 = new Vector2f();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        CampaignFleetAPI campaignFleetAPI = null;
        float f4 = f3 = 1000000.0f;
        float f5 = f3;
        for (AvoidData avoidData : this.avoiding.getItems()) {
            float f6;
            float f7;
            if (avoidData.containingLocation != null && avoidData.containingLocation != this.fleet.getContainingLocation() || this.getDoNotAvoid().contains((Object)avoidData.entity) || (f7 = Utils.\u00d800000(this.fleet.getLocation(), avoidData.getLocation())) > avoidData.maxRange || avoidData.entity == this.fleet || avoidData.entity != null && this.fleet.getContainingLocation() != avoidData.entity.getContainingLocation()) continue;
            if (f7 < f4) {
                f4 = f7;
                f5 = Math.min(f5, avoidData.minRange);
            }
            float f8 = f7 <= avoidData.minRange ? 1.0f : ((f6 = avoidData.maxRange - avoidData.minRange) <= 1.0f ? 2.0f : 2.0f - (f7 - avoidData.minRange) / f6);
            vector2f = Utils.Object(Utils.Object(avoidData.getLocation(), this.fleet.getLocation()));
            vector2f.scale(f8);
            if (avoidData.entity instanceof CampaignFleetAPI) {
                ++n2;
                campaignFleetAPI = (CampaignFleetAPI)avoidData.entity;
                bl = true;
                if (avoidData.entity.isPlayerFleet()) {
                    bl2 = true;
                }
            }
            ++n3;
            Vector2f.add((Vector2f)vector2f2, (Vector2f)vector2f, (Vector2f)vector2f2);
        }
        float f9 = Utils.\u00d800000(this.fleet.getLocation(), this.destination);
        if (f9 <= 0.0f) {
            Misc.wiggle((Vector2f)this.destination, (float)1.0f);
        }
        Vector2f vector2f3 = Utils.Object(Utils.Object(this.fleet.getLocation(), this.destination));
        if (f4 < f3 && f4 > f5 + 1000.0f) {
            vector2f2.set(0.0f, 0.0f);
        }
        Vector2f.add((Vector2f)vector2f2, (Vector2f)vector2f3, (Vector2f)vector2f2);
        if (f9 > 10000.0f) {
            f9 = 10000.0f;
        }
        if (!this.hasDest) {
            f9 = 2000.0f;
            if (this.avoiding.getItems().isEmpty()) {
                f9 = 0.0f;
            }
        } else if (this.hasDest && bl) {
            f9 = 2000.0f;
        }
        if (n3 <= 1 && campaignFleetAPI != null) {
            boolean bl3 = false;
            AbilityPlugin abilityPlugin = this.fleet.getAbility("emergency_burn");
            if (abilityPlugin != null && abilityPlugin.isActiveOrInProgress()) {
                bl3 = true;
            }
            vector2f = this.fleet.getMemoryWithoutUpdate();
            String string = "$cfai_avoidDir";
            String string2 = "$cfai_prevAvoidDir";
            String string3 = "$cfai_tempAvoidSlowly";
            float f10 = vector2f.getFloat(string);
            if (f10 == 0.0f) {
                float f11 = vector2f.getFloat(string2);
                f10 = (float)Math.random() < 0.5f ? 1.0f : -1.0f;
                vector2f.set(string, (Object)Float.valueOf(f10 *= 60.0f), 0.25f + (float)Math.random() * 0.5f);
                vector2f.set(string2, (Object)Float.valueOf(f10), 1.0f);
                if (Math.signum(f11) != Math.signum(f10)) {
                    vector2f.set(string3, (Object)true, 0.25f + (float)Math.random() * 0.25f);
                }
            }
            boolean bl4 = bl2 && Misc.isAvoidingPlayerHalfheartedly((CampaignFleetAPI)this.fleet);
            bl4 |= vector2f.getBoolean(string3);
            if (bl3) {
                bl4 = false;
            }
            float f12 = Misc.getAngleInDegrees((Vector2f)vector2f2);
            vector2f2 = Misc.getUnitVectorAtDegreeAngle((float)(f12 += f10));
            if (bl4) {
                f9 = 50.0f;
            }
        }
        this.clickLocation = Utils.o00000(vector2f2);
        this.clickLocation.scale(f9);
        Vector2f.add((Vector2f)this.clickLocation, (Vector2f)this.fleet.getLocation(), (Vector2f)this.clickLocation);
    }

    private AvoidData getDataForEntity(SectorEntityToken sectorEntityToken) {
        AvoidData avoidData2;
        for (AvoidData avoidData2 : this.avoiding.getItems()) {
            if (avoidData2.entity != sectorEntityToken) continue;
            return avoidData2;
        }
        avoidData2 = new AvoidData();
        avoidData2.entity = sectorEntityToken;
        return avoidData2;
    }

    public void avoidEntity(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
        AvoidData avoidData = this.getDataForEntity(sectorEntityToken);
        avoidData.minRange = f2;
        avoidData.maxRange = f3;
        this.avoiding.set((Object)avoidData, f4);
    }

    public void unavoidEntity(SectorEntityToken sectorEntityToken) {
        AvoidData avoidData = this.getDataForEntity(sectorEntityToken);
        this.avoiding.remove((Object)avoidData);
    }

    public void avoidLocation(LocationAPI locationAPI, Vector2f vector2f, float f2, float f3, float f4) {
        AvoidData avoidData = new AvoidData();
        avoidData.minRange = f2;
        avoidData.maxRange = f3;
        avoidData.loc = vector2f;
        avoidData.containingLocation = locationAPI;
        this.avoiding.set((Object)avoidData, f4);
    }

    public void clearAvoidList() {
        this.avoiding.clear();
    }

    public float getCalculatedHeading() {
        return Utils.Object(this.fleet.getLocation(), this.clickLocation);
    }

    public float getPreferredHeading(float f2) {
        return Utils.Object(this.fleet.getLocation(), this.destination);
    }

    public void setDestination(Vector2f vector2f) {
        if (vector2f == null) {
            this.hasDest = false;
            this.destination.set((ReadableVector2f)this.fleet.getLocation());
        } else {
            this.hasDest = true;
            this.destination.set((ReadableVector2f)vector2f);
        }
    }

    public void setPreferredHeading(float f2) {
        Vector2f vector2f = Utils.Object(f2);
        vector2f.scale(10000.0f);
        Vector2f.add((Vector2f)vector2f, (Vector2f)this.fleet.getLocation(), (Vector2f)vector2f);
        this.destination.set((ReadableVector2f)vector2f);
    }

    public Vector2f getClickToMoveLocation() {
        return this.clickLocation;
    }

    public static class AvoidData
    implements DoNotObfuscate {
        Vector2f loc;
        SectorEntityToken entity;
        float minRange;
        float maxRange;
        LocationAPI containingLocation;

        public Vector2f getLocation() {
            if (this.loc != null) {
                return this.loc;
            }
            return this.entity.getLocation();
        }
    }
}

