/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.A;
import com.fs.starfarer.campaign.command.C;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.L;
import com.fs.starfarer.campaign.command.M;
import com.fs.starfarer.campaign.command.if;
import com.fs.starfarer.campaign.ui.B;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.oOoo;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.oooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeaponBlueprintBrowser
extends L
implements C,
UITable.Oo {
    public static String ALL_TECHS = "All designs";
    public static String ALL_SIZES = "All sizes";
    public static String ALL_TYPES = "All types";
    public static String SMALL = "Small";
    public static String MEDIUM = "Medium";
    public static String LARGE = "Large";
    public static String BALLISTIC = "Ballistic";
    public static String MISSILE = "Missile";
    public static String ENERGY = "Energy";
    private List<BaseWeaponSpec> O0\u00d2000 = new ArrayList<BaseWeaponSpec>();
    private CustomProductionPanel super.null$super;
    private TableColumns \u00f8\u00f8o000 = null;

    public WeaponBlueprintBrowser(CustomProductionPanel customProductionPanel, L.o o2) {
        super(o2, customProductionPanel);
        this.super.null$super = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableWeapons() != null) {
            for (String string : customProductionPanel.getDelegate().getAvailableWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.super(BaseWeaponSpec.class, string);
                this.O0\u00d2000.add(baseWeaponSpec);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (String string : faction.getKnownWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.super(BaseWeaponSpec.class, string);
                this.O0\u00d2000.add(baseWeaponSpec);
            }
        }
    }

    public List<BaseWeaponSpec> getKnownWeapons() {
        return this.O0\u00d2000;
    }

    @Override
    protected UITable createTable() {
        oOoo oOoo2 = new oOoo(this.faction);
        oOoo2.addColumn((Object)TableColumns.NAME, "Weapon blueprint", 300.0f, true);
        oOoo2.addColumn((Object)TableColumns.SIZE, "Size", 80.0f, true);
        oOoo2.addColumn((Object)TableColumns.TYPE, "Type", 80.0f, true);
        oOoo2.addColumn((Object)TableColumns.TECH, "Design type", 200.0f, true);
        oOoo2.setTooltip(0, "Weapon name. Mouse over the icon for a detailed tooltip with its stats.");
        oOoo2.setTooltip(1, "Weapon size.");
        oOoo2.setTooltip(2, "Weapon type - ballistic, energy, or missile.");
        oOoo2.setTooltip(3, "The originator of the design (such as a corporation or a faction), or \"Common\" for designs found in use throughout the Sector.");
        if (this.mode == L.o.\u00d300000) {
            oOoo2.addColumn((Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            oOoo2.setTooltip(4, "Prioriziting a weapon will make it more likely to be used by your faction's fleets.");
        } else {
            oOoo2.addColumn((Object)TableColumns.COST, "Cost", 120.0f, true);
            oOoo2.setTooltipAbove(4, new StandardTooltipV2Expandable(300.0f, false){

                public void createImpl(boolean bl) {
                    this.addPara("Production cost.", 0.0f);
                }
            });
        }
        UITable uITable = new UITable(8000.0f, if.ROW_HEIGHT, oOoo2, this);
        uITable.setEmptyText("No matching weapon blueprints");
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(if.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        Set<String> set = this.tags.getSelected();
        for (BaseWeaponSpec baseWeaponSpec : this.O0\u00d2000) {
            if (!this.weaponMatchesTags(baseWeaponSpec, set)) continue;
            A a2 = new A(this.super.null$super, this.table.getHeader(), A.o.new, baseWeaponSpec.getWeaponId(), this.mode);
            this.table.addRow(a2);
            if (this.mode != L.o.\u00d200000) continue;
            a2.getButton().getLogic().super(oooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o.String);
        }
        this.table.resumeRecompute();
        this.table.sort((Object)TableColumns.SIZE, false);
        super.updateTable();
    }

    protected boolean weaponMatchesTags(BaseWeaponSpec baseWeaponSpec, Set<String> set) {
        WeaponAPI.WeaponSize weaponSize = baseWeaponSpec.getSize();
        String string = null;
        if (weaponSize == WeaponAPI.WeaponSize.SMALL) {
            string = SMALL;
        }
        if (weaponSize == WeaponAPI.WeaponSize.MEDIUM) {
            string = MEDIUM;
        }
        if (weaponSize == WeaponAPI.WeaponSize.LARGE) {
            string = LARGE;
        }
        if (string != null && !set.contains(string)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC && !set.contains(BALLISTIC)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE && !set.contains(MISSILE)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.ENERGY && !set.contains(ENERGY)) {
            return false;
        }
        String string2 = baseWeaponSpec.getManufacturer();
        return string2 == null || set.contains(string2);
    }

    @Override
    protected M createTags() {
        M m2 = new M(this.table.getWidth(), this);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        CountingMap countingMap = new CountingMap();
        for (BaseWeaponSpec baseWeaponSpec : this.O0\u00d2000) {
            countingMap.add((Object)baseWeaponSpec.getManufacturer());
            if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.SMALL) {
                ++n2;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                ++n3;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.LARGE) {
                ++n4;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC) {
                ++n5;
                continue;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE) {
                ++n6;
                continue;
            }
            if (baseWeaponSpec.getType() != WeaponAPI.WeaponType.ENERGY) continue;
            ++n7;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            m2.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                m2.addTag(string, string, countingMap.getCount((Object)string));
            }
            m2.addGroup(0.0f);
        }
        m2.beginGroup(false, ALL_SIZES, 120.0f);
        m2.addTag(SMALL, n2);
        m2.addTag(MEDIUM, n3);
        m2.addTag(LARGE, n4);
        m2.addGroup(f2 * 1.0f);
        m2.beginGroup(false, ALL_TYPES, 120.0f);
        m2.addTag(BALLISTIC, n5);
        m2.addTag(MISSILE, n6);
        m2.addTag(ENERGY, n7);
        m2.addGroup(f3);
        return m2;
    }

    @Override
    public void tagsChanged(M m2) {
        TableColumns tableColumns = this.\u00f8\u00f8o000;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((Object)tableColumns, null);
            this.table.sort((Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<B> tableGetComparator(UITable uITable, final Object object) {
        return new Comparator<B>(){

            public int super(B b2, B b3) {
                int n2;
                A a2 = (A)b2;
                A a3 = (A)b3;
                WeaponBlueprintBrowser.this.\u00f8\u00f8o000 = (TableColumns)((Object)object);
                if (object == TableColumns.SIZE && (n2 = a2.getSizeOrdinal() - a3.getSizeOrdinal()) != 0) {
                    return n2;
                }
                if (object == TableColumns.TECH && (n2 = a2.getTechString().compareTo(a3.getTechString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.TYPE && (n2 = a2.getTypeString().compareTo(a3.getTypeString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.ENABLED) {
                    if (a2.isBlueprintEnabled() && !a3.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (a3.isBlueprintEnabled() && !a2.isBlueprintEnabled()) {
                        return 1;
                    }
                    n2 = a2.getSizeOrdinal() - a3.getSizeOrdinal();
                    if (n2 != 0) {
                        return n2;
                    }
                }
                if (object == TableColumns.COST && (n2 = a2.getCostValue() - a3.getCostValue()) != 0) {
                    return n2;
                }
                return a2.getNameString().compareTo(a3.getNameString());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, B b2, Object object) {
        A a2 = (A)b2;
        if (this.mode == L.o.\u00d300000) {
            a2.setBlueprintEnabled(!a2.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n2 = 1;
            boolean bl = true;
            if (object instanceof com.fs.starfarer.util.A.Object) {
                cloneable = (com.fs.starfarer.util.A.Object)object;
                if (((com.fs.starfarer.util.A.Object)cloneable).isCtrlDown()) {
                    n2 = 1000;
                } else if (((com.fs.starfarer.util.A.Object)cloneable).isShiftDown()) {
                    n2 = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((com.fs.starfarer.util.A.Object)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.super.null$super.getProd();
            if (bl) {
                int n3 = this.super.null$super.getDelegate() == null ? 0 : (this.super.null$super.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.WEAPON, a2.getWeaponSpec().getWeaponId(), n2, n3);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.WEAPON, a2.getWeaponSpec().getWeaponId(), n2);
            }
            this.super.null$super.updatePlanTable(FactionProductionAPI.ProductionItemType.WEAPON, a2.getWeaponSpec().getWeaponId());
            a2.getButton().flash(false, 0.1f, 0.9f);
        }
        a2.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, oOoo.o o2) {
    }

    @Override
    protected void selectAll() {
        for (B b2 : this.table.getRows()) {
            A a2 = (A)b2;
            a2.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (B b2 : this.table.getRows()) {
            A a2 = (A)b2;
            a2.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (String string : faction.getKnownWeapons()) {
            faction.removePriorityWeapon(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityWeapons().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownWeapons(bl);
    }

    @Override
    protected String getAutoEnableSubject() {
        return "weapon blueprints";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownWeapons();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        SIZE,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

