/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.comms;

import com.fs.starfarer.Object;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessageParaAPI;
import com.fs.starfarer.api.campaign.comm.MessageSectionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommMessage
implements DoNotObfuscate,
CommMessageAPI {
    private String type;
    private String shortType;
    private String sender;
    private String sound = null;
    private String subject;
    private String note;
    private Color noteColor;
    private MessageSection section1 = new MessageSection();
    private MessageSection section2 = new MessageSection();
    private MessageSection section3 = new MessageSection();
    private String smallIcon;
    private String image;
    private String channel;
    private String locationString;
    private CommMessageAPI.MessageClickAction action = CommMessageAPI.MessageClickAction.NOTHING;
    private java.lang.Object customData = null;
    private final String id = Misc.genUID();
    private boolean addToIntelTab = false;
    private long timeSent;
    private long timeReceived;
    private String deliveredBy;
    private String starSystemId;
    private Vector2f locInHyper = null;
    private Highlights subjectHighlights = null;
    private Set<String> tags = null;
    private Color subjectColor;
    private OnMessageDeliveryScript onDelivery;
    private String marketId = null;
    private List<CampaignEventPlugin.PriceUpdatePlugin> priceUpdates = null;
    private Map<String, java.lang.Object> customMap = new HashMap<String, java.lang.Object>();
    private boolean showInCampaignList = true;
    private SectorEntityToken centerMapOnEntity = null;

    public CommMessage() {
    }

    public CommMessage(String string) {
        this.subject = string;
    }

    public CommMessage(String string, Color color) {
        this.subject = string;
        this.subjectColor = color;
    }

    public CommMessage(String string, String string2, String string3) {
        this.type = string;
        this.subject = string2;
        this.smallIcon = string3;
    }

    public SectorEntityToken getCenterMapOnEntity() {
        return this.centerMapOnEntity;
    }

    public void setCenterMapOnEntity(SectorEntityToken sectorEntityToken) {
        this.centerMapOnEntity = sectorEntityToken;
    }

    public Vector2f getLocInHyper() {
        return this.locInHyper;
    }

    public void setLocInHyper(Vector2f vector2f) {
        this.locInHyper = vector2f;
    }

    public boolean isShowInCampaignList() {
        return this.showInCampaignList;
    }

    public void setShowInCampaignList(boolean bl) {
        this.showInCampaignList = bl;
    }

    public Color getSubjectColor() {
        if (this.subjectColor == null) {
            return Object.\u00d400000;
        }
        return this.subjectColor;
    }

    public void setSubjectColor(Color color) {
        this.subjectColor = color;
    }

    public OnMessageDeliveryScript getOnDelivery() {
        return this.onDelivery;
    }

    public void setOnDelivery(OnMessageDeliveryScript onMessageDeliveryScript) {
        this.onDelivery = onMessageDeliveryScript;
    }

    public String getId() {
        return this.id;
    }

    public boolean isAddToIntelTab() {
        return this.addToIntelTab;
    }

    public void setAddToIntelTab(boolean bl) {
        this.addToIntelTab = bl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getShortType() {
        return this.shortType;
    }

    public void setShortType(String string) {
        this.shortType = string;
    }

    public String getDeliveredBy() {
        return this.deliveredBy;
    }

    public void setDeliveredBy(String string) {
        this.deliveredBy = string;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public long getTimeSent() {
        return this.timeSent;
    }

    public void setTimeSent(long l) {
        this.timeSent = l;
    }

    public long getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(long l) {
        this.timeReceived = l;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public MessageSectionAPI getSection1() {
        return this.section1;
    }

    public MessageSectionAPI getSection2() {
        return this.section2;
    }

    public MessageSectionAPI getSection3() {
        return this.section3;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String string) {
        this.sound = string;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String string) {
        this.smallIcon = string;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String string) {
        this.image = string;
    }

    public String getStarSystemId() {
        return this.starSystemId;
    }

    public StarSystemAPI getStarSystem() {
        if (this.getStarSystemId() == null) {
            return null;
        }
        return CampaignEngine.getInstance().getStarSystem(this.getStarSystemId());
    }

    public void setStarSystemId(String string) {
        this.starSystemId = string;
    }

    public String getLocationString() {
        return this.locationString;
    }

    public void setLocationString(String string) {
        this.locationString = string;
    }

    public CommMessageAPI.MessageClickAction getAction() {
        return this.action;
    }

    public void setAction(CommMessageAPI.MessageClickAction messageClickAction) {
        this.action = messageClickAction;
    }

    public Highlights getSubjectHighlights() {
        return this.subjectHighlights;
    }

    public void setSubjectHighlights(Highlights highlights) {
        this.subjectHighlights = highlights;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public java.lang.Object getCustomData() {
        return this.customData;
    }

    public void setCustomData(java.lang.Object object) {
        this.customData = object;
    }

    public CampaignEventPlugin getEvent() {
        if (this.customData instanceof CampaignEventPlugin) {
            return (CampaignEventPlugin)this.customData;
        }
        return null;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public Color getNoteColor() {
        return this.noteColor;
    }

    public void setNoteColor(Color color) {
        this.noteColor = color;
    }

    public boolean hasTag(String string) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(string);
    }

    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(string);
    }

    public void removeTag(String string) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(string);
        if (this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    public Collection<String> getTags() {
        if (this.tags == null) {
            return new ArrayList<String>();
        }
        return this.tags;
    }

    public void clearTags() {
        if (this.tags != null) {
            this.tags.clear();
        }
    }

    public Map<String, java.lang.Object> getCustomMap() {
        return this.customMap;
    }

    public void setCustomMap(Map<String, java.lang.Object> map) {
        this.customMap = map;
    }

    public void setMarketId(String string) {
        this.marketId = string;
    }

    public String getMarketId() {
        CampaignEventTarget campaignEventTarget;
        CampaignEventPlugin campaignEventPlugin;
        if (this.marketId == null && (campaignEventPlugin = this.getEvent()) != null && (campaignEventTarget = campaignEventPlugin.getEventTarget()) != null && campaignEventTarget.getMarket() != null) {
            return campaignEventTarget.getMarket().getId();
        }
        return this.marketId;
    }

    public MarketAPI getMarket() {
        String string = this.getMarketId();
        if (string == null) {
            return null;
        }
        return CampaignEngine.getInstance().getEconomy().getMarket(string);
    }

    public List<CampaignEventPlugin.PriceUpdatePlugin> getPriceUpdates() {
        return this.priceUpdates;
    }

    public void setPriceUpdates(List<CampaignEventPlugin.PriceUpdatePlugin> list) {
        this.priceUpdates = list;
    }

    public static CommMessage createTestMessage() {
        CommMessage commMessage = new CommMessage();
        commMessage.setAddToIntelTab(true);
        if ((float)Math.random() > 0.25f) {
            commMessage.type = "News Report";
            commMessage.shortType = "News";
        } else {
            commMessage.type = "Emergency Bulletin";
            commMessage.shortType = "Bulletin";
        }
        commMessage.sender = (float)Math.random() > 0.5f ? "Hegemony Broadcast Service" : "Independent News Network";
        float f2 = (float)Math.random();
        if (f2 > 0.8f) {
            commMessage.subject = "Food shortage on Asharu";
            commMessage.starSystemId = "Corvus";
            commMessage.locationString = "Asharu";
            commMessage.getSection1().addPara("A food shortage on Asharu in the Corvus star system has caused widespread starvation. Food prices have gone up, and there is talk of a relief fleet being organized in a nearby star system.");
        } else if ((double)f2 > 0.6) {
            commMessage.subject = "Food shortage on Sindria";
            commMessage.starSystemId = "Askonia";
            commMessage.locationString = "Sindria";
            commMessage.getSection1().addPara("A food shortage on Asharu in the Corvus star system has caused widespread starvation. Food prices have gone up, and there is talk of a relief fleet being organized in a nearby star system.");
        } else if (f2 > 0.4f) {
            commMessage.subject = "Increased pirate activity";
            commMessage.starSystemId = "Valhalla";
            commMessage.locationString = "Hyperspace";
        } else if (f2 > 0.2f) {
            commMessage.subject = "Industrial equipment shortage on Cruor";
            commMessage.starSystemId = "Askonia";
            commMessage.locationString = "Cruor";
        } else {
            commMessage.subject = "Excess organics inventory on New Maxios station";
            commMessage.starSystemId = "Magec";
            commMessage.locationString = "New Maxios";
        }
        Highlights highlights = new Highlights();
        highlights.setText(new String[]{"Food"});
        highlights.setColors(new Color[]{Object.\u00d5O0000});
        commMessage.setSubjectHighlights(highlights);
        commMessage.getSection1().addPara("A food shortage on Asharu in the Corvus star system has caused widespread starvation. Food prices have gone up, and there is talk of a relief fleet being organized in a nearby star system.");
        String[] stringArray = new String[]{"graphics/hullmods/expanded_missile_racks.png", "graphics/hullmods/automated_repair_unit.png", "graphics/hullmods/targeting_core.png", "graphics/hullmods/extended_shields.png", "graphics/hullmods/heavy_armor.png"};
        String[] stringArray2 = new String[]{"graphics/illustrations/cargo_loading.jpg", "graphics/illustrations/space_wreckage_compressed.jpg", "graphics/illustrations/hull_breach.jpg", "graphics/illustrations/entering_hyperspace.jpg", "graphics/illustrations/exiting_hyperspace.jpg", "graphics/illustrations/city_from_above.jpg", "graphics/illustrations/desert_moons_ruins.jpg", "graphics/illustrations/quartermaster.jpg"};
        commMessage.smallIcon = stringArray[(int)(Math.random() * (double)stringArray.length)];
        commMessage.image = stringArray2[(int)(Math.random() * (double)stringArray2.length)];
        return commMessage;
    }

    public static class MessagePara
    implements DoNotObfuscate,
    MessageParaAPI {
        private String heading;
        private String body;
        private Color headingColor;
        private Color bodyColor;

        public String getHeading() {
            return this.heading;
        }

        public void setHeading(String string) {
            this.heading = string;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String string) {
            this.body = string;
        }

        public Color getHeadingColor() {
            return this.headingColor;
        }

        public void setHeadingColor(Color color) {
            this.headingColor = color;
        }

        public Color getBodyColor() {
            return this.bodyColor;
        }

        public void setBodyColor(Color color) {
            this.bodyColor = color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageSection
    implements DoNotObfuscate,
    MessageSectionAPI {
        private String title;
        private List<MessageParaAPI> body = new ArrayList<MessageParaAPI>();
        private String[] highlights = new String[0];
        private Color[] highlightColors = new Color[0];

        public String getTitle() {
            return this.title;
        }

        public List<MessageParaAPI> getBody() {
            return this.body;
        }

        public boolean isEmpty() {
            return this.body.isEmpty();
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public String[] getHighlights() {
            return this.highlights;
        }

        public void setHighlights(String[] stringArray) {
            this.highlights = stringArray;
        }

        public Color[] getHighlightColors() {
            return this.highlightColors;
        }

        public void setHighlightColors(Color[] colorArray) {
            this.highlightColors = colorArray;
        }

        public void addFirstPara(String string, Color color, String string2, Color color2) {
            MessagePara messagePara = new MessagePara();
            messagePara.heading = string;
            messagePara.headingColor = color;
            messagePara.body = string2;
            messagePara.bodyColor = color2;
            this.body.add(0, messagePara);
        }

        public void addPara(String string, Color color, String string2, Color color2) {
            MessagePara messagePara = new MessagePara();
            messagePara.heading = string;
            messagePara.headingColor = color;
            messagePara.body = string2;
            messagePara.bodyColor = color2;
            this.body.add(messagePara);
        }

        public void addPara(String string, Color color, String string2) {
            MessagePara messagePara = new MessagePara();
            messagePara.heading = string;
            messagePara.headingColor = color;
            messagePara.body = string2;
            messagePara.bodyColor = Object.\u00d400000;
            this.body.add(messagePara);
        }

        public void addPara(String string, String string2) {
            MessagePara messagePara = new MessagePara();
            messagePara.heading = string;
            messagePara.headingColor = Object.\u00d800000;
            messagePara.body = string2;
            messagePara.bodyColor = Object.\u00d400000;
            this.body.add(messagePara);
        }

        public void addHeading(String string, Color color) {
            MessagePara messagePara = new MessagePara();
            messagePara.heading = string;
            messagePara.headingColor = color;
            messagePara.body = null;
            messagePara.bodyColor = Object.\u00d400000;
            this.body.add(messagePara);
        }

        public void addFirstHeading(String string, Color color) {
            MessagePara messagePara = new MessagePara();
            messagePara.heading = string;
            messagePara.headingColor = color;
            messagePara.body = null;
            messagePara.bodyColor = Object.\u00d400000;
            this.body.add(0, messagePara);
        }

        public void addPara(String string) {
            MessagePara messagePara = new MessagePara();
            messagePara.heading = null;
            messagePara.headingColor = null;
            messagePara.body = string;
            messagePara.bodyColor = Object.\u00d400000;
            this.body.add(messagePara);
        }
    }
}

