/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.contract.ContractEconomy;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.starfarer.campaign.econ.reach.FinishEconomyUpdateTask;
import com.fs.starfarer.campaign.econ.reach.ImmigrationTask;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask2;
import com.fs.starfarer.campaign.econ.reach.ReachEconomy;
import com.fs.starfarer.campaign.econ.reach.UpdateMarketsAgainTask;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class ReachEconomyStepper
implements DoNotObfuscate {
    protected List<MultiFrameTask> tasks = null;
    private ReachEconomy econ;
    private State state = State.WAITING;
    private float elapsed = 1000.0f;
    private float untilNext = 3.0f;
    private int iterLeft = Economy.NUM_ITER_PER_MONTH;
    private int prevMonth = -1;

    public ReachEconomyStepper(ReachEconomy reachEconomy) {
        this.econ = reachEconomy;
    }

    public ReachEconomy getEconomy() {
        return this.econ;
    }

    public void setEcon(ReachEconomy reachEconomy) {
        this.econ = reachEconomy;
    }

    protected void doEndOfStepStuff(int n2) {
        Global.getSector().reportEconomyTick(n2);
        ListenerUtil.reportEconomyTick((int)n2);
    }

    protected void doEndOfMonthStuff() {
        Global.getSector().reportEconomyMonthEnd();
        ListenerUtil.reportEconomyMonthEnd();
    }

    public void nextFrame(float f2) {
        int n2;
        this.elapsed += f2;
        ContractEconomy.DEBUG = false;
        if (this.state == State.WAITING && (n2 = CampaignEngine.getInstance().getClock().getMonth()) != this.prevMonth) {
            this.prevMonth = n2;
            this.iterLeft = Economy.NUM_ITER_PER_MONTH;
            float f3 = this.getNumDaysInCurrentMonth() - (float)CampaignEngine.getInstance().getClock().getDay();
            this.untilNext = f3 / ((float)Economy.NUM_ITER_PER_MONTH + 0.0f);
            this.elapsed = this.untilNext / 2.0f;
            this.doEndOfStepStuff(Economy.NUM_ITER_PER_MONTH - 1);
            this.doEndOfMonthStuff();
        }
        if (this.state == State.WAITING) {
            Profiler.\u00d200000((String)"Waiting");
            if (this.elapsed >= this.untilNext && this.iterLeft > 0) {
                --this.iterLeft;
                this.state = State.DOING_TASKS;
                this.tasks = null;
                this.elapsed = 0.0f;
            }
            Profiler.o00000();
        }
        if (this.state == State.DOING_TASKS) {
            if (this.tasks == null) {
                this.createTasks();
            }
            if (this.isDone()) {
                return;
            }
            Profiler.\u00d200000((String)"Stepping economy");
            MultiFrameTask multiFrameTask = this.tasks.get(0);
            Profiler.\u00d200000((String)("Task: " + multiFrameTask.getClass().getSimpleName()));
            multiFrameTask.advance(f2);
            Profiler.o00000();
            if (multiFrameTask.isDone()) {
                this.tasks.remove(0);
            }
            if (this.isDone()) {
                if (this.iterLeft > 0) {
                    this.doEndOfStepStuff(Economy.NUM_ITER_PER_MONTH - this.iterLeft - 1);
                }
                this.state = State.WAITING;
            }
            Profiler.o00000();
        }
    }

    private float getNumDaysInCurrentMonth() {
        GregorianCalendar gregorianCalendar = CampaignEngine.getInstance().getClock().getCal();
        return gregorianCalendar.getActualMaximum(5);
    }

    private void createTasks() {
        this.tasks = new ArrayList<MultiFrameTask>();
        boolean bl = this.iterLeft <= 0;
        MainWorkTask.EconWorkParams econWorkParams = new MainWorkTask.EconWorkParams();
        econWorkParams.withIncomeAndUpkeep = true;
        econWorkParams.withStockpileUpdate = bl;
        this.tasks.add(new MainWorkTask2(this.econ.getMarkets(), this.econ, econWorkParams));
        this.tasks.add(new UpdateMarketsAgainTask((Economy)Global.getSector().getEconomy()));
        this.tasks.add(new ImmigrationTask(this.econ.getMarkets(), this.econ, false));
        this.tasks.add(new FinishEconomyUpdateTask((Economy)Global.getSector().getEconomy()));
    }

    public boolean isDone() {
        return this.tasks == null || this.tasks.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State implements DoNotObfuscate
    {
        WAITING,
        DOING_TASKS;

    }
}

