/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ui.marketinfo;

import com.fs.starfarer.Object;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.CutStyle;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutableValue;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.ui.marketinfo.IndustryPickerDialog;
import com.fs.starfarer.campaign.ui.marketinfo.dosuper;
import com.fs.starfarer.campaign.ui.marketinfo.r;
import com.fs.starfarer.campaign.ui.marketinfo.s;
import com.fs.starfarer.title.A.OoOO;
import com.fs.starfarer.ui.Objectsuper;
import com.fs.starfarer.ui.Q;
import com.fs.starfarer.ui.d;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.newui.L;
import com.fs.starfarer.ui.o0O0;
import com.fs.starfarer.ui.o0oo;
import com.fs.starfarer.ui.oo0O;
import com.fs.starfarer.ui.z;
import com.fs.starfarer.util.A.B;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IndustryListPanel
extends z
implements Objectsuper,
oo0O.o {
    protected MarketAPI market;
    protected Faction faction;
    protected Color color;
    protected Color dark;
    protected Color grid;
    protected Color bright;
    protected o0O0 build;
    private L private.for$class;
    private o \u00d5\u00f6\u00f6000;
    private s \u00d6\u00f6\u00f6000;
    protected List<r> widgets = new ArrayList<r>();

    public IndustryListPanel(MarketAPI marketAPI, L l, s s2) {
        this.market = marketAPI;
        this.private.for$class = l;
        this.\u00d6\u00f6\u00f6000 = s2;
        this.faction = (Faction)marketAPI.getFaction();
        this.color = this.faction.getBaseUIColor();
        this.dark = this.faction.getDarkUIColor();
        this.grid = this.faction.getGridUIColor();
        this.bright = this.faction.getBrightUIColor();
    }

    public s getOverview() {
        return this.\u00d6\u00f6\u00f6000;
    }

    public void recreate() {
        this.sizeChanged(this.getWidth(), this.getHeight());
    }

    public void recreateOverview() {
        Global.getSector().getEconomy().tripleStep();
        this.\u00d6\u00f6\u00f6000.recreate();
    }

    public void recreateOverviewNoEconStep() {
        this.\u00d6\u00f6\u00f6000.recreate();
    }

    private List<Industry> \u00f50O000() {
        ArrayList<Industry> arrayList = new ArrayList<Industry>(this.market.getIndustries());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!((Industry)iterator.next()).isHidden()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public List<r> getWidgets() {
        return this.widgets;
    }

    @Override
    public void sizeChanged(float f2, float f3) {
        this.clearChildren();
        super.sizeChanged(f2, f3);
        this.widgets.clear();
        List<Industry> list = this.\u00f50O000();
        Collections.sort(list, new Comparator<Industry>(){

            public int super(Industry industry, Industry industry2) {
                return industry.getSpec().getOrder() - industry2.getSpec().getOrder();
            }
        });
        List list2 = this.market.getConstructionQueue().getItems();
        float f4 = 3.0f;
        float f5 = 20.0f;
        float f6 = 20.0f;
        float f7 = r.WIDTH;
        float f8 = r.HEIGHT;
        int n2 = 3;
        int n3 = 4;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n5 * n3 + n4;
                if (n6 < list.size() + list2.size()) {
                    r r2;
                    Industry industry;
                    if (n6 < list.size()) {
                        industry = list.get(n6);
                        r2 = new r(this.market, industry, this);
                        this.widgets.add(r2);
                        this.add((o0oo)r2).setSize(f7, f8).inTL((float)n4 * (f7 + f5), (float)n5 * (f8 + f6));
                        StandardTooltipV2Expandable.addTooltipRight(r2, r.createIndustryTooltip(Industry.IndustryTooltipMode.NORMAL, industry));
                    } else {
                        industry = (ConstructionQueue.ConstructionQueueItem)list2.get(n6 -= list.size());
                        r2 = this.market.instantiateIndustry(industry.id);
                        r r3 = new r(this.market, (Industry)r2, this, n6);
                        this.widgets.add(r3);
                        this.add((o0oo)r3).setSize(f7, f8).inTL((float)n4 * (f7 + f5), (float)n5 * (f8 + f6));
                        StandardTooltipV2Expandable.addTooltipRight(r3, r.createIndustryTooltip(Industry.IndustryTooltipMode.QUEUED, (Industry)r2));
                    }
                }
                ++n5;
            }
            ++n4;
        }
        d d2 = d.createCreditsLabel("graphics/fonts/insignia21LTaa.fnt", 25.0f);
        d d3 = d.createMaxIndustriesLabel("graphics/fonts/insignia21LTaa.fnt", 25.0f, this.market);
        IndustryListPanel.addTooltips(d2, d3, this.market);
        this.build = Q.o00000("   Add industry or structure...", "graphics/fonts/orbitron20aabold.fnt", this.dark, this.color, Alignment.LMID, CutStyle.TL_BR, this);
        this.build.setShortcut(OoOO.oo.O\u00f50000, true);
        float f9 = 350.0f;
        float f10 = 25.0f;
        this.add((o0oo)this.build).setSize(f9, f10).inBL(0.0f, 50.0f);
        this.add((o0oo)d2).rightOfMid(this.build, 70.0f);
        this.add((o0oo)d3).inBR(40.0f, 50.0f);
        if (!DebugFlags.COLONY_DEBUG && !this.market.isPlayerOwned()) {
            this.build.setEnabled(false);
            if (DebugFlags.HIDE_COLONY_CONTROLS) {
                this.build.setOpacity(0.0f);
                this.build.setOpacity(0.0f);
                d2.setOpacity(0.0f);
            }
        }
    }

    public static void addTooltips(d d2, d d3, final MarketAPI marketAPI) {
        d3.setHighlightOnMouseover(true);
        d2.setHighlightOnMouseover(true);
        float f2 = 400.0f;
        StandardTooltipV2Expandable.addTooltipAbove(d2, new StandardTooltipV2Expandable(f2, false){

            public void createImpl(boolean bl) {
                this.addPara("Credits available.", 0.0f);
            }
        });
        StandardTooltipV2Expandable.addTooltipAbove(d3, new StandardTooltipV2Expandable(f2, false){

            public void createImpl(boolean bl) {
                Industry industry;
                String string;
                this.addPara("Maximum number of industries, based on the size of a colony and other factors.", 0.0f);
                this.beginTable(marketAPI.getFaction(), 20.0f, "Colony size", Float.valueOf(120.0f), "Base industries", Float.valueOf(120.0f));
                int n2 = 3;
                while (n2 <= Misc.MAX_COLONY_SIZE) {
                    this.addRow(Misc.getHighlightColor(), "" + n2, Misc.getHighlightColor(), "" + PopulationAndInfrastructure.getMaxIndustries((int)n2));
                    ++n2;
                }
                this.addTable("", 0, 10.0f);
                this.addPara("Structures such as spaceports or orbital stations do not count against this limit. Colonies that exceed this limit for any reason have their stability reduced by %s.", 20.0f, Misc.getHighlightColor(), "" + Misc.OVER_MAX_INDUSTRIES_PENALTY);
                this.addPara("Industries on %s:", 10.0f, marketAPI.getFaction().getBaseUIColor(), marketAPI.getName());
                ArrayList arrayList = new ArrayList(marketAPI.getIndustries());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (!((Industry)iterator.next()).isHidden()) continue;
                    iterator.remove();
                }
                Collections.sort(arrayList, new Comparator<Industry>(){

                    public int o00000(Industry industry, Industry industry2) {
                        return industry.getSpec().getOrder() - industry2.getSpec().getOrder();
                    }
                });
                boolean bl2 = false;
                String string2 = "    ";
                float f2 = 5.0f;
                for (Industry industry2 : arrayList) {
                    if (industry2.isIndustry()) {
                        this.addPara(String.valueOf(string2) + industry2.getCurrentName(), f2);
                        f2 = 3.0f;
                        bl2 = true;
                        continue;
                    }
                    if (!industry2.isUpgrading() || (string = industry2.getSpec().getUpgrade()) == null || !(industry = marketAPI.instantiateIndustry(string)).isIndustry()) continue;
                    this.addPara(String.valueOf(string2) + industry2.getCurrentName() + " (upgrading to " + industry.getCurrentName() + ")", f2);
                    f2 = 3.0f;
                    bl2 = true;
                }
                for (Industry industry2 : marketAPI.getConstructionQueue().getItems()) {
                    string = Global.getSettings().getIndustrySpec(industry2.id);
                    if (!string.hasTag("industry")) continue;
                    industry = marketAPI.instantiateIndustry(industry2.id);
                    this.addPara(String.valueOf(string2) + industry.getCurrentName() + " (queued)", f2);
                    f2 = 3.0f;
                    bl2 = true;
                }
                if (!bl2) {
                    this.addPara(String.valueOf(string2) + "None", f2);
                }
            }
        });
    }

    @Override
    protected void renderImpl(float f2) {
        super.renderImpl(f2);
    }

    @Override
    protected void advanceImpl(float f2) {
        int n2 = this.market.getConstructionQueue().getItems().size();
        boolean bl = this.\u00f50O000().size() + n2 < 12;
        if ((bl &= DebugFlags.COLONY_DEBUG || this.market.isPlayerOwned()) != this.build.isEnabled()) {
            this.build.setEnabled(bl);
            if (bl) {
                this.build.setTooltip(0.0f, null);
            } else {
                StandardTooltipV2Expandable.addTooltipBelow(this.build, new StandardTooltipV2Expandable(300.0f, false){

                    public void createImpl(boolean bl) {
                        this.addPara("Maximum number of industries reached.", 0.0f);
                    }
                });
            }
        }
        super.advanceImpl(f2);
    }

    @Override
    protected void processInputImpl(B b2) {
        boolean bl = false;
        for (r object : this.widgets) {
            if (object.getMode() == r.Oo.Object) continue;
            bl = true;
            break;
        }
        if (bl) {
            block1: for (com.fs.starfarer.util.A.Object object : b2) {
                if (!object.isMouseMoveEvent()) continue;
                for (r r2 : this.widgets) {
                    if (!r2.getButton().getPosition().containsEvent(object)) continue;
                    bl = false;
                    break block1;
                }
            }
        }
        if (bl) {
            for (com.fs.starfarer.util.A.Object object : b2) {
                if (object.isConsumed() || !object.isLMBDownEvent() && !object.isRMBDownEvent()) continue;
                for (r r2 : this.widgets) {
                    if (r2.getQueueIndex() < 0) continue;
                    r2.setNormalMode();
                }
                object.consume();
                break;
            }
        }
        super.processInputImpl(b2);
    }

    @Override
    public void actionPerformed(java.lang.Object object, java.lang.Object object2) {
        if (object2 == this.build) {
            IndustryPickerDialog industryPickerDialog = new IndustryPickerDialog(this.market, this.private.for$class.getDialogParentForSubDialog(), this);
            industryPickerDialog.show(0.3f, 0.2f);
            this.\u00d5\u00f6\u00f6000 = o.\u00d200000;
            return;
        }
    }

    @Override
    public void dialogDismissed(oo0O oo0O2, int n2) {
        if (this.\u00d5\u00f6\u00f6000 == null) {
            return;
        }
        switch (this.\u00d5\u00f6\u00f6000) {
            case \u00d200000: {
                IndustryPickerDialog industryPickerDialog;
                dosuper dosuper2;
                if (n2 != 0 || (dosuper2 = (industryPickerDialog = (IndustryPickerDialog)oo0O2).getSelected()) == null) break;
                Industry industry = dosuper2.getIndustry();
                int n3 = (int)industry.getBuildCost();
                Misc.getCurrentlyBeingConstructed((MarketAPI)this.market);
                this.market.getConstructionQueue().addToEnd(industry.getId(), n3);
                MutableValue mutableValue = Global.getSector().getPlayerFleet().getCargo().getCredits();
                mutableValue.subtract((float)n3);
                if (mutableValue.get() <= 0.0f) {
                    mutableValue.set(0.0f);
                }
                CampaignEngine.getInstance().getCampaignUI().getMessageDisplay().addMessage(String.format("Spent %s", Misc.getDGSCredits((float)n3)), Object.oo0000, Misc.getDGSCredits((float)n3), Object.\u00d5O0000);
                this.\u00d6\u00f6\u00f6000.recreateWithEconUpdate();
            }
        }
        this.\u00d5\u00f6\u00f6000 = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum o {
        \u00d200000;

    }
}

