/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.ProximityFuseAIAPI;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.E.OOoO;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.ai.while;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.DamagingExplosion;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.loading.specs.ifsuper;
import com.fs.starfarer.loading.specs.thisnew;
import com.fs.starfarer.prototype.Utils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.Vector2f;

public class ProximityFuseAI
implements AI,
ProximityFuseAIAPI,
MissileAIPlugin {
    private CombatEngine engine;
    private o projectile;
    private thisnew spec;
    private float range;
    private float vsMissileRange;
    private DamagingExplosionSpec explosionSpec;
    private static Logger log = Logger.getLogger(ProximityFuseAI.class);
    private boolean slowToMaxSpeed = false;

    public ProximityFuseAI(o o2, thisnew thisnew2) {
        this.spec = thisnew2;
        this.projectile = o2;
        this.engine = CombatEngine.getInstance();
        this.updateDamage();
    }

    public void updateDamage() {
        try {
            this.slowToMaxSpeed = this.spec.getParams().optBoolean("slowToMaxSpeed", false);
            this.range = (float)this.spec.getParams().getDouble("range");
            this.vsMissileRange = this.spec.getParams().has("vsMissileRange") ? (float)this.spec.getParams().getDouble("vsMissileRange") : this.range;
            if (this.spec.getParams().has("explosionSpec")) {
                this.explosionSpec = DamagingExplosionSpec.loadFromJSON((JSONObject)this.spec.getParams().getJSONObject("explosionSpec"));
                this.explosionSpec.setDamageType(this.projectile.getDamage(null, null).getType());
                this.explosionSpec.setMaxDamage(this.projectile.getDamage(null, null).getBaseDamage());
                this.explosionSpec.setMinDamage(this.projectile.getDamage(null, null).getBaseDamage() / 2.0f);
                this.explosionSpec.setEffect(this.spec.getOnHitEffect());
            }
        }
        catch (JSONException jSONException) {
            log.error((Object)jSONException, (Throwable)jSONException);
        }
    }

    public void advance(float f2) {
        float f3;
        BaseEntity baseEntity;
        if (this.projectile.isFading() && !this.projectile.didDamage()) {
            this.explode();
        }
        if (this.projectile instanceof Missile && this.slowToMaxSpeed && !((Missile)(baseEntity = (Missile)this.projectile)).isFizzling()) {
            ((Missile)baseEntity).giveCommand(new Ship.Oo(Ship.oo.Object, null));
        }
        baseEntity = this.projectile.getSource();
        new new_ = while.super(this.projectile.getLocation(), ((Ship)baseEntity).getOriginalOwner(), this.range, CollisionClass.SHIP, CollisionClass.FIGHTER, CollisionClass.MISSILE_NO_FF, CollisionClass.MISSILE_FF);
        if (new_ == null) {
            return;
        }
        float f4 = Utils.\u00d800000(new_.getLocation(), this.projectile.getLocation());
        float f5 = this.range;
        if (new_ instanceof Missile) {
            f5 = this.vsMissileRange;
        }
        if (f4 < f5 + new_.getCollisionRadius() && f5 > 0.0f && f4 < f5 + (f3 = while.super(this.projectile.getLocation(), new_, true))) {
            this.explode();
        }
    }

    public DamagingExplosion explode() {
        Object object;
        if (this.explosionSpec == null) {
            return null;
        }
        this.engine.removeObject(this.projectile);
        DamagingExplosion damagingExplosion = (DamagingExplosion)ifsuper.super(this.projectile.getSource(), null, this.explosionSpec, this.projectile.getLocation(), 0.0f, new Vector2f(), false);
        if (damagingExplosion != null) {
            object = this.projectile.getDamage(null, null);
            damagingExplosion.setExtraDamageComponents(new float[]{((OOoO)object).getModifier().getPercentMod(), ((OOoO)object).getModifier().getFlatMod(), ((OOoO)object).getModifier().getMult()});
        }
        if ((object = this.spec.getOnProximityExplosionEffect()) != null) {
            object.onExplosion((DamagingProjectileAPI)damagingExplosion, (DamagingProjectileAPI)this.projectile);
        }
        return damagingExplosion;
    }

    public void render() {
    }

    public static interface o {
        public OOoO getDamage(Vector2f var1, new var2);

        public boolean isFading();

        public boolean didDamage();

        public Ship getSource();

        public Vector2f getLocation();
    }
}

