/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai.missile;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.impl.combat.dem.DEMScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.ai.float;
import com.fs.starfarer.combat.ai.while;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.util.IntervalTracker;
import java.util.List;
import org.json.JSONObject;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CircleTargetAI
implements AI,
GuidedMissileAI,
MissileAIPlugin {
    private Missile missile;
    private Vector2f targetPoint;
    private new target;
    private IntervalTracker targetCheckTracker = new IntervalTracker(0.5f, 1.0f);
    private float circleRadius;
    private float angledApproachRadius;
    private IntervalTracker pcoTracker = new IntervalTracker(1.0f, 3.0f);
    private float pursueCourseOffset;
    private boolean startedFinalApproach = false;

    public CircleTargetAI(Missile missile, Vector2f vector2f) {
        this.missile = missile;
        this.targetPoint = vector2f;
        Ship ship = missile.getSource().getShipTarget();
        this.target = ship;
        this.circleRadius = missile.getSpec().getBehaviorJSON() != null && missile.getSpec().getBehaviorJSON().has("circleRadius") ? DEMScript.getValue((JSONObject)missile.getSpec().getBehaviorJSON(), (String)"circleRadius", (float)1.0f) : 200.0f + (float)Math.random() * 100.0f;
        this.angledApproachRadius = missile.getSpec().getBehaviorJSON() != null && missile.getSpec().getBehaviorJSON().has("angledApproachDist") ? DEMScript.getValue((JSONObject)missile.getSpec().getBehaviorJSON(), (String)"angledApproachDist", (float)1.0f) : 400.0f + (float)Math.random() * 100.0f;
        this.updateCourseOffset();
    }

    private void updateCourseOffset() {
        float f2 = 15.0f;
        this.pursueCourseOffset = (f2 + f2 * (float)Math.random()) * Utils.o00000();
    }

    public void advance(float f2) {
        if (this.missile.isFizzling()) {
            return;
        }
        this.pcoTracker.advance(f2);
        if (this.pcoTracker.intervalElapsed()) {
            this.updateCourseOffset();
        }
        this.seekTarget();
        this.targetCheckTracker.advance(f2);
        if (this.targetCheckTracker.intervalElapsed() && !this.isTargetValid()) {
            this.acquireNewTarget();
            this.startedFinalApproach = false;
        }
    }

    private void seekTarget() {
        Ship ship;
        if (!this.isTargetValid()) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            return;
        }
        if (this.target instanceof Ship && ((Ship)this.target).isPhased()) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            return;
        }
        Vector2f vector2f = new Vector2f((ReadableVector2f)this.target.getLocation());
        float f2 = this.target.getCollisionRadius();
        if (this.target instanceof Ship) {
            ship = (Ship)this.target;
            vector2f = ship.getShieldCenterEvenIfNoShield();
            Vector2f vector2f2 = new Vector2f((ReadableVector2f)this.missile.getVelocity());
            vector2f2.scale(0.0f);
            Vector2f.add((Vector2f)vector2f2, (Vector2f)this.missile.getLocation(), (Vector2f)vector2f2);
            f2 = while.super(vector2f2, (new)ship, true);
        }
        ship = this.missile.getLocation();
        float f3 = Utils.\u00d800000((Vector2f)ship, vector2f);
        float f4 = f2 + this.circleRadius;
        float f5 = Utils.Object((Vector2f)ship, vector2f);
        float f6 = f2 + this.angledApproachRadius;
        float f7 = this.missile.getFacing();
        float f8 = -1.0f * Utils.\u00d200000(this.missile.getFacing(), f5);
        if (this.missile.getVelocity().length() >= 10.0f) {
            f8 = -1.0f * Utils.\u00d200000(Misc.getAngleInDegrees((Vector2f)this.missile.getVelocity()), f5);
        }
        if (f3 > f6) {
            f7 = f5 + this.pursueCourseOffset;
        } else if (f3 >= f4) {
            float f9 = f6 - f3;
            float f10 = f6 - f4;
            float f11 = f9 / f10;
            f7 = f5 + f11 * 90.0f * f8;
        } else {
            float f12 = f4 - f3;
            float f13 = this.circleRadius * 0.5f;
            float f14 = 1.0f - f12 / f13;
            if (f14 > 1.0f) {
                f14 = 1.0f;
            }
            f7 = f5 + 90.0f * f8;
        }
        while.super((float)this.missile, 0.0f, f7);
        this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
    }

    private void acquireNewTarget() {
        if (!this.isTargetValid()) {
            this.target = this.targetPoint != null ? while.super(this.targetPoint, this.missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP) : while.super(this.missile.getLocation(), this.missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
        }
    }

    private boolean isTargetValid() {
        if (this.target == null) {
            return false;
        }
        CombatEngine combatEngine = CombatEngine.getInstance();
        List list = combatEngine.getObjects().getList(new.class);
        if (this.target != null && this.target instanceof Ship && ((Ship)this.target).isHulk()) {
            return false;
        }
        return this.target != null && list.contains(this.target) && this.target.getOwner() != this.missile.getOwner();
    }

    public void render() {
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI combatEntityAPI) {
        this.target = (new)combatEntityAPI;
    }
}

