/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai.missile;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.ai.float;
import com.fs.starfarer.combat.ai.while;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.util.IntervalTracker;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class HeatseekerAI
implements AI,
GuidedMissileAI,
MissileAIPlugin {
    private Missile missile;
    private Vector2f targetPoint;
    private new target;
    private IntervalTracker targetCheckTracker = new IntervalTracker(0.5f, 1.0f);
    private float finalApproachOffset = 0.0f;
    private float radiusOffset = 0.0f;
    private IntervalTracker pcoTracker = new IntervalTracker(1.0f, 3.0f);
    private float pursueCourseOffset;
    private boolean startedFinalApproach = false;

    public HeatseekerAI(Missile missile, Vector2f vector2f) {
        this.missile = missile;
        this.targetPoint = vector2f;
        Ship ship = missile.getSource().getShipTarget();
        this.target = ship;
        float f2 = 0.0f;
        this.finalApproachOffset = (float)Math.random() * f2 - f2 / 2.0f;
        this.radiusOffset = (float)Math.random() * 100.0f;
        this.updateCourseOffset();
    }

    private void updateCourseOffset() {
        float f2 = 15.0f;
        this.pursueCourseOffset = (f2 + f2 * (float)Math.random()) * Utils.o00000();
    }

    public void advance(float f2) {
        if (this.missile.isFizzling()) {
            return;
        }
        this.pcoTracker.advance(f2);
        if (this.pcoTracker.intervalElapsed()) {
            this.updateCourseOffset();
        }
        this.seekTarget();
        this.targetCheckTracker.advance(f2);
        if (this.targetCheckTracker.intervalElapsed() && !this.isTargetValid()) {
            this.acquireNewTarget();
            this.startedFinalApproach = false;
        }
    }

    private void seekTarget() {
        float f2;
        if (!this.isTargetValid()) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            return;
        }
        if (this.target instanceof Ship && ((Ship)this.target).isPhased()) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            return;
        }
        Vector2f vector2f = new Vector2f((ReadableVector2f)this.target.getLocation());
        Vector2f vector2f2 = this.missile.getLocation();
        float f3 = Utils.\u00d800000(vector2f2, vector2f);
        float f4 = this.target.getCollisionRadius() + 225.0f + this.radiusOffset + 0.0f;
        float f5 = f4 - f3;
        float f6 = Utils.Object(vector2f2, vector2f);
        float f7 = this.target.getFacing();
        float f8 = Utils.Object(vector2f, vector2f2);
        float f9 = Utils.o00000(f7, f8);
        if (this.target instanceof Ship && ((Ship)this.target).getStationSlot() != null) {
            f9 = 180.0f;
        }
        if (f9 > 135.0f || this.startedFinalApproach || this.target instanceof Ship && ((Ship)this.target).isFighter()) {
            f2 = 0.0f + this.finalApproachOffset;
            float f10 = Math.min(1.0f, this.missile.getGuidanceBonus());
            vector2f = while.super((new)this.missile, this.target, this.missile.getMaxSpeed() * 0.5f * f10, false);
            this.startedFinalApproach = true;
        } else {
            f2 = Math.min((215.0f - f9) / 2.0f, 90.0f) + Math.min(Math.abs(f5) * 0.25f, 90.0f) * Math.signum(f5);
            f2 += this.pursueCourseOffset;
        }
        while.super((float)this.missile, 0.0f, f6 + (f2 *= -1.0f * Utils.o00000(this.missile.getFacing(), vector2f2, vector2f)));
        this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
    }

    private void acquireNewTarget() {
        if (!this.isTargetValid()) {
            this.target = this.targetPoint != null ? while.super(this.targetPoint, this.missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP) : while.super(this.missile.getLocation(), this.missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
        }
    }

    private boolean isTargetValid() {
        if (this.target == null) {
            return false;
        }
        CombatEngine combatEngine = CombatEngine.getInstance();
        List list = combatEngine.getObjects().getList(new.class);
        if (this.target != null && this.target instanceof Ship && ((Ship)this.target).isHulk()) {
            return false;
        }
        return this.target != null && list.contains(this.target) && this.target.getOwner() != this.missile.getOwner();
    }

    public void render() {
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI combatEntityAPI) {
        this.target = (new)combatEntityAPI;
    }
}

