/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.graphics.LayeredRenderable;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.E.D;
import com.fs.starfarer.combat.E.OOoO;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.entities.M;
import com.fs.starfarer.combat.entities.ship.G;
import com.fs.starfarer.combat.systems.H;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEntity
implements M,
new,
LayeredRenderable<CombatEngineLayers, CombatViewport> {
    private Vector2f loc = new Vector2f();
    private Vector2f vel = new Vector2f();
    private float radius;
    private float facing;
    private float angularVelocity;
    private float hitpoints;
    private float maxHitpoints;
    protected AI ai;
    private int owner;
    private D bounds = null;
    private CollisionClass collisionClass = CollisionClass.NONE;
    private boolean ghost = false;
    private float mass = 1.0f;
    private boolean wasRemoved = true;
    private Map<String, Object> customData = null;

    @Override
    public float getMass() {
        return this.mass;
    }

    public void setMass(float f2) {
        this.mass = f2;
    }

    @Override
    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    @Override
    public void setAngularVelocity(float f2) {
        this.angularVelocity = f2;
    }

    @Override
    public int getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(int n2) {
        this.owner = n2;
    }

    @Override
    public float getCollisionRadius() {
        return this.radius;
    }

    @Override
    public void setCollisionRadius(float f2) {
        this.radius = f2;
    }

    @Override
    public Vector2f getLocation() {
        return this.loc;
    }

    @Override
    public Vector2f getVelocity() {
        return this.vel;
    }

    public void setLoc(Vector2f vector2f) {
        this.loc = vector2f;
    }

    public void setVel(Vector2f vector2f) {
        this.vel = vector2f;
    }

    @Override
    public float getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(float f2) {
        this.facing = f2;
    }

    @Override
    public AI getAI() {
        return this.ai;
    }

    @Override
    public void setAI(AI aI) {
        this.ai = aI;
    }

    @Override
    public D getExactBounds() {
        return this.bounds;
    }

    public void setBounds(D d2) {
        this.bounds = d2;
    }

    @Override
    public H getShield() {
        return null;
    }

    @Override
    public void setCollisionClass(CollisionClass collisionClass) {
        this.collisionClass = collisionClass;
    }

    @Override
    public boolean isGhost() {
        return this.ghost;
    }

    @Override
    public void setGhost(boolean bl) {
        this.ghost = bl;
    }

    @Override
    public abstract void cleanup();

    @Override
    public abstract G applyDamage(Vector2f var1, OOoO var2, boolean var3, float var4, Object var5);

    @Override
    public abstract void init();

    public abstract EnumSet<CombatEngineLayers> getActiveLayers();

    public abstract void render(CombatEngineLayers var1, CombatViewport var2);

    @Override
    public abstract boolean isExpired();

    @Override
    public abstract void advance(float var1);

    @Override
    public CollisionClass getCollisionClass() {
        return this.collisionClass;
    }

    public float getMaxSpeed() {
        return Float.MAX_VALUE;
    }

    public float getHitpoints() {
        return this.hitpoints;
    }

    public float getHullLevel() {
        return this.hitpoints / this.maxHitpoints;
    }

    public void setHitpoints(float f2) {
        this.hitpoints = f2;
    }

    public float getMaxHitpoints() {
        return this.maxHitpoints;
    }

    public void setMaxHitpoints(float f2) {
        this.maxHitpoints = f2;
    }

    @Override
    public boolean canCauseInsideBoundsCollision() {
        return true;
    }

    @Override
    public boolean wasRemoved() {
        return this.wasRemoved;
    }

    @Override
    public void setWasRemoved(boolean bl) {
        this.wasRemoved = bl;
    }

    public void setCustomData(String string, Object object) {
        if (this.customData == null) {
            this.customData = new LinkedHashMap<String, Object>();
        }
        this.customData.put(string, object);
    }

    public void removeCustomData(String string) {
        if (this.customData != null) {
            this.customData.remove(string);
            if (this.customData.isEmpty()) {
                this.customData = null;
            }
        }
    }

    public Map<String, Object> getCustomData() {
        if (this.customData == null) {
            return new LinkedHashMap<String, Object>();
        }
        return this.customData;
    }

    @Override
    public void beforeCollidingWith(new new_) {
    }

    @Override
    public void afterCollidingWith(new new_, float f2) {
    }
}

