/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities.terrain;

import com.fs.graphics.C;
import com.fs.graphics.G;
import com.fs.graphics.LayeredRenderable;
import com.fs.graphics.Sprite;
import com.fs.graphics.util.B;
import com.fs.graphics.util.GLListManager;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.OOoO;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.PlanetSpec;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.EnumSet;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Planet
extends BaseEntity
implements OOoO,
LayeredRenderable<CombatEngineLayers, CombatViewport>,
Cloneable {
    private Sphere s;
    private C planetTex;
    private C cloudTex;
    private C shieldTex;
    private C shieldTex2;
    private C atmosphereTex;
    private C glowTex;
    private Color glowColor = new Color(255, 255, 255, 255);
    private Sprite haloSprite;
    private float radius;
    private float gravity;
    private String type;
    private Vector2f loc = new Vector2f();
    private Vector3f lightPos = new Vector3f();
    private PlanetSpec spec;
    private float angle = 0.0f;
    private float cloudAngle = 0.0f;
    private Vector3f lightSourceLocation = null;
    private float tilt;
    private float pitch;
    private GLListManager.GLListToken listToken1 = null;
    private GLListManager.GLListToken listToken2 = null;
    private GLListManager.GLListToken listToken3 = null;
    private GLListManager.GLListToken listToken4 = null;
    private GLListManager.GLListToken listToken5 = null;
    private float prevAlpha = -1.0f;
    private boolean backgroundPlanet = false;
    private transient FloatBuffer fb = BufferUtils.createFloatBuffer((int)4);
    private boolean renderingBackground = false;
    protected Color secondLightColor = null;
    protected Vector3f secondLightLocation = null;
    private Color lightColorOverride = null;
    private int detail = 32;
    private boolean additiveBlend = false;
    public static boolean noListsOnPlanetSurface = false;
    private float scale = 1.0f;

    public Planet clone() {
        try {
            Planet planet = (Planet)super.clone();
            planet.listToken1 = null;
            planet.listToken2 = null;
            planet.listToken3 = null;
            planet.prevAlpha = -1.0f;
            planet.loc = new Vector2f((ReadableVector2f)this.loc);
            planet.lightPos = new Vector3f((ReadableVector3f)this.lightPos);
            planet.haloSprite = this.haloSprite.clone();
            if (this.lightSourceLocation != null) {
                planet.lightSourceLocation = new Vector3f((ReadableVector3f)this.lightSourceLocation);
            }
            planet.lightColorOverride = this.lightColorOverride;
            planet.fb = null;
            planet.s = new Sphere();
            planet.s.setTextureFlag(true);
            return planet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Planet(String string, float f2, float f3, Vector2f vector2f) {
        this(SpecStore.super(PlanetSpec.class, string), f2, f3, vector2f);
        this.type = string;
    }

    public Planet(PlanetSpec planetSpec, float f2, float f3, Vector2f vector2f) {
        this.type = planetSpec.getPlanetType();
        this.radius = f2;
        this.gravity = f3;
        this.loc.set((ReadableVector2f)vector2f);
        this.spec = planetSpec;
        this.tilt = planetSpec.getTilt();
        this.pitch = planetSpec.getPitch();
        this.s = new Sphere();
        this.s.setTextureFlag(true);
        this.lightPos.set((ReadableVector3f)planetSpec.getLightPosition());
        this.planetTex = G.new((String)planetSpec.getTexture());
        this.cloudTex = planetSpec.getCloudTexture() != null ? G.new((String)planetSpec.getCloudTexture()) : null;
        this.shieldTex = planetSpec.getShieldTexture() != null ? G.new((String)planetSpec.getShieldTexture()) : null;
        this.shieldTex2 = planetSpec.getShieldTexture2() != null ? G.new((String)planetSpec.getShieldTexture2()) : null;
        this.atmosphereTex = StarfarerSettings.\u00d300000("planets", "atmosphere2");
        this.glowTex = planetSpec.getGlowTexture() != null ? G.new((String)planetSpec.getGlowTexture()) : null;
        this.glowColor = planetSpec.getGlowColor();
        this.haloSprite = new Sprite(planetSpec.getCoronaTexture());
        this.haloSprite.setColor(planetSpec.getAtmosphereColor());
        this.haloSprite.setBlendFunc(770, 1);
        this.isStar();
        this.setCollisionClass(CollisionClass.PLANET);
        this.setOwner(100);
    }

    public void setSpec(PlanetSpec planetSpec) {
        this.spec = planetSpec;
        GLListManager.invalidateList((GLListManager.GLListToken)this.listToken1);
        GLListManager.invalidateList((GLListManager.GLListToken)this.listToken2);
        GLListManager.invalidateList((GLListManager.GLListToken)this.listToken3);
        GLListManager.invalidateList((GLListManager.GLListToken)this.listToken4);
        GLListManager.invalidateList((GLListManager.GLListToken)this.listToken5);
        this.tilt = planetSpec.getTilt();
        this.pitch = planetSpec.getPitch();
        this.lightPos.set((ReadableVector3f)planetSpec.getLightPosition());
        this.planetTex = G.new((String)planetSpec.getTexture());
        this.cloudTex = planetSpec.getCloudTexture() != null ? G.new((String)planetSpec.getCloudTexture()) : null;
        this.shieldTex = planetSpec.getShieldTexture() != null ? G.new((String)planetSpec.getShieldTexture()) : null;
        this.shieldTex2 = planetSpec.getShieldTexture2() != null ? G.new((String)planetSpec.getShieldTexture2()) : null;
        this.glowTex = planetSpec.getGlowTexture() != null ? G.new((String)planetSpec.getGlowTexture()) : null;
        this.glowColor = planetSpec.getGlowColor();
        this.haloSprite = new Sprite(planetSpec.getCoronaTexture());
        this.haloSprite.setColor(planetSpec.getCoronaColor());
        this.haloSprite.setBlendFunc(770, 1);
    }

    public float getTilt() {
        return this.tilt;
    }

    public void setTilt(float f2) {
        this.tilt = f2;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float f2) {
        this.pitch = f2;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return EnumSet.of(CombatEngineLayers.PLANET_LAYER);
    }

    @Override
    public void init() {
    }

    public boolean isRenderingBackground() {
        return this.renderingBackground;
    }

    public void setRenderingBackground(boolean bl) {
        this.renderingBackground = bl;
    }

    @Override
    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport) {
        if (this.isBackgroundPlanet() && !this.renderingBackground) {
            return;
        }
        if (combatEngineLayers == CombatEngineLayers.PLANET_LAYER) {
            this.renderSphere(combatViewport);
        } else if (combatEngineLayers == CombatEngineLayers.ABOVE_SHIPS_LAYER) {
            this.renderStarGlow(combatViewport);
        }
    }

    public void renderStarGlow(CombatViewport combatViewport) {
        if (!this.spec.isStar()) {
            return;
        }
        float f2 = this.getHaloRadius() * this.scale;
        this.haloSprite.setColor(this.spec.getCoronaColor());
        this.haloSprite.setAlphaMult(combatViewport.getAlphaMult());
        if (this.isBackgroundPlanet()) {
            Vector2f vector2f = new Vector2f((ReadableVector2f)this.loc);
            vector2f.x += combatViewport.getLLX() + combatViewport.getVisibleWidth() / 2.0f;
            vector2f.y += combatViewport.getLLY() + combatViewport.getVisibleHeight() / 2.0f;
            if (!combatViewport.isNearViewport(vector2f, f2 + 50.0f)) {
                return;
            }
            if (f2 > this.radius * this.scale) {
                this.haloSprite.setSize(f2 * 2.0f, f2 * 2.0f);
                this.haloSprite.renderAtCenter(vector2f.x, vector2f.y);
            }
        } else {
            if (!combatViewport.isNearViewport(this.loc, f2 + 550.0f)) {
                return;
            }
            if (f2 > this.radius * this.scale) {
                this.haloSprite.setSize(f2 * 2.0f, f2 * 2.0f);
                this.haloSprite.renderAtCenter(this.loc.x, this.loc.y);
            }
        }
    }

    public float getHaloRadius() {
        float f2 = Math.max(this.radius * this.spec.getAtmosphereThickness(), this.spec.getAtmosphereThicknessMin()) + this.radius;
        if (this.spec.isStar()) {
            f2 = this.radius * this.spec.getCoronaSize();
        }
        return f2;
    }

    public void renderSphere(CombatViewport combatViewport) {
        float f2;
        float f3 = f2 = Math.max(this.radius * this.spec.getAtmosphereThickness(), this.spec.getAtmosphereThicknessMin()) * this.scale;
        float f4 = f2 * 0.4f;
        if (this.isBackgroundPlanet()) {
            boolean bl;
            Vector2f vector2f = new Vector2f((ReadableVector2f)this.loc);
            vector2f.x += combatViewport.getLLX() + combatViewport.getVisibleWidth() / 2.0f;
            vector2f.y += combatViewport.getLLY() + combatViewport.getVisibleHeight() / 2.0f;
            float f5 = f3;
            if (this.spec.isStar()) {
                f5 = this.getHaloRadius() * this.scale;
            }
            if (!combatViewport.isNearViewport(vector2f, this.radius * this.scale + f5)) {
                return;
            }
            this.render3d(vector2f, combatViewport.getAlphaMult());
            boolean bl2 = bl = this.spec.getAtmosphereThickness() > 0.0f;
            if (bl) {
                this.renderAtmosphere(vector2f.x, vector2f.y, this.radius * this.scale - f4, f3, combatViewport.getAlphaMult(), 64.0f, false);
                if (this.glowTex != null) {
                    this.renderAtmosphere(vector2f.x, vector2f.y, this.radius * this.scale - f4, f3, combatViewport.getAlphaMult(), 64.0f, true);
                }
            }
        } else {
            boolean bl;
            if (!combatViewport.isNearViewport(this.loc, this.radius * this.scale + f3)) {
                return;
            }
            this.render3d(this.loc, combatViewport.getAlphaMult());
            boolean bl3 = bl = this.spec.getAtmosphereThickness() > 0.0f;
            if (bl) {
                this.renderAtmosphere(this.loc.x, this.loc.y, this.radius * this.scale - f4, f3, combatViewport.getAlphaMult(), 64.0f, false);
                if (this.glowTex != null) {
                    this.renderAtmosphere(this.loc.x, this.loc.y, this.radius * this.scale - f4, f3, combatViewport.getAlphaMult(), 64.0f, true);
                }
            }
        }
    }

    public void setSecondLight(Vector3f vector3f, Color color) {
        this.secondLightColor = color;
        this.secondLightLocation = vector3f;
    }

    public void setLightSourceLocation(float f2, float f3, float f4) {
        if (this.lightSourceLocation == null) {
            this.lightSourceLocation = new Vector3f();
        }
        this.lightSourceLocation.set(f2, f3, f4);
    }

    public void resetLightLocation() {
        this.lightSourceLocation = null;
    }

    public void setLightColorOverride(Color color) {
        this.lightColorOverride = color;
    }

    public int getDetail() {
        return this.detail;
    }

    public void setDetail(int n2) {
        this.detail = n2;
    }

    public boolean isAdditiveBlend() {
        return this.additiveBlend;
    }

    public void setAdditiveBlend(boolean bl) {
        this.additiveBlend = bl;
    }

    private void render3d(Vector2f vector2f, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        Color color;
        if (this.planetTex == null) {
            return;
        }
        if (this.prevAlpha != f2) {
            this.prevAlpha = f2;
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken1);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken2);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken3);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken4);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken5);
        }
        if (this.fb == null) {
            this.fb = BufferUtils.createFloatBuffer((int)4);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        if (this.additiveBlend) {
            GL11.glBlendFunc((int)770, (int)1);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        B.new((Color)B.\u00d400000((Color)Color.white, (float)f2));
        if (!this.spec.isStar()) {
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            if (this.secondLightLocation != null) {
                GL11.glEnable((int)16385);
            }
            GL11.glColorMaterial((int)1032, (int)5634);
            GL11.glShadeModel((int)7425);
            this.fb.rewind();
            if (this.lightColorOverride == null) {
                this.fb.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f * f2});
            } else {
                this.fb.put(new float[]{1.0f * (float)this.lightColorOverride.getRed() / 255.0f, 1.0f * (float)this.lightColorOverride.getGreen() / 255.0f, 1.0f * (float)this.lightColorOverride.getBlue() / 255.0f, 1.0f * f2});
            }
            this.fb.flip();
            GL11.glLight((int)16384, (int)4609, (FloatBuffer)this.fb);
            this.fb.rewind();
            if (this.secondLightLocation != null) {
                this.fb.put(new float[]{1.0f * (float)this.secondLightColor.getRed() / 255.0f, 1.0f * (float)this.secondLightColor.getGreen() / 255.0f, 1.0f * (float)this.secondLightColor.getBlue() / 255.0f, 1.0f * (float)this.secondLightColor.getAlpha() / 255.0f * f2});
                this.fb.flip();
                GL11.glLight((int)16385, (int)4609, (FloatBuffer)this.fb);
                this.fb.rewind();
            }
            if (this.lightSourceLocation != null) {
                this.fb.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f * f2});
            } else {
                this.fb.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f * f2});
            }
            this.fb.flip();
            GL11.glLight((int)16384, (int)4608, (FloatBuffer)this.fb);
            this.fb.rewind();
            if (this.secondLightLocation != null) {
                this.fb.put(new float[]{1.0f * (float)this.secondLightColor.getRed() / 255.0f, 1.0f * (float)this.secondLightColor.getGreen() / 255.0f, 1.0f * (float)this.secondLightColor.getBlue() / 255.0f, 1.0f * (float)this.secondLightColor.getAlpha() / 255.0f * f2});
                this.fb.flip();
                GL11.glLight((int)16385, (int)4608, (FloatBuffer)this.fb);
                this.fb.rewind();
            }
            if (this.lightSourceLocation != null) {
                this.fb.put(new float[]{this.lightSourceLocation.x, this.lightSourceLocation.y, this.lightSourceLocation.z, 1.0f});
            } else {
                this.fb.put(new float[]{vector2f.x + this.lightPos.x * this.radius * this.scale, vector2f.y + this.lightPos.y * this.radius * this.scale, this.lightPos.z * this.radius * this.scale, 1.0f});
            }
            this.fb.flip();
            GL11.glLight((int)16384, (int)4611, (FloatBuffer)this.fb);
            this.fb.rewind();
            if (this.secondLightLocation != null) {
                this.fb.put(new float[]{this.secondLightLocation.x, this.secondLightLocation.y, this.secondLightLocation.z, 1.0f});
                this.fb.flip();
                GL11.glLight((int)16385, (int)4611, (FloatBuffer)this.fb);
                this.fb.rewind();
            }
        }
        GL11.glEnable((int)2884);
        GL11.glPushMatrix();
        boolean bl = false;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
        GL11.glRotatef((float)this.tilt, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.planetTex.\u00d800000();
        if (noListsOnPlanetSurface) {
            GLListManager.suspend = true;
        }
        if (!(bl = GLListManager.callList((GLListManager.GLListToken)this.listToken1))) {
            this.listToken1 = GLListManager.beginList();
            this.setMaterial(1.0f * f2);
            this.s.draw(this.radius * this.scale, this.detail, this.detail);
            this.setMaterial(0.37f * f2);
            this.s.draw(this.radius * this.scale + 0.25f, this.detail, this.detail);
            this.s.draw(this.radius * this.scale + 0.5f, this.detail, this.detail);
            GLListManager.endList();
        }
        if (noListsOnPlanetSurface) {
            GLListManager.suspend = false;
        }
        GL11.glPopMatrix();
        if (this.glowTex != null && !this.isStar()) {
            color = this.glowColor;
            GL11.glBlendFunc((int)770, (int)1);
            B.new((Color)color, (float)(f2 * 1.0f));
            f8 = (float)color.getRed() / 255.0f;
            f7 = (float)color.getGreen() / 255.0f;
            f6 = (float)color.getBlue() / 255.0f;
            f5 = (float)color.getAlpha() / 255.0f * f2;
            if (this.spec.isUseReverseLightForGlow()) {
                this.fb.rewind();
                this.fb.put(new float[]{0.0f, 0.0f, 0.0f, 1.0f * f2});
                this.fb.flip();
                GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)this.fb);
                this.fb.rewind();
                this.fb.put(new float[]{f8 * 1.0f, f7 * 1.0f, f6 * 1.0f, f5 * 1.0f});
                this.fb.flip();
                GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)this.fb);
                this.fb.rewind();
                if (this.lightSourceLocation != null) {
                    this.fb.put(new float[]{vector2f.x - (this.lightSourceLocation.x - vector2f.x), vector2f.y - (this.lightSourceLocation.y - vector2f.y), -this.lightSourceLocation.z * 0.75f, 1.0f});
                } else {
                    this.fb.put(new float[]{-(vector2f.x + this.lightPos.x * this.radius * this.scale), -(vector2f.y + this.lightPos.y * this.radius * this.scale), -(this.lightPos.z * this.radius * this.scale), 1.0f});
                }
                this.fb.flip();
                GL11.glLight((int)16384, (int)4611, (FloatBuffer)this.fb);
            } else {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)16384);
                GL11.glDisable((int)16385);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)50.0f);
            GL11.glRotatef((float)this.tilt, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.glowTex.\u00d800000();
            bl = GLListManager.callList((GLListManager.GLListToken)this.listToken3);
            if (!bl) {
                if (this.spec.isUseReverseLightForGlow()) {
                    this.listToken3 = GLListManager.beginList();
                    this.s.draw(this.radius * this.scale, this.detail, this.detail);
                    this.s.draw(this.radius * this.scale, this.detail, this.detail);
                    GLListManager.endList();
                } else {
                    this.listToken3 = GLListManager.beginList();
                    this.s.draw(this.radius * this.scale, this.detail, this.detail);
                    GLListManager.endList();
                }
            }
            if (!this.spec.isUseReverseLightForGlow()) {
                GL11.glEnable((int)2896);
                GL11.glEnable((int)16384);
                if (this.secondLightLocation != null) {
                    GL11.glEnable((int)16385);
                }
            }
            GL11.glPopMatrix();
        }
        this.fb.rewind();
        this.fb.put(new float[]{0.0f, 0.0f, 0.0f, 1.0f * f2});
        this.fb.flip();
        GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)this.fb);
        this.fb.rewind();
        this.fb.put(new float[]{0.0f, 0.0f, 0.0f, 1.0f * f2});
        this.fb.flip();
        GL11.glMaterial((int)1028, (int)5632, (FloatBuffer)this.fb);
        if (this.cloudTex != null) {
            color = this.spec.getCloudColor();
            GL11.glBlendFunc((int)770, (int)771);
            B.new((Color)B.\u00d400000((Color)Color.white, (float)f2));
            if (this.isStar()) {
                GL11.glBlendFunc((int)770, (int)1);
                B.new((Color)color, (float)f2);
            } else {
                f8 = (float)color.getRed() / 255.0f;
                f7 = (float)color.getGreen() / 255.0f;
                f6 = (float)color.getBlue() / 255.0f;
                f5 = (float)color.getAlpha() / 255.0f * f2;
                this.fb.rewind();
                this.fb.put(new float[]{f8 * 0.2f, f7 * 0.2f, f6 * 0.2f, f5 * 1.0f});
                this.fb.flip();
                GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)this.fb);
                this.fb.rewind();
                this.fb.put(new float[]{f8 * 1.0f, f7 * 1.0f, f6 * 1.0f, f5 * 1.0f});
                this.fb.flip();
                GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)this.fb);
            }
            this.fb.rewind();
            if (this.lightSourceLocation != null) {
                this.fb.put(new float[]{this.lightSourceLocation.x, this.lightSourceLocation.y, this.lightSourceLocation.z, 1.0f});
            } else {
                this.fb.put(new float[]{vector2f.x + this.lightPos.x * this.radius * this.scale, vector2f.y + this.lightPos.y * this.radius * this.scale, this.lightPos.z * this.radius * this.scale, 1.0f});
            }
            this.fb.flip();
            GL11.glLight((int)16384, (int)4611, (FloatBuffer)this.fb);
            if (this.secondLightLocation != null) {
                this.fb.rewind();
                this.fb.put(new float[]{this.secondLightLocation.x, this.secondLightLocation.y, this.secondLightLocation.z, 1.0f});
                this.fb.flip();
                GL11.glLight((int)16385, (int)4611, (FloatBuffer)this.fb);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            GL11.glRotatef((float)this.tilt, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.cloudAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.cloudTex.\u00d800000();
            bl = GLListManager.callList((GLListManager.GLListToken)this.listToken2);
            if (!bl) {
                this.listToken2 = GLListManager.beginList();
                this.s.draw(this.radius * this.scale, this.detail, this.detail);
                GLListManager.endList();
            }
            GL11.glPopMatrix();
        }
        if (this.shieldTex != null) {
            color = this.spec.getShieldColor();
            if (color == null) {
                color = Color.white;
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBlendFunc((int)770, (int)1);
            B.new((Color)B.\u00d400000((Color)Color.white, (float)f2));
            f8 = (float)color.getRed() / 255.0f;
            f7 = (float)color.getGreen() / 255.0f;
            f6 = (float)color.getBlue() / 255.0f;
            f5 = (float)color.getAlpha() / 255.0f * f2;
            this.fb.rewind();
            f4 = 0.2f;
            f3 = 1.0f;
            this.fb.put(new float[]{f8 * f4, f7 * f4, f6 * f4, f5 * 1.0f});
            this.fb.flip();
            GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)this.fb);
            this.fb.rewind();
            this.fb.put(new float[]{f8 * f3, f7 * f3, f6 * f3, f5 * 1.0f});
            this.fb.flip();
            GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)this.fb);
            this.fb.rewind();
            this.fb.put(new float[]{vector2f.x, vector2f.y, this.radius * 100.0f, 1.0f});
            this.fb.flip();
            GL11.glLight((int)16384, (int)4611, (FloatBuffer)this.fb);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            GL11.glRotatef((float)this.tilt, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.shieldTex.\u00d800000();
            bl = GLListManager.callList((GLListManager.GLListToken)this.listToken4);
            if (!bl) {
                this.listToken4 = GLListManager.beginList();
                this.s.draw(this.radius * this.scale * (1.0f + this.spec.getShieldThickness()), this.detail, this.detail);
                GLListManager.endList();
            }
            GL11.glPopMatrix();
        }
        if (this.shieldTex2 != null) {
            color = this.spec.getShieldColor2();
            if (color == null) {
                color = Color.white;
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBlendFunc((int)770, (int)1);
            B.new((Color)B.\u00d400000((Color)Color.white, (float)f2));
            f8 = (float)color.getRed() / 255.0f;
            f7 = (float)color.getGreen() / 255.0f;
            f6 = (float)color.getBlue() / 255.0f;
            f5 = (float)color.getAlpha() / 255.0f * f2;
            this.fb.rewind();
            f4 = 0.2f;
            f3 = 1.0f;
            this.fb.put(new float[]{f8 * f4, f7 * f4, f6 * f4, f5 * 1.0f});
            this.fb.flip();
            GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)this.fb);
            this.fb.rewind();
            this.fb.put(new float[]{f8 * f3, f7 * f3, f6 * f3, f5 * 1.0f});
            this.fb.flip();
            GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)this.fb);
            this.fb.rewind();
            this.fb.put(new float[]{vector2f.x, vector2f.y, this.radius * 100.0f, 1.0f});
            this.fb.flip();
            GL11.glLight((int)16384, (int)4611, (FloatBuffer)this.fb);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            GL11.glRotatef((float)this.tilt, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.shieldTex2.\u00d800000();
            bl = GLListManager.callList((GLListManager.GLListToken)this.listToken5);
            if (!bl) {
                this.listToken5 = GLListManager.beginList();
                this.s.draw(this.radius * this.scale * (1.0f + this.spec.getShieldThickness2()), this.detail, this.detail);
                GLListManager.endList();
            }
            GL11.glPopMatrix();
        }
        this.fb.rewind();
        this.fb.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        this.fb.flip();
        GL11.glMaterial((int)1028, (int)5632, (FloatBuffer)this.fb);
        this.fb.rewind();
        this.fb.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        this.fb.flip();
        GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)this.fb);
        this.fb.rewind();
        this.fb.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        this.fb.flip();
        GL11.glMaterial((int)1028, (int)5633, (FloatBuffer)this.fb);
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
    }

    private void setMaterial(float f2) {
        if (!this.spec.isStar()) {
            if (this.fb == null) {
                this.fb = BufferUtils.createFloatBuffer((int)4);
            }
            Color color = this.spec.getPlanetColor();
            float f3 = (float)color.getRed() / 255.0f;
            float f4 = (float)color.getGreen() / 255.0f;
            float f5 = (float)color.getBlue() / 255.0f;
            float f6 = (float)color.getAlpha() / 255.0f;
            this.fb.rewind();
            this.fb.put(new float[]{f3 * 0.2f, f4 * 0.2f, f5 * 0.2f, f6 * f2});
            this.fb.flip();
            GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)this.fb);
            this.fb.rewind();
            this.fb.put(new float[]{f3 * 1.0f, f4 * 1.0f, f5 * 1.0f, f6 * f2});
            this.fb.flip();
            GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)this.fb);
        } else {
            B.new((Color)this.spec.getPlanetColor(), (float)f2);
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f2) {
        if (this.scale != f2) {
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken1);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken2);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken3);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken4);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken5);
        }
        this.scale = f2;
    }

    private void renderAtmosphere(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl) {
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        if (bl) {
            f6 *= 0.2f;
        }
        float f20 = (float)Math.toRadians(0.0);
        float f21 = (float)Math.toRadians(360.0);
        float f22 = Utils.o00000(f21 - f20);
        float f23 = f22 / f7;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        this.atmosphereTex.\u00d800000();
        GL11.glEnable((int)3042);
        if (this.spec.isStar()) {
            GL11.glBlendFunc((int)770, (int)1);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        Color color = this.spec.getAtmosphereColor();
        if (bl) {
            color = this.glowColor;
        }
        if (this.lightColorOverride != null && !this.isStar()) {
            f19 = this.lightColorOverride.getRed();
            f18 = this.lightColorOverride.getGreen();
            f17 = this.lightColorOverride.getBlue();
            f16 = this.lightColorOverride.getAlpha();
            f15 = 255.0f - f19 + (255.0f - f18) + (255.0f - f17) + (255.0f - f16);
            f14 = 0.299f * f19 + 0.587f * f18 + 0.114f * f17;
            if ((f14 /= 255.0f) > 1.0f) {
                f14 = 1.0f;
            }
            if ((f15 /= 765.0f) > 1.0f) {
                f15 = 1.0f;
            }
            if (f15 > 0.0f) {
                color = B.o00000((Color)color, (Color)this.lightColorOverride, (float)(0.8f * f15));
                color = B.class((Color)color, (float)f14);
                color = B.new((Color)color, (int)((int)(255.0f * f16)));
            }
        }
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * f6)));
        f19 = 0.0f;
        f18 = 0.0f;
        if (this.lightSourceLocation != null && !this.isStar()) {
            Vector2f vector2f = new Vector2f(this.lightSourceLocation.x, this.lightSourceLocation.y);
            f16 = Utils.o00000(new Vector3f(this.loc.x, this.loc.y, 0.0f), this.lightSourceLocation);
            f15 = Utils.\u00d800000(this.loc, vector2f);
            f18 = f15 / f16;
            f19 = Utils.\u00d500000(this.loc, vector2f);
        }
        if (bl) {
            f19 = Utils.o00000(f19 + 180.0f);
        }
        GL11.glBegin((int)8);
        f17 = 0.0f;
        while (f17 < f7) {
            f16 = f23 * f17;
            f15 = (float)Math.cos(f16);
            f14 = (float)Math.sin(f16);
            f13 = f15 * f4;
            f12 = f14 * f4;
            f11 = f15 * (f4 + f5);
            f10 = f14 * (f4 + f5);
            if (this.lightSourceLocation != null) {
                f9 = 1.0f - Utils.o00000((float)Math.toDegrees(f16), f19) / 180.0f;
                f9 = bl ? (float)Math.pow(f9, 2.0) : (float)Math.pow(f9, 1.5);
                f8 = 1.0f - f18 + f18 * f9;
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * f6 * f8)));
            }
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)f13, (float)f12);
            GL11.glTexCoord2f((float)0.0f, (float)0.99f);
            GL11.glVertex2f((float)f11, (float)f10);
            f17 += 1.0f;
        }
        boolean bl2 = false;
        f16 = f23 * (float)bl2;
        f15 = (float)Math.cos(f16);
        f14 = (float)Math.sin(f16);
        f13 = f15 * f4;
        f12 = f14 * f4;
        f11 = f15 * (f4 + f5);
        f10 = f14 * (f4 + f5);
        if (this.lightSourceLocation != null) {
            f9 = 1.0f - Utils.o00000((float)Math.toDegrees(f16), f19) / 180.0f;
            f9 = (float)Math.pow(f9, 1.5);
            f8 = 1.0f - f18 + f18 * f9;
            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * f6 * f8)));
        }
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)f13, (float)f12);
        GL11.glTexCoord2f((float)0.0f, (float)0.99f);
        GL11.glVertex2f((float)f11, (float)f10);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public float getGravityBonus(Ship ship) {
        if (this.backgroundPlanet) {
            return 0.0f;
        }
        float f2 = this.radius + 500.0f;
        float f3 = 0.0f;
        float f4 = f2 - f3;
        float f5 = Utils.\u00d800000(this.loc, ship.getLocation());
        float f6 = 1.0f;
        if (f5 > f2) {
            return 0.0f;
        }
        f6 = f5 < f3 ? f5 / f3 * 0.5f : 1.0f - (f5 -= f3) / f4;
        float f7 = this.gravity * f6 * this.getGravityModifier(ship);
        return f7;
    }

    private float getGravityModifier(Ship ship) {
        switch (ship.getHullSize()) {
            case FIGHTER: {
                return 1.0f;
            }
            case FRIGATE: {
                return 1.0f;
            }
            case DESTROYER: {
                return 0.8f;
            }
            case CRUISER: {
                return 0.6f;
            }
            case CAPITAL_SHIP: {
                return 0.4f;
            }
        }
        return 1.0f;
    }

    public boolean isStar() {
        return this.spec.isStar();
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public void advance(float f2) {
        float f3 = this.spec.getRotation();
        this.angle += f3 * f2;
        f3 = this.spec.getCloudRotation();
        this.cloudAngle += f3 * f2;
        this.angle = Utils.o00000(this.angle);
        this.cloudAngle = Utils.o00000(this.cloudAngle);
    }

    @Override
    public com.fs.starfarer.combat.entities.ship.G applyDamage(Vector2f vector2f, com.fs.starfarer.combat.E.OOoO oOoO2, boolean bl, float f2, Object object) {
        return new com.fs.starfarer.combat.entities.ship.G();
    }

    @Override
    public AI getAI() {
        return null;
    }

    @Override
    public boolean isGhost() {
        return false;
    }

    @Override
    public void setAI(AI aI) {
    }

    @Override
    public void setGhost(boolean bl) {
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f2) {
        if (this.radius != f2) {
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken1);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken2);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken3);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken4);
            GLListManager.invalidateList((GLListManager.GLListToken)this.listToken5);
        }
        this.radius = f2;
    }

    public float getGravity() {
        return this.gravity;
    }

    @Override
    public Vector2f getLocation() {
        return this.loc;
    }

    public String getType() {
        return this.type;
    }

    public PlanetSpec getSpec() {
        return this.spec;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getCloudAngle() {
        return this.cloudAngle;
    }

    public void setCloudAngle(float f2) {
        this.cloudAngle = f2;
    }

    @Override
    public Ship getSource() {
        return null;
    }

    @Override
    public com.fs.starfarer.combat.E.OOoO getDamage(Vector2f vector2f, new new_) {
        float f2 = this.radius + 500.0f;
        float f3 = this.radius + 500.0f;
        if (vector2f != null) {
            f3 = Utils.\u00d800000(this.loc, vector2f);
        }
        float f4 = 1.0f;
        f4 = f3 > f2 ? 0.0f : 1.0f - f3 / f2;
        com.fs.starfarer.combat.E.OOoO oOoO2 = new com.fs.starfarer.combat.E.OOoO(f4 * this.gravity, true, DamageType.ENERGY);
        return oOoO2;
    }

    @Override
    public boolean isDestroyedByCollision(new new_) {
        return false;
    }

    @Override
    public OOoO.o notifyDealtDamage(Vector2f vector2f, com.fs.starfarer.combat.entities.ship.G g2, new new_) {
        return OOoO.o.\u00d200000;
    }

    public boolean isBackgroundPlanet() {
        return this.backgroundPlanet;
    }

    public void setBackgroundPlanet(boolean bl) {
        this.backgroundPlanet = bl;
        if (this.backgroundPlanet) {
            this.setCollisionClass(CollisionClass.PLANET);
        }
    }

    public boolean isGasGiant() {
        return this.spec.isGasGiant();
    }

    @Override
    public boolean isFromMissile() {
        return false;
    }

    @Override
    public WeaponAPI getWeapon() {
        return null;
    }
}

