/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.renderers;

import com.fs.graphics.Sprite;
import com.fs.starfarer.api.util.Misc;
import com.fs.util.DoNotObfuscate;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class JitterRenderer
implements DoNotObfuscate {
    private long seed = Misc.genRandomSeed();
    private Random random = new Random(this.seed);
    private boolean setSeedOnRender = true;
    private boolean circular;

    public static void renderWithJitter(Sprite sprite, float f2, float f3, float f4, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            Vector2f vector2f = new Vector2f();
            vector2f.x = (float)Math.random() * f4 - f4 / 2.0f;
            vector2f.y = (float)Math.random() * f4 - f4 / 2.0f;
            sprite.renderAtCenter(f2 + vector2f.x, f3 + vector2f.y);
            ++n3;
        }
    }

    public void updateSeed() {
        this.seed = Misc.genRandomSeed();
    }

    public Random getRandom() {
        this.random.setSeed(this.seed);
        return this.random;
    }

    public void render(Sprite sprite, float f2, float f3, float f4, int n2) {
        this.render(sprite, f2, f3, 0.0f, f4, n2);
    }

    public boolean isSetSeedOnRender() {
        return this.setSeedOnRender;
    }

    public void setSetSeedOnRender(boolean bl) {
        this.setSeedOnRender = bl;
    }

    public void setUseCircularJitter(boolean bl) {
        this.circular = bl;
    }

    public void render(Sprite sprite, float f2, float f3, float f4, float f5, int n2) {
        if (this.setSeedOnRender) {
            this.random.setSeed(this.seed);
        }
        int n3 = 0;
        while (n3 < n2) {
            Vector2f vector2f = new Vector2f();
            if (this.circular) {
                float f6 = f4 + (f5 - f4) * this.random.nextFloat();
                vector2f = Misc.getPointAtRadius((Vector2f)vector2f, (float)f6, (Random)this.random);
            } else if (f4 <= 0.0f) {
                vector2f.x = this.random.nextFloat() * f5 - f5 / 2.0f;
                vector2f.y = this.random.nextFloat() * f5 - f5 / 2.0f;
            } else {
                vector2f.x = this.random.nextFloat() * (f5 - f4) + f4;
                vector2f.y = this.random.nextFloat() * (f5 - f4) + f4;
                if (vector2f.x < f4) {
                    vector2f.x = f4;
                }
                if (vector2f.y < f4) {
                    vector2f.y = f4;
                }
                vector2f.x *= Math.signum(this.random.nextFloat() - 0.5f);
                vector2f.y *= Math.signum(this.random.nextFloat() - 0.5f);
            }
            sprite.renderAtCenter(f2 + vector2f.x, f3 + vector2f.y);
            ++n3;
        }
    }
}

