/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.combat.HullModEffect;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModSpecItemPlugin
extends BaseSpecialItemPlugin {
    private String modId;
    private HullModSpecAPI modSpec;

    public void init(CargoStackAPI stack) {
        super.init(stack);
        this.modId = stack.getSpecialDataIfSpecial().getData();
        this.modSpec = Global.getSettings().getHullModSpec(this.modId);
    }

    public void render(float x, float y, float w, float h, float alphaMult, float glowMult, SpecialItemPlugin.SpecialItemRendererAPI renderer) {
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        cx -= 2.0f;
        cy -= 1.0f;
        x = (int)x;
        y = (int)y;
        w = (int)w;
        h = (int)h;
        boolean known = Global.getSector().getCharacterData().knowsHullMod(this.modId);
        float mult = 1.0f;
        if (known) {
            mult = 0.5f;
        }
        SpriteAPI sprite = Global.getSettings().getSprite(this.modSpec.getSpriteName());
        w = sprite.getWidth() * 1.5f + 5.0f;
        h = sprite.getHeight() * 1.5f;
        x = cx;
        y = cy;
        float blX = -23.0f;
        float blY = -10.0f;
        float tlX = -18.0f;
        float tlY = 24.0f;
        float trX = 24.0f;
        float trY = 24.0f;
        float brX = 23.0f;
        float brY = -10.0f;
        sprite.setAlphaMult(alphaMult * mult);
        sprite.setNormalBlend();
        sprite.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
        if (glowMult > 0.0f) {
            sprite.setAlphaMult(alphaMult * glowMult * 0.5f * mult);
            sprite.setAdditiveBlend();
            sprite.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
        }
        renderer.renderScanlinesWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult, false);
        if (!known) {
            renderer.renderSchematicWithCorners(sprite, null, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * 0.67f);
        }
    }

    public int getPrice(MarketAPI market, SubmarketAPI submarket) {
        if (this.modSpec != null) {
            return (int)this.modSpec.getBaseValue();
        }
        return super.getPrice(market, submarket);
    }

    public String getName() {
        return String.valueOf(this.modSpec.getDisplayName()) + " - Modspec";
    }

    public String getDesignType() {
        if (this.modSpec != null) {
            return this.modSpec.getManufacturer();
        }
        return null;
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        tooltip.addTitle(this.getName());
        String design = this.getDesignType();
        Misc.addDesignTypePara(tooltip, design, 10.0f);
        if (!this.spec.getDesc().isEmpty()) {
            tooltip.addPara(this.spec.getDesc(), Misc.getGrayColor(), opad);
        }
        tooltip.addSectionHeading("Effect", Alignment.MID, opad * 1.0f);
        HullModEffect e = this.modSpec.getEffect();
        ShipAPI.HullSize size = ShipAPI.HullSize.CAPITAL_SHIP;
        if (e.shouldAddDescriptionToTooltip(size, null, true)) {
            String[] params = new String[]{e.getDescriptionParam(0, size, null), e.getDescriptionParam(1, size, null), e.getDescriptionParam(2, size, null), e.getDescriptionParam(3, size, null), e.getDescriptionParam(4, size, null), e.getDescriptionParam(5, size, null), e.getDescriptionParam(6, size, null), e.getDescriptionParam(7, size, null), e.getDescriptionParam(8, size, null), e.getDescriptionParam(9, size, null)};
            tooltip.addPara(this.modSpec.getDescription(size).replaceAll("\\%", "%%"), opad, h, params);
        }
        e.addPostDescriptionSection(tooltip, size, null, this.getTooltipWidth(), true);
        if (e.hasSModEffectSection(size, null, false)) {
            e.addSModSection(tooltip, size, null, this.getTooltipWidth(), true, false);
        }
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        boolean known = Global.getSector().getCharacterData().knowsHullMod(this.modId);
        if (known) {
            tooltip.addPara("Already known", g, opad);
        } else {
            tooltip.addPara("Right-click to learn", b, opad);
        }
    }

    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    public boolean isTooltipExpandable() {
        return false;
    }

    public boolean hasRightClickAction() {
        return true;
    }

    public boolean shouldRemoveOnRightClickAction() {
        return !Global.getSector().getCharacterData().knowsHullMod(this.modId);
    }

    public void performRightClickAction() {
        if (Global.getSector().getCharacterData().knowsHullMod(this.modId)) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.modSpec.getDisplayName() + ": already known");
        } else {
            Global.getSoundPlayer().playUISound("ui_acquired_hullmod", 1.0f, 1.0f);
            Global.getSector().getCharacterData().addHullMod(this.modId);
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage("Acquired hull mod: " + this.modSpec.getDisplayName());
        }
    }

    public String resolveDropParamsToSpecificItemData(String params, Random random) throws JSONException {
        HullModSpecAPI curr;
        if (params == null || params.isEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject(params);
        int tier = json.optInt("tier", -1);
        HashSet<String> tags = new HashSet<String>();
        if (json.has("tags")) {
            JSONArray tagsArray = json.getJSONArray("tags");
            int i = 0;
            while (i < tagsArray.length()) {
                tags.add(tagsArray.getString(i));
                ++i;
            }
        }
        List<HullModSpecAPI> specs = Global.getSettings().getAllHullModSpecs();
        Iterator<HullModSpecAPI> iter = specs.iterator();
        while (iter.hasNext()) {
            curr = iter.next();
            boolean known = Global.getSector().getPlayerFaction().knowsHullMod(curr.getId());
            if (DebugFlags.ALLOW_KNOWN_HULLMOD_DROPS) {
                known = false;
            }
            if (!known && !curr.isHidden() && !curr.isHiddenEverywhere() && !curr.hasTag("no_drop")) continue;
            iter.remove();
        }
        if (tier >= 0) {
            iter = specs.iterator();
            while (iter.hasNext()) {
                curr = iter.next();
                if (curr.getTier() == tier) continue;
                iter.remove();
            }
        }
        if (!tags.isEmpty()) {
            iter = specs.iterator();
            block3: while (iter.hasNext()) {
                curr = iter.next();
                for (String tag : tags) {
                    boolean not;
                    tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                    boolean has = curr.hasTag(tag);
                    if (not != has) continue;
                    iter.remove();
                    continue block3;
                }
            }
        }
        WeightedRandomPicker<HullModSpecAPI> picker = new WeightedRandomPicker<HullModSpecAPI>(random);
        for (HullModSpecAPI spec : specs) {
            picker.add(spec, 1.0f * spec.getRarity());
        }
        HullModSpecAPI pick = (HullModSpecAPI)picker.pick();
        if (pick == null) {
            return null;
        }
        return pick.getId();
    }

    public String getModId() {
        return this.modId;
    }
}

