/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBlueprintItemPlugin
extends BaseSpecialItemPlugin
implements BlueprintProviderItem {
    protected Set<String> tags = new LinkedHashSet<String>();
    protected transient List<String> cachedFighters = null;
    protected transient List<String> cachedShips = null;
    protected transient List<String> cachedWeapons = null;

    @Override
    public void init(CargoStackAPI stack) {
        super.init(stack);
        String param = this.spec.getParams();
        if (!param.isEmpty()) {
            String[] stringArray = param.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.tags.add(tag);
                }
                ++n2;
            }
        }
    }

    @Override
    public List<String> getProvidedFighters() {
        if (this.cachedFighters == null) {
            this.cachedFighters = MultiBlueprintItemPlugin.getWingIds(this.tags);
        }
        return this.cachedFighters;
    }

    @Override
    public List<String> getProvidedShips() {
        if (this.cachedShips == null) {
            this.cachedShips = MultiBlueprintItemPlugin.getShipIds(this.tags);
        }
        return this.cachedShips;
    }

    @Override
    public List<String> getProvidedWeapons() {
        if (this.cachedWeapons == null) {
            this.cachedWeapons = MultiBlueprintItemPlugin.getWeaponIds(this.tags);
        }
        return this.cachedWeapons;
    }

    @Override
    public List<String> getProvidedIndustries() {
        return null;
    }

    @Override
    public void render(float x, float y, float w, float h, float alphaMult, float glowMult, SpecialItemPlugin.SpecialItemRendererAPI renderer) {
        SpriteAPI sprite = Global.getSettings().getSprite("blueprint_packages", this.getId(), true);
        if (sprite.getTextureId() == 0) {
            return;
        }
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        w = 40.0f;
        h = 40.0f;
        float p = 1.0f;
        float blX = cx - 12.0f - p;
        float blY = cy - 22.0f - p;
        float tlX = cx - 26.0f - p;
        float tlY = cy + 19.0f + p;
        float trX = cx + 20.0f + p;
        float trY = cy + 24.0f + p;
        float brX = cx + 34.0f + p;
        float brY = cy - 9.0f - p;
        List<String> ships = this.getProvidedShips();
        List<String> weapons = this.getProvidedWeapons();
        List<String> fighters = this.getProvidedFighters();
        boolean known = this.areAllKnown(ships, weapons, fighters);
        float mult = 1.0f;
        sprite.setAlphaMult(alphaMult * mult);
        sprite.setNormalBlend();
        sprite.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
        if (glowMult > 0.0f) {
            sprite.setAlphaMult(alphaMult * glowMult * 0.5f * mult);
            sprite.setAdditiveBlend();
            sprite.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
        }
        if (known) {
            renderer.renderBGWithCorners(Color.black, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * 0.5f, 0.0f, false);
        }
        renderer.renderScanlinesWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult, false);
    }

    @Override
    public int getPrice(MarketAPI market, SubmarketAPI submarket) {
        return super.getPrice(market, submarket);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getDesignType() {
        return null;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        super.createTooltip(tooltip, expanded, transferHandler, stackSource);
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        List<String> ships = this.getProvidedShips();
        List<String> weapons = this.getProvidedWeapons();
        List<String> fighters = this.getProvidedFighters();
        float maxTotal = 21.0f;
        int minPer = 3;
        float shipWeight = 0.0f;
        float weaponWeight = 0.0f;
        float fighterWeight = 0.0f;
        FactionAPI pf = Global.getSector().getPlayerFaction();
        float knownWeight = 0.25f;
        for (String id : ships) {
            if (pf.knowsShip(id)) {
                shipWeight += knownWeight;
                continue;
            }
            shipWeight += 1.0f;
        }
        for (String id : weapons) {
            if (pf.knowsWeapon(id)) {
                weaponWeight += knownWeight;
                continue;
            }
            weaponWeight += 1.0f;
        }
        for (String id : fighters) {
            if (pf.knowsFighter(id)) {
                fighterWeight += knownWeight;
                continue;
            }
            fighterWeight += 1.0f;
        }
        float totalWeight = shipWeight + weaponWeight + fighterWeight;
        if (totalWeight < knownWeight) {
            totalWeight = knownWeight;
        }
        int maxShips = (int)Math.max((float)minPer, shipWeight / totalWeight * maxTotal);
        int maxWeapons = (int)Math.max((float)minPer, weaponWeight / totalWeight * maxTotal);
        int maxFighters = (int)Math.max((float)minPer, fighterWeight / totalWeight * maxTotal);
        if (!ships.isEmpty()) {
            this.addShipList(tooltip, "Ship hulls:", ships, maxShips, opad);
        }
        if (!weapons.isEmpty()) {
            this.addWeaponList(tooltip, "Weapons:", weapons, maxWeapons, opad);
        }
        if (!fighters.isEmpty()) {
            this.addFighterList(tooltip, "Fighters:", fighters, maxFighters, opad);
        }
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        boolean known = this.areAllKnown(ships, weapons, fighters);
        if (known) {
            tooltip.addPara("All blueprints in package already known", g, opad);
        } else {
            tooltip.addPara("Right-click to learn", b, opad);
        }
    }

    protected boolean areAllKnown(List<String> ships, List<String> weapons, List<String> fighters) {
        for (String hullId : ships) {
            if (Global.getSector().getPlayerFaction().knowsShip(hullId)) continue;
            return false;
        }
        for (String weaponId : weapons) {
            if (Global.getSector().getPlayerFaction().knowsWeapon(weaponId)) continue;
            return false;
        }
        for (String wingId : fighters) {
            if (Global.getSector().getPlayerFaction().knowsFighter(wingId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public boolean hasRightClickAction() {
        return true;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        List<String> fighters;
        List<String> weapons;
        List<String> ships = this.getProvidedShips();
        return !this.areAllKnown(ships, weapons = this.getProvidedWeapons(), fighters = this.getProvidedFighters());
    }

    @Override
    public void performRightClickAction() {
        List<String> fighters;
        List<String> weapons;
        List<String> ships = this.getProvidedShips();
        if (this.areAllKnown(ships, weapons = this.getProvidedWeapons(), fighters = this.getProvidedFighters())) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage("All blueprints in package already known");
        } else {
            Global.getSoundPlayer().playUISound("ui_acquired_blueprint", 1.0f, 1.0f);
            FactionAPI pf = Global.getSector().getPlayerFaction();
            int sCount = 0;
            int wCount = 0;
            int fCount = 0;
            for (String id : ships) {
                if (!pf.knowsShip(id)) {
                    ++sCount;
                }
                pf.addKnownShip(id, true);
            }
            for (String id : weapons) {
                if (!pf.knowsWeapon(id)) {
                    ++wCount;
                }
                pf.addKnownWeapon(id, true);
            }
            for (String id : fighters) {
                if (!pf.knowsFighter(id)) {
                    ++fCount;
                }
                pf.addKnownFighter(id, true);
            }
            if (sCount > 0) {
                Global.getSector().getCampaignUI().getMessageDisplay().addMessage("Acquired " + sCount + " ship blueprints", Misc.getTooltipTitleAndLightHighlightColor(), "" + sCount, Misc.getHighlightColor());
            }
            if (wCount > 0) {
                Global.getSector().getCampaignUI().getMessageDisplay().addMessage("Acquired " + wCount + " weapon blueprints", Misc.getTooltipTitleAndLightHighlightColor(), "" + wCount, Misc.getHighlightColor());
            }
            if (fCount > 0) {
                Global.getSector().getCampaignUI().getMessageDisplay().addMessage("Acquired " + fCount + " fighter blueprints", Misc.getTooltipTitleAndLightHighlightColor(), "" + fCount, Misc.getHighlightColor());
            }
        }
    }

    public static List<String> getWeaponIds(Set<String> tags) {
        List<WeaponSpecAPI> specs = Global.getSettings().getAllWeaponSpecs();
        Iterator<WeaponSpecAPI> iter = specs.iterator();
        if (!tags.isEmpty()) {
            iter = specs.iterator();
            block0: while (iter.hasNext()) {
                WeaponSpecAPI curr = iter.next();
                for (String tag : tags) {
                    boolean not;
                    tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                    boolean has = curr.hasTag(tag);
                    if (not != has) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
        Collections.sort(specs, new Comparator<WeaponSpecAPI>(){

            @Override
            public int compare(WeaponSpecAPI o1, WeaponSpecAPI o2) {
                return o2.getSize().ordinal() - o1.getSize().ordinal();
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (WeaponSpecAPI spec : specs) {
            result.add(spec.getWeaponId());
        }
        return result;
    }

    public static List<String> getShipIds(Set<String> tags) {
        List<ShipHullSpecAPI> specs = Global.getSettings().getAllShipHullSpecs();
        Iterator<ShipHullSpecAPI> iter = specs.iterator();
        if (!tags.isEmpty()) {
            iter = specs.iterator();
            block0: while (iter.hasNext()) {
                ShipHullSpecAPI curr = iter.next();
                for (String tag : tags) {
                    boolean not;
                    tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                    boolean has = curr.hasTag(tag);
                    if (not != has) continue;
                    iter.remove();
                    continue block0;
                }
            }
        } else {
            specs.clear();
        }
        Collections.sort(specs, new Comparator<ShipHullSpecAPI>(){

            @Override
            public int compare(ShipHullSpecAPI o1, ShipHullSpecAPI o2) {
                return o2.getHullSize().ordinal() - o1.getHullSize().ordinal();
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (ShipHullSpecAPI spec : specs) {
            result.add(spec.getHullId());
        }
        return result;
    }

    public static List<String> getWingIds(Set<String> tags) {
        List<FighterWingSpecAPI> specs = Global.getSettings().getAllFighterWingSpecs();
        Iterator<FighterWingSpecAPI> iter = specs.iterator();
        if (!tags.isEmpty()) {
            iter = specs.iterator();
            block0: while (iter.hasNext()) {
                FighterWingSpecAPI curr = iter.next();
                for (String tag : tags) {
                    boolean not;
                    tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                    boolean has = curr.hasTag(tag);
                    if (not != has) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (FighterWingSpecAPI spec : specs) {
            result.add(spec.getId());
        }
        return result;
    }
}

