/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponBlueprintItemPlugin
extends BaseSpecialItemPlugin
implements BlueprintProviderItem {
    protected WeaponSpecAPI weapon;

    @Override
    public void init(CargoStackAPI stack) {
        super.init(stack);
        this.weapon = Global.getSettings().getWeaponSpec(stack.getSpecialDataIfSpecial().getData());
    }

    @Override
    public List<String> getProvidedFighters() {
        return null;
    }

    @Override
    public List<String> getProvidedShips() {
        return null;
    }

    @Override
    public List<String> getProvidedWeapons() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.weapon.getWeaponId());
        return result;
    }

    @Override
    public List<String> getProvidedIndustries() {
        return null;
    }

    @Override
    public void render(float x, float y, float w, float h, float alphaMult, float glowMult, SpecialItemPlugin.SpecialItemRendererAPI renderer) {
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        float blX = cx - 31.0f;
        float blY = cy - 16.0f;
        float tlX = cx - 22.0f;
        float tlY = cy + 27.0f;
        float trX = cx + 23.0f;
        float trY = cy + 27.0f;
        float brX = cx + 15.0f;
        float brY = cy - 19.0f;
        String weaponId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsWeapon(weaponId);
        float mult = 1.0f;
        Color bgColor = Global.getSector().getPlayerFaction().getDarkUIColor();
        bgColor = Misc.setAlpha(bgColor, 255);
        renderer.renderBGWithCorners(bgColor, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * mult, glowMult * 0.5f * mult, false);
        renderer.renderWeaponWithCorners(weaponId, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * mult, glowMult * 0.5f * mult, !known);
        SpriteAPI overlay = Global.getSettings().getSprite("ui", "bpOverlayWeapon");
        overlay.setColor(Color.green);
        overlay.setColor(Global.getSector().getPlayerFaction().getBrightUIColor());
        overlay.setAlphaMult(alphaMult);
        overlay.setNormalBlend();
        renderer.renderScanlinesWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult, false);
        if (known) {
            renderer.renderBGWithCorners(Color.black, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * 0.5f, 0.0f, false);
        }
        overlay.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
    }

    @Override
    public int getPrice(MarketAPI market, SubmarketAPI submarket) {
        if (this.weapon != null) {
            float base = super.getPrice(market, submarket);
            return (int)(base + this.weapon.getBaseValue() * this.getItemPriceMult());
        }
        return super.getPrice(market, submarket);
    }

    @Override
    public String getName() {
        if (this.weapon != null) {
            return String.valueOf(this.weapon.getWeaponName()) + " Blueprint";
        }
        return super.getName();
    }

    @Override
    public String getDesignType() {
        if (this.weapon != null) {
            return this.weapon.getManufacturer();
        }
        return null;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        super.createTooltip(tooltip, expanded, transferHandler, stackSource);
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        String weaponId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsWeapon(weaponId);
        ArrayList<String> weapons = new ArrayList<String>();
        weapons.add(weaponId);
        this.addWeaponList(tooltip, "Weapons:", weapons, 1, opad);
        Description desc = Global.getSettings().getDescription(this.weapon.getWeaponId(), Description.Type.WEAPON);
        tooltip.addPara(desc.getText1FirstPara(), opad);
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        if (known) {
            tooltip.addPara("Already known", g, opad);
        } else {
            tooltip.addPara("Right-click to learn", b, opad);
        }
    }

    @Override
    public boolean hasRightClickAction() {
        return true;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        String weaponId = this.stack.getSpecialDataIfSpecial().getData();
        return !Global.getSector().getPlayerFaction().knowsWeapon(weaponId);
    }

    @Override
    public void performRightClickAction() {
        String weaponId = this.stack.getSpecialDataIfSpecial().getData();
        if (Global.getSector().getPlayerFaction().knowsWeapon(weaponId)) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.weapon.getWeaponName() + ": blueprint already known");
        } else {
            Global.getSoundPlayer().playUISound("ui_acquired_blueprint", 1.0f, 1.0f);
            Global.getSector().getPlayerFaction().addKnownWeapon(weaponId, true);
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage("Acquired blueprint: " + this.weapon.getWeaponName());
        }
    }

    @Override
    public String resolveDropParamsToSpecificItemData(String params, Random random) throws JSONException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        if (!params.startsWith("{")) {
            return params;
        }
        JSONObject json = new JSONObject(params);
        int tier = json.optInt("tier", -1);
        HashSet<String> tags = new HashSet<String>();
        if (json.has("tags")) {
            JSONArray tagsArray = json.getJSONArray("tags");
            int i = 0;
            while (i < tagsArray.length()) {
                tags.add(tagsArray.getString(i));
                ++i;
            }
        }
        return this.pickWeapon(tier, tags, random);
    }

    protected String pickWeapon(int tier, Set<String> tags, Random random) {
        WeaponSpecAPI curr;
        List<WeaponSpecAPI> specs = Global.getSettings().getAllWeaponSpecs();
        Iterator<WeaponSpecAPI> iter = specs.iterator();
        while (iter.hasNext()) {
            curr = iter.next();
            if (!curr.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM)) continue;
            iter.remove();
        }
        if (tier >= 0) {
            iter = specs.iterator();
            while (iter.hasNext()) {
                curr = iter.next();
                if (curr.getTier() == tier) continue;
                iter.remove();
            }
        }
        if (!tags.isEmpty()) {
            iter = specs.iterator();
            block2: while (iter.hasNext()) {
                curr = iter.next();
                for (String tag : tags) {
                    boolean not;
                    tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                    boolean has = curr.hasTag(tag);
                    if (not != has) continue;
                    iter.remove();
                    continue block2;
                }
            }
        }
        WeightedRandomPicker<WeaponSpecAPI> picker = new WeightedRandomPicker<WeaponSpecAPI>(random);
        for (WeaponSpecAPI spec : specs) {
            picker.add(spec, 1.0f * spec.getRarity());
        }
        WeaponSpecAPI pick = (WeaponSpecAPI)picker.pick();
        if (pick == null) {
            return null;
        }
        return pick.getWeaponId();
    }
}

